=begin
 * @file    tab_out_direct.rb
 * @brief   GNZ^u؂t@Co͂GNZ
 * @author  ariizumi
 * @data    09/09/22

 * @brief   V[gʃt@Cŕۑ̂ŐFX
 * @author  toru nagihashi
 * @data    11/05/25

  tab_out.rbł͌vZZɓ͂ĂꍇA̎o͂Ă܂ߍ쐬B
  Ruby1.8WłĂwin32oleƌCugāAGNZɒڃANZXA
@t@C̏o͂sĂB

@gĂ͈͂ŏo͂Ă̂ŁAA1sڂsƁABs2ڂo͂̂ŒӁB
@
@tab_out_direct.rb <t@C> : TAB؂
@tab_out_direct.rb <t@C> -c : J}؂
@tab_out_direct.rb <t@C> -s : J}؂{󔒂o
=end


require 'win32ole'


module Worksheet
  def [] y,x
    self.Cells.Item(y,x).Value
  end
end

def getAbsolutePath filename
  fso = WIN32OLE.new('Scripting.FileSystemObject')
  return fso.GetAbsolutePathName(filename)
end


filename = getAbsolutePath(ARGV[0])
sep = "\t"
isOutSpace = FALSE
if ARGV[1] == "-c"
  sep = ","
end
if ARGV[1] == "-s"
  sep = ","
  isOutSpace = TRUE
end
if ARGV[1] == "-t"
end

xl = WIN32OLE.new('Excel.Application')

begin
  xl.Workbooks.Open(filename)
  sheetNum = xl.Worksheets.Count
  print "V[g#{sheetNum}\n"

  sheetcnt = 0
  1.upto(sheetNum) do |sheetNo|
  

    newfile = File.new( ARGV[2]+"#{sprintf("%02d",sheetcnt)}.csv", "w" )

    sheet = xl.Worksheets.Item(sheetNo)
    sheet.extend Worksheet
    useRange = sheet.UsedRange
    colNum = useRange.Columns.Count
    rowNum = useRange.Rows.Count
#    print "#{colNum}F#{rowNum}s\n"
#    print "#{useRange.Column}F#{useRange.Row}s\n"
    
    1.upto(rowNum) do |rowNo|
      1.upto(colNum) do |colNo|
        if useRange.Cells(rowNo,colNo).Value != nil
          newfile.print useRange.Cells(rowNo,colNo).Value
          newfile.print sep
        else
          if isOutSpace == TRUE
          newfile.print sep
          end
        end
      end
      newfile.print "\n"
    end
    
#    print "s#{useRange.Columns.Count}\n"
#    print "s#{useRange.Rows.Count}s\n"
    
    newfile.close
    sheetcnt+=1
    
  end
ensure
  xl.Workbooks.Close
  xl.Quit
end
