#! ruby -Ks
#[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
#
#
#	@file		hologram_mail_script_main_conv.rb
#	@brief  zObXNvgf[^Ro[^
#	@author	Toru=Nagihashi
#	@data		2012.06.05
#
#
#]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
require "conv_tool.rb"
require "hologram_mail_data.rb"
require "../../../tools/headerdata.rb"

#-------------------------------------
# `FbN
# @retval true  Ȃ
# @retval false G[
#=====================================
CSVNAME   = ARGV[0]
SADLNAME  = ARGV[1]
MSTXTNAME = ARGV[2]
OUTPUTNAME = ARGV[3]
def checkArgument
  if CSVNAME == nil
    puts "1csṽt@Cw肵Ă"
    return false
  end
  if SADLNAME == nil
    puts "2sadl̃t@Cw肵Ă"
    return false
  end
  if MSTXTNAME == nil
    puts "3mstxt̃t@Cw肵Ă"
    return false
  end
  if OUTPUTNAME == nil
    puts "4ɏo̓t@Cw肵Ă"
    return false
  end
  unless FileTest.exists?(CSVNAME)
    puts "#{CSVNAME}܂"
    return false
  end
  return true
end

#=============================================================================
#
#   W[
#
#=============================================================================
#-------------------------------------
# XNvgR}hf[^擾
#=====================================
def getCmdData( jp_name )
  $cmd_data.each{ |data|
    if data[:JP_NAME] == jp_name 
      return data
    end
  }

  p "ȃR}h͂܂#{jp_name}"
  exit(1)
  return nil
end

#-------------------------------------
# ̒`f[^擾
#=====================================
def getDefData( jp_name )
  $def_data.each{ |data|
    if data[:JP_NAME] == jp_name 
      return data
    end
  }

  ##݂ȂƂeĂ
  return nil
end

#-------------------------------------
# R}ḧ`FbN
#=====================================
def checkCmdParam( cmd, param, num )
    cmd_d = getCmdData( cmd )
    def_d = getDefData( param )

    if def_d == nil 
      return true
    else

      if num >= cmd_d[:PARAM_CNT] 
        puts "u#{cmd}v̈I[o[Ă܂Bőu#{cmd_d[:PARAM_CNT]}vI[o[u#{num}v"
        return false
      end

      if cmd_d[num] == def_d[:KIND]
        return true
      else
        puts "u#{cmd}v̈u#{param}vԈĂ܂B"
        return false
      end
    end
end

#-------------------------------------
# wb_[f[^Ro[g
#=====================================
H_ROW_START       = 0         #sJnʒu
H_ROW_DATANUM     = 1 
H_ROW_PERSON_00   = 2
H_ROW_PERSON_01   = 3
H_ROW_PERSON_02   = 4
H_ROW_PERSON_03   = 5
H_COL_START       = 0         #Jnʒu
H_COL_VALUE       = 1         #:ԍ1
def  convertHeader( csv, data, hash )

  #f[^擾
  datanum   = csv.get( H_ROW_DATANUM,     H_COL_VALUE )
  person00  = csv.get( H_ROW_PERSON_00,   H_COL_VALUE )
  person01  = csv.get( H_ROW_PERSON_01,   H_COL_VALUE )
  person02  = csv.get( H_ROW_PERSON_02,   H_COL_VALUE )
  person03  = csv.get( H_ROW_PERSON_03,   H_COL_VALUE )

  #l擾
  person00_val = getDefData( person00 )
  person01_val = getDefData( person01 )
  person02_val = getDefData( person02 )
  person03_val = getDefData( person03 )
  
  #nbVɕۑ
  hash.store( person00, person00_val[:PG_VALUE] )
  hash.store( person01, person01_val[:PG_VALUE] )
  hash.store( person02, person02_val[:PG_VALUE] )
  hash.store( person03, person03_val[:PG_VALUE] )

  #f[^    
  data.write_u16( datanum )
  data.write_u16( person00_val[:PG_VALUE] )
  data.write_u16( person01_val[:PG_VALUE] )
  data.write_u16( person02_val[:PG_VALUE] )
  data.write_u16( person03_val[:PG_VALUE] )

end

#-------------------------------------
# XNvgRo[g
#=====================================
CMD_PARAM_MAX       = 8

SCR_ROW_START       = 1         #sJnʒu
SCR_COL_START       = 0         #Jnʒu
SCR_COL_CMD         = 1         #:R}h
SCR_COL_PARAM_START = 2         #:Jn
SCR_COL_PARAM_END   = SCR_COL_PARAM_START+CMD_PARAM_MAX #:Jn
SCR_COL_PARAM_CHECK   = SCR_COL_PARAM_END   #:`FbN

def convertScript( csv, data, txt, sadl, headerHash )

  for row in SCR_ROW_START...csv.row_length-1

    #f[^擾
    cmd = csv.get( row, SCR_COL_CMD )
    cmd_d = getCmdData( cmd )

    #`FbN
    param_cnt = csv.get( row, SCR_COL_PARAM_CHECK )
    if param_cnt.to_i != 0
      puts "#{cmd}̈̐܂\n"
      exit(1)
    end

    data.write_u16( cmd_d[:PG_VALUE] )

    #`FbN
    col = SCR_COL_PARAM_START
    max = SCR_COL_PARAM_END
    while col < max do
      #擾
      param = csv.get( row, col )

      #Ƃ̂
      if param != nil
        def_d = getDefData( param )

        #̌^`FbN
        if checkCmdParam( cmd, param, col-SCR_COL_PARAM_START ) == 
          false
          exit(1)
        end

        param_name = cmd_d[col-SCR_COL_PARAM_START]

        if def_d != nil
          #`ꍇ
          
          case param_name
          when "lԍ"
            if headerHash.key?( param ) == false
              p "̐l͏oė܂#{param}"
              exit(1)
            end
            data.write_u16( def_d[:PG_VALUE] )
          else
            data.write_u16( def_d[:PG_VALUE] )
          end

        else  #if def_d != nil
          #`ȂꍇiɐlȂǁj

          case param_name
          when "SE"
            begin
              data.write_u16( sadl.search( param.to_s, cmd ) )
            rescue HeaderSearchError
              puts "SE`݂܂ #{param}\n"
              exit(1)
            end
          when "bZ[Wԍ"
            begin
              data.write_u16( txt.search( param.to_s, cmd ) )
            rescue HeaderSearchError
              puts "bZ[W݂܂ #{param}\n"
              exit(1)
            end
          else
            data.write_u16( param )
          end
        end #if def_d != nil
      else
        data.write_u16( 0 )
      end

    col += 1
    end

  end

end

#=============================================================================
#
#   C
#
#=============================================================================
begin

  #`FbN
  unless checkArgument
    exit(1)
  end

  #csvǍ
  hCsv = CsvLoader.new
  hCsv.setPrefix( '#header_start' )
  hCsv.setSuffix( '#header_end' )
  hCsv.load( CSVNAME )

  scrCsv = CsvLoader.new
  scrCsv.setPrefix( '#script_start' )
  scrCsv.setSuffix( '#script_end' )
  scrCsv.load( CSVNAME )

  #data쐬
  data    = BinaryBuilder.new
  
  #lnbV쐬
  headerHash  = Hash.new
  
  #wb_f[^̍쐬
  txtdata = HeaderDataArray.new
  txtdata.load( MSTXTNAME )

  #sadlf[^̍쐬
  sadldata = HeaderDataArray.new
  sadldata.load( SADLNAME )

  #Ro[g
  convertHeader( hCsv, data, headerHash )
  convertScript( scrCsv, data, txtdata, sadldata, headerHash )

  #date
  data.genelate( "#{OUTPUTNAME}.dat" )

end
