#! ruby -Ks
#[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
#
#
#	@file		hologram_mail_script_define_conv.rb
#	@brief  zObXNvg`Ro[^
#	@author	Toru=Nagihashi
#	@data		2012.06.05
#
#
#]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
require "conv_tool.rb"
#-------------------------------------
# `FbN
# @retval true  Ȃ
# @retval false G[
#=====================================
def checkArgument
  if ARGV[0] == nil
    puts "1csṽt@Cw肵Ă"
    return false
  end
  if ARGV[1] == nil
    puts "Qɏo̓t@Cw肵Ă"
    return false
  end
  unless FileTest.exists?(ARGV[0])
    puts "#{ARGV[0]}܂"
    return false
  end
  return true
end

#=============================================================================
#
#   W[
#
#=============================================================================
#-------------------------------------
#R}hf[^Ro[g
#=====================================
CMD_PARAM_MAX       = 8

CMD_ROW_START       = 1         #sJnʒu
CMD_COL_START       = 1         #Jnʒu
CMD_COL_PG_NAME     = CMD_COL_START     #:programl[
CMD_COL_JP_NAME     = 2         #:{l[
CMD_COL_PARAM_START = 3         #FJn
CMD_COL_PARAM_END   =  CMD_COL_PARAM_START + CMD_PARAM_MAX #FI

def convertCmd( cmdCsv, header, rb )
  #cmdCsṽRo[g
  header.write( "//XNvgR}h\n" )
  header.write( "enum CommandInfo {\n" )

  rb.write( "$cmd_data = [\n" )

  cnt = 0
  for row in CMD_ROW_START...cmdCsv.row_length-1

    pg_name  = cmdCsv.get( row, CMD_COL_PG_NAME )
    jp_name  = cmdCsv.get( row, CMD_COL_JP_NAME )

    header.write( "\tCOMMAND_NAME_#{pg_name} = #{cnt.to_i},// #{jp_name}\n" )

    rb.write( "\t{\n" )
    rb.write( "\t\t:JP_NAME=>'#{jp_name}',\n" )
    rb.write( "\t\t:PG_VALUE=>#{cnt.to_i},\n" )

    param_cnt = 0
    for idx in CMD_COL_PARAM_START...CMD_COL_PARAM_END
      param  = cmdCsv.get( row, idx )
      if param != nil
        rb.write( "\t\t#{idx-CMD_COL_PARAM_START}=>'#{param}',\n" )
        param_cnt+=1
      else
        rb.write( "\t\t#{idx-CMD_COL_PARAM_START}=>'',\n" )
      end
    end
    rb.write( "\t\t:PARAM_CNT=>#{param_cnt},\n" )
    header.write( "\tCOMMAND_NAME_#{pg_name}_PARAM_NUM  = #{param_cnt},\n" )

    rb.write( "\t},\n" )
    cnt+=1
  end

  header.write( "};\n" )
  rb.write( "]\n" )

end


#-------------------------------------
#`f[^Ro[g
#=====================================
DEF_ROW_START       = 1         #sJnʒu
DEF_COL_START       = 1         #Jnʒu
DEF_COL_PG_NAME     = DEF_COL_START     #Fprograml[
DEF_COL_JP_NAME     = 2         #F{l[
DEF_COL_VALUE       = 3         #Fl
DEF_COL_KIND        = 4         #F

def convertDef( defCsv, header, rb )
  #defCsṽRo[g
  header.write( "//XNvgR}h\n" )
  header.write( "enum CommandParam {\n" )

  rb.write( "$def_data = [\n" )

  for row in DEF_ROW_START...defCsv.row_length-1

    pg_name  = defCsv.get( row, DEF_COL_PG_NAME )
    jp_name  = defCsv.get( row, DEF_COL_JP_NAME )
    value    = defCsv.get( row, DEF_COL_VALUE )
    kind     = defCsv.get( row, DEF_COL_KIND )

    header.write( "\tCOMMAND_PARAM_#{pg_name} = #{value.to_i},//#{jp_name}\n" )

    rb.write( "\t{\n" )
    rb.write( "\t\t:JP_NAME=>'#{jp_name}',\n" )
    rb.write( "\t\t:PG_VALUE=>#{value.to_i},\n" )
    rb.write( "\t\t:KIND=>'#{kind}',\n" )
    rb.write( "\t},\n" )
  end

  header.write( "};\n" )
  rb.write( "]\n" )
end

#-------------------------------------
#fRo[g
#=====================================
PERSON_ROW_START       = 1         #sJnʒu
PERSON_COL_START       = 0         #Jnʒu
PERSON_COL_JP_NAME     = PERSON_COL_START
PERSON_COL_PG_NAME     = 1
def convertPerson( personCsv, header, rb )
  #personCsṽRo[g
  header.write( "//l`\n" )
  header.write( "enum Person{\n" )

  rb.write( "$person_data = [\n" )
  

  for row in PERSON_ROW_START...personCsv.row_length-1
    pg_name  = personCsv.get( row, PERSON_COL_PG_NAME )
    jp_name  = personCsv.get( row, PERSON_COL_JP_NAME )

    header.write( "\tPERSON_#{pg_name} = #{row-1},//#{jp_name}\n" )

    rb.write( "\t{\n" )
    rb.write( "\t\t:JP_NAME=>'#{jp_name}',\n" )
    rb.write( "\t\t:PG_VALUE=>#{row-1},\n" )
    rb.write( "\t},\n" )
  end

  rb.write( "]\n" )
  header.write( "};\n" )
end

#=============================================================================
#
#   C
#
#=============================================================================
begin

  #`FbN
  unless checkArgument
    exit(1)
  end

  #csvǍ
  cmdCsv = CsvLoader.new
  cmdCsv.setPrefix( '#cmd_data_start' )
  cmdCsv.setSuffix( '#cmd_data_end' )
  cmdCsv.load( ARGV[0] )

  defCsv = CsvLoader.new
  defCsv.setPrefix( '#define_data_start' )
  defCsv.setSuffix( '#define_data_end' )
  defCsv.load( ARGV[0] )

  personCsv = CsvLoader.new
  personCsv.setPrefix( '#person_data_start' )
  personCsv.setSuffix( '#person_data_end' )
  personCsv.load( ARGV[0] )

  #wb_쐬
  header    = TextBuilder.new
  header.write_header( "#{ARGV[1]}.h", 
                    "zObXNvg̒`ł",
                    "Toru=Nagihashi" )

  #r[t@C쐬 
  rb        = TextBuilder.new

  #Ro[g
  convertCmd( cmdCsv, header, rb )
  convertDef( defCsv, header, rb )
  #convertPerson( personCsv, header, rb )

  #
  header.genelate( "#{ARGV[1]}.h" )
  rb.genelate( "#{ARGV[1]}.rb" )

end
