#!/usr/bin/ruby
#[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
#
#
#	@file		conv_tool.rb
#	@brief  Ro[^Ɏgc[
#	@author	Toru=Nagihashi
#	@data		2011.03.03
#
#
#]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#=============================================================================
#
#   NX
#
#=============================================================================
#-------------------------------------
# GNZ[_[
#=====================================
class CsvLoader
  require "csv"

  def initialize
    @buffer
    @suffix =''
    @prefix =''

    @row_length  = 0          #s
    @col_length = Array.new   #
  end

  def setSuffix( suffix )
    @suffix = suffix
  end

  def setPrefix( prefix )
    @prefix = prefix
  end

  def load( filename )
    #suffixȂꍇ͒ʏǂݍ
    #suffixƂsuffix܂œǂݍ

    #擾
    is_next = true
    CSV.open( filename, 'r' ) do |row|

      #prefixꍇprefix܂Ŕ΂
      if @prefix != '' && row[0] != @prefix && is_next == true
        next
      end

      #xprefix΂Ȃ
      is_next = false

      @row_length  += 1
      @col_length.push( row.size )

      if @suffix != '' && row[0] == @suffix
        break
      end
    end

    #񎟌z
    @buffer = Array.new(@row_length)
    @buffer.each_index{ |i|
      @buffer[i] = Array.new(@col_length[i])
    }

    #f[^擾
    i = 0
    j = 0
    is_next = true
    CSV.open( filename, 'r' ) do |row|

      #prefixꍇprefix܂Ŕ΂
      if @prefix != '' && row[0] != @prefix && is_next == true
        next
      end
      is_next = false

      row.each do |cell|
        @buffer[j][i] = cell
        i += 1
      end

      #suffixI
      if @suffix != '' && row[0] == @suffix
        break
      end

      j += 1
      i = 0
    end
  end

  def get( row, col )
    return @buffer[row][col]
  end

  def row_length
    return @row_length
  end

  def col_length( row )
    return @col_length[ row ]
  end
end

#-------------------------------------
# eLXgt@C쐬
#=====================================
class TextBuilder
  def initialize
    @buffer       = String.new
    @header_name
  end

  def write_header( filename, brief, author )
    @header_name  = filename.gsub(/\./,'_')
    write( "//============================================================================================\n" )
    write( "/**\n" )
    write( " * @file " + filename + "\n" )
    if brief != nil 
      write( " * @brief " + brief + "\n" )
    end
    if author != nil 
      write( " * @author " + author + "\n" )
    end
    write( " * @note #{File.basename(__FILE__)}玩Ă܂B\n" )
    write( "*/\n" )
    write( "//============================================================================================\n" )
    write( "#pragma once\n" )
    #write( "#ifndef __" + @header_name.upcase + "__\n" )
    #write( "#define __" + @header_name.upcase + "__\n" )
  end

  def write_fotter
    #write( "#endif //__" + @header_name.upcase + "__\n" )
  end

  def write( str )
    @buffer << str
  end

  def genelate( filename )
    newfile = File.new( filename, "w" )
    @buffer.each{ |line|
      newfile.puts( line )
    }
    newfile.close
  end
end

#-------------------------------------
# oCit@C쐬
#=====================================
class BinaryBuilder
  def initialize
    @buffer = []
  end

  def write_u8( data )
     @buffer  << [data.to_i].pack('C')
  end

  def write_u16( data )
    @buffer   << [data.to_i].pack('S')
  end

  def write_u32( data )
    @buffer   << [data.to_i].pack('I')
  end

  def genelate( filename )
    newfile = File.new( filename, "wb" )
    @buffer.join
    newfile.write( @buffer )
    newfile.close
  end
end
