
//=============================================================================
/**
 * @file   CameraLookAtOffset.h
 * @brief  J_ItZbgNXwb_
 * @author rc N
 * @date   2012.06.07
 */
//=============================================================================

#ifndef __CAMERA_LOOK_AT_OFFSET_H__
#define __CAMERA_LOOK_AT_OFFSET_H__

#include "CameraInterpolate.h"
#include "CameraTarget.h"

namespace field
{
  //-----------------------------------------------------------------------------
  /**
   * @brief _̈ʒuItZbg𐧌䂷NX
   */
  //-----------------------------------------------------------------------------
  class CCameraLookAtOffset
  {
  private:
    CDoubleSpringInterpolate3D m_inLocalOfst;
    gfl::math::VEC3            m_inHopeLocalOfst;
	float                      m_fOfstXTimer;

  public:
    CCameraLookAtOffset(); ///< RXgN^

    //-----------------------------------------------------------------------------
    /**
     * @brief t[
     *
     * @param fOfstMaxX ItZbgX̍ől
     * @param fOfstMaxY ItZbgY̍ől
     * @param inTarget  ^[Qbg
     * @param inCamera  J
     * @param inLookAtBasePrePosi Pt[O̒_ʒu
     * @param eMode     [h
     * @param fDiffTime oߎ
     */
    //-----------------------------------------------------------------------------
    void Update(float fOfstMaxX, float fOfstMaxY, const CCameraTarget& inTarget, const CCameraInfo& inCamera, const gfl::math::VEC3& inLookAtBasePrePosi, const ECameraBehindMode eMode, const float fDiffTime);
    void DrawDebug(); ///< fobO`

    /// ItZbgʒu擾
    void GetPosition(gfl::math::VEC3* pPosi, const CCameraInfo& inCamera) const { gfl::math::VEC3Transform(pPosi, &inCamera.m_inMatrix, &m_inLocalOfst.GetValue()); }
  };

} // namespace field

#endif // __CAMERA_LOOK_AT_OFFSET_H__

/*  EOF  */





