
//=============================================================================
/**
 * @file   CameraLookAtOffset.cpp
 * @brief  J_ItZbgNX
 * @author rc N
 * @date   2012.06.07
 */
//=============================================================================

#include "CameraLookAtOffset.h"

namespace field
{
  //-----------------------------------------------------------------------------
  // RXgN^
  //-----------------------------------------------------------------------------
  CCameraLookAtOffset::CCameraLookAtOffset() :
  m_inHopeLocalOfst(gfl::math::VEC3_ZERO) ,
  m_fOfstXTimer(0.0f)
  {
    return ;
  }

  //-----------------------------------------------------------------------------
  // t[
  //-----------------------------------------------------------------------------
  void CCameraLookAtOffset::Update(float fOfstMaxX, float fOfstMaxY, const CCameraTarget& inTarget, const CCameraInfo& inCamera, const gfl::math::VEC3& inLookAtBasePrePosi, const ECameraBehindMode eMode, const float fDiffTime)
  {
    if( eMode != CAMERA_BEHIND_MODE_RESET )
    {
      // ^[QbgʒugpƁA}~ƂɂItZbgĂ܂AJbR̂Œ_ʒugp
      gfl::math::VEC3 inCamAxisZ; gfl::math::MTX33GetAxisZ(&inCamAxisZ, inCamera.m_inMatrix);
      const float fDistZ = gfl::math::FAbs(CUtil::GetAxisLength(inLookAtBasePrePosi - inCamera.m_inPosi, inCamAxisZ));
      inCamera.GetScreenLengthHalf(&fOfstMaxX, &fOfstMaxY, fDistZ);
    }

    const float fPreHopeLocalOfstX = m_inHopeLocalOfst.x;

    m_inHopeLocalOfst.x = 0.15f*fOfstMaxX;
    m_inHopeLocalOfst.y = CONVERT_TO_METER(0.53f);

    if( eMode == CAMERA_BEHIND_MODE_RESET )
    {
      m_inHopeLocalOfst.x *= -1.0f; ///< ŏ͍肪悢̂Ń}CiX
      m_inLocalOfst.Reset(m_inHopeLocalOfst);
      m_fOfstXTimer = 0.0f;
    }
    else
    {
      // RWɂ莋_E_ԋk܂̓ItZbgYωĊ悤ɂ
      // m_inHopeLocalOfst.y = getRatioZeroOneInterpolateValue(pModeCommonData->m_fLookAtOfstYDistZero,m_inHopeLocalOfst.y,getInterpolateRatioValue(inCamera.m_fDistToLookAt,0.0f,1.5f*GAME_BASE_LENGTH));

      /* ^[QbǧɂēIɉItZbgXV */
      gfl::math::VEC3 inCamAxisX; gfl::math::MTX33GetAxisX(&inCamAxisX, inCamera.m_inMatrix);
      const float fCos = gfl::math::VEC3Dot(&inTarget.GetDirection(), &inCamAxisX);

      float fChangeCos = 0.0f;
      if( fPreHopeLocalOfstX != 0.0f )
      {
        fChangeCos = 0.499966293573380f; // cosf(TIL_TO_RADIAN(60.0f))
        if( fPreHopeLocalOfstX > 0.0f ) fChangeCos *= -1.0f;
      }

      if( fCos < fChangeCos ) m_inHopeLocalOfst.x *= -1.0f;

      // pɂȉItZbg؂芷h~
      if( m_inHopeLocalOfst.x*fPreHopeLocalOfstX < 0.0f )
      {
        const float KEEP_TIME = 0.2f;
        m_fOfstXTimer += fDiffTime;
        if( m_fOfstXTimer > KEEP_TIME ) m_fOfstXTimer = 0.0f;
        else                            m_inHopeLocalOfst.x *= -1.0f;
      }
      else
      {
        m_fOfstXTimer -= fDiffTime;
        CUtil::ZeroClip(&m_fOfstXTimer);
      }

      m_inLocalOfst.SetParam(3.5f);
      m_inLocalOfst.Update(m_inHopeLocalOfst, fDiffTime);
    }
  }

  //-----------------------------------------------------------------------------
  // fobO`
  //-----------------------------------------------------------------------------
  void CCameraLookAtOffset::DrawDebug()
  {
#if 0
    gfl::grp::util::DrawUtil::DrawText(10, 10, L"%.2f/%.2f %.2f/%.2f %.2f/%.2f", 
      m_inLocalOfst.GetValue().x, m_inHopeLocalOfst.x, m_inLocalOfst.GetValue().y, m_inHopeLocalOfst.y, m_inLocalOfst.GetValue().z, m_inHopeLocalOfst.z);
    gfl::grp::util::DrawUtil::DrawText(10, 20, L"%.2f", m_fOfstXTimer);
#endif
  }

} // namespace field

/*  EOF  */





