//============================================================================================
/**
 * @brief orrʐMp}b`O
 *
 *        PSSŏ҂ꂽΐǗ邽߂̃NX
 */
//============================================================================================

#include <netapp/pss/PssTradeMatchingInfo.h>

namespace netapp {
namespace pss {


//--------------------------------------------------------------------------------------------
/**
* @brief  RXgN^
*/
//--------------------------------------------------------------------------------------------
PssTradeMatchingInfo::PssTradeMatchingInfo( void )
{
}

//--------------------------------------------------------------------------------------------
/**
* @brief  fXgN^
*/
//--------------------------------------------------------------------------------------------
PssTradeMatchingInfo::~PssTradeMatchingInfo( void )
{
}

//--------------------------------------------------------------------------------------------
/**
* @brief  ʐMÎ҂̃thL[擾
*
* @param  hostUser      zXg[U[̃thL[
* @param  ticketID      Î҂s`PbgID
* @param  isWifi        WifiڑȂtrueAWirelessڑȂfalsew
* @param  guestUserNum  Ҏ҂ƂĊm肵Ă郆[U[
* @param  guestUsers    Ҏ҂̃thL[Xg
*
* @return none
*/
//--------------------------------------------------------------------------------------------
void PssTradeMatchingInfo::SetupHost( const gflnet::friends::FriendKey &hostUser,
                                       u32 ticketID,
                                       bool isWifi,
                                       u32 guestUserNum,
                                       const gflnet::friends::FriendKey& guestUsers )
{
  m_hostUser     = hostUser;
  m_guestUser    = guestUsers;
  //
  m_ticketID     = ticketID;
  m_guestUserNum = guestUserNum;
  //
  m_isWifi       = isWifi;
  m_isCommitUser = (guestUserNum!=0);
}


//--------------------------------------------------------------------------------------------
/**
* @brief  QXg[U[̃thL[擾
*
* @param  index 擾ΏۃCfbNXiÔݎw\j
*
* @return QXg[U[̃thL[
*/
//--------------------------------------------------------------------------------------------
gflnet::friends::FriendKey PssTradeMatchingInfo::GetGuestUser( u32 index ) const
{
  GFL_ASSERT( (index==0) );
  return GetHostUser();
}


//--------------------------------------------------------------------------------------------
/**
* @brief  ʐMÎ҂̃thL[擾
*
* @param  none
*
* @return Î҃[U[̃thL[
*/
//--------------------------------------------------------------------------------------------
gflnet::friends::FriendKey PssTradeMatchingInfo::GetHostUser( void ) const
{
  return m_hostUser;
}


//--------------------------------------------------------------------------------------------
/**
* @brief  QXg[U[̃thL[擾
*
* @param  none
*
* @return QXg[U[̃thL[
*/
//--------------------------------------------------------------------------------------------
gflnet::friends::FriendKey PssTradeMatchingInfo::GetGuestUser( void ) const
{
  return m_guestUser;
}


//--------------------------------------------------------------------------------------------
/**
* @brief  ʐMŏҎ҂ƂĊm肵ĂQXg[U[擾
*
* @param  none
*
* @return ҂ĂQXg[U[
*/
//--------------------------------------------------------------------------------------------
u32  PssTradeMatchingInfo::GetGuestNum( void ) const
{
  return m_guestUserNum;
}


//--------------------------------------------------------------------------------------------
/**
* @brief  ʐMŕKvƂȂ鏵Ҏ҂̎Q
*
* @param  none
*
* @return KvȏҎҐ
*/
//--------------------------------------------------------------------------------------------
u32  PssTradeMatchingInfo::GetNeedGuestNum( void ) const
{
  return 1;
}


//--------------------------------------------------------------------------------------------
/**
* @brief  `Pbghc擾
*
* @param  none
*
* @return ҎÎ҂s`Pbghc
*/
//--------------------------------------------------------------------------------------------
u32  PssTradeMatchingInfo::GetTicketID( void ) const
{
  return m_ticketID;
}


//--------------------------------------------------------------------------------------------
/**
* @brief  WifiڑԂ̎擾
*
* @param  none
*
* @return WifiڑԂȂtrueAWirelessڑԂȂfalseԋp
*/
//--------------------------------------------------------------------------------------------
bool  PssTradeMatchingInfo::IsWifi( void ) const
{
  return m_isWifi;
}


//--------------------------------------------------------------------------------------------
/**
* @brief  mQ҂𔻒
*
* @param  void
*
* @return mQ҂Ȃtrueԋp
*/
//--------------------------------------------------------------------------------------------
bool  PssTradeMatchingInfo::IsCommitUser( void ) const
{
  return m_isCommitUser;
}


//--------------------------------------------------------------------------------------------
/**
* @brief  w̃`Pbg񂪎gǗ`Pbgƈv邩
*
* @param  hostUser     zXg[U[̃thL[
* @param  ticketID     Î҂s`PbgID
*
* @return w`Pbg̑ΐ}b`OƈvȂtrueԋp
*/
//--------------------------------------------------------------------------------------------
bool PssTradeMatchingInfo::IsSameTicket( const gflnet::friends::FriendKey &hostUser, u32 ticketID ) const
{
  return (ticketID==m_ticketID) && netapp::pss::PssPersonalData::IsSameFriendKey(m_hostUser, hostUser);
}


//--------------------------------------------------------------------------------------------
/**
* @brief  w胆[U[Q҃Xgɒǉ
*
* @param  targetUser  o^Ώێ҂̃thL[
*
* @return none
*/
//--------------------------------------------------------------------------------------------
void  PssTradeMatchingInfo::AddUser( const gflnet::friends::FriendKey& targetUser )
{
  if( m_guestUserNum < GetNeedGuestNum() )
  {
    m_guestUser = targetUser;
    m_guestUserNum++;
  }
}


//--------------------------------------------------------------------------------------------
/**
* @brief  w胆[U[Q҃Xg폜
*
* @param  targetUser  폜Ώێ҂̃thL[
*
* @return none
*/
//--------------------------------------------------------------------------------------------
void PssTradeMatchingInfo::DeleteUser( const gflnet::friends::FriendKey& targetUser )
{
  if( m_guestUserNum > 0 )
  {
    if( netapp::pss::PssPersonalData::IsSameFriendKey(m_guestUser, targetUser) )
    {
      m_guestUserNum = 0;
    }
  }

}





}		// pss
}		// netapp

