//============================================================================================
/**
 * @brief orrTuvZXug[h\ݑJځiWifi/Wireless)vNX
 */
//============================================================================================
#ifndef __PSS_SUBPROC_TRADE_REQUEST_BEACON_H__
#define __PSS_SUBPROC_TRADE_REQUEST_BEACON_H__


#include "pss_subproc_base.h"
#include "pss_subproc_matching_lib.h"
#include <netapp/pss/PssTradeMatchingInfo.h>

namespace field {
namespace subscreen {
namespace pss {
namespace subproc {


class PssSubProcTradeRequestWithBeacon : public PssSubProcBase, public PssSubProcMatchingLib
{
public:
  //--------------------------------------------------------------------------------------------
  /**
  * @brief   RXgN^
  *
  * @param   none
  *
  * @return  none
  */
  //--------------------------------------------------------------------------------------------
  PssSubProcTradeRequestWithBeacon( void );

  //--------------------------------------------------------------------------------------------
  /**
  * @brief   fXgN^
  *
  * @param   none
  *
  * @return  none
  */
  //--------------------------------------------------------------------------------------------
  virtual ~PssSubProcTradeRequestWithBeacon( void );

public:
  //--------------------------------------------------------------------------------------------
  /**
  * @brief   
  *
  * @param   gameProcMgr        GameProcManagerւ̃|C^
  * @param   layout             LayoutSystemւ̃|C^
  * @param   beaconResponder    PssBeaconResponderւ̃|C^
  * @param   iconMgr            PlayerIconManagerւ̃|C^
  * @param   topList            PSSgbvXgvZXւ̃|C^
  * @param   topListUIListener  PSSgbvXgpftHgUIXi
  * @param   msgData            bZ[Wf[^
  * @param   wordset            [hZbg
  * @param   invitedUser        PSSŒڑIꂽ[U[̃thL[
  * @param   paramWork          Procp[^p̈
  *
  * @return  PssSubProcBaseւ̃|C^
  */
  //--------------------------------------------------------------------------------------------
  PssSubProcBase* Init( gamesystem::GameProcManager *gameProcMgr,
                        gfl::grp::g2d::LytSys *layout,
                        netapp::pss::PssBeaconResponder* beaconResponder,
                        xy_system::player_icon::PlayerIconManager* iconMgr,
                        app::pss::pss_top_list::Proc* topList,
                        app::pss::pss_top_list::PssTopListUIListener* topListUIListener,
                        const gflnet::friends::FriendKey& invitedUser,
                        gfl::str::MsgData* msgData, WordSet* wordset, void* paramWork );

  //--------------------------------------------------------------------------------------------
  /**
  * @brief   XV
  *
  * @param   none
  *
  * @return  sʃR[h
  */
  //--------------------------------------------------------------------------------------------
  virtual field::subscreen::pss::E_PSS_PROC_RESULT Update( void );


private:
  //uꂽlƒʐMvj[ʃCV[PX
  typedef enum {
    MAINSEQ_PLAYER_SELECT,
    MAINSEQ_CHECK_USER,
    MAINSEQ_SAVE,
    MAINSEQ_NETWORK_CALLING,
    MAINSEQ_REQUEST_CANCEL,
    MAINSEQ_REQUEST_FAILED,

    MAINSEQ_GOTO_TRADE, // ʂ
    MAINSEQ_CANCEL,     // Lj[
    MAINSEQ_STOP,       // Cj[
  }E_TRADE_REQUEST_SEQUENCE;


private:
  E_TRADE_REQUEST_SEQUENCE PlayerSelect(void);
  E_TRADE_REQUEST_SEQUENCE Save(void);
  E_TRADE_REQUEST_SEQUENCE RequestCancel(void);
  E_TRADE_REQUEST_SEQUENCE RequestFailed(void);
  E_TRADE_REQUEST_SEQUENCE CheckUser(void);
  E_TRADE_REQUEST_SEQUENCE NetworkCalling(void);
  bool InitPlayerSelect(void);
  void InitSave(void);
  bool InitRequest(void);
  void InitRequestCancel(void);
  void InitCheckUser( void );
  bool InitNetworkCalling(void);
  void InitTradeCancelAction( void );
  //
  void CancelTradeRequest( void );
  void StartTradeRequest( void );
  void SetMachingInfo( void );

private:
  static const u32   MATCHING_PLAYER_MAX = 4;

private:
  E_TRADE_REQUEST_SEQUENCE                      m_seq;                  // V[PX
  xy_system::player_icon::PlayerIconManager*    m_playerIconMgr;        // vC[ACR}l[W
  app::pss::pss_rule_select::PssRuleSettingInfo m_battleRuleSetting;    // g[h[
  netapp::pss::PssPersonalDataManager*          m_pssPersonalMgr;       // PSSp[\i}l[W
  gfl::str::MsgData*                            m_msgData;              // bZ[Wf[^
  WordSet*                                      m_wordset;              // [hZbg
  app::pss::pss_top_list::Proc*                 m_topListProc;          // gbvXgpPROC
  u32                                           m_playMode;             // vC[h
  gflnet::friends::FriendKey                    m_invitedUser;          // g[hҊm(PSS璼ڑIꂽ[U[j
  gflnet::friends::FriendKey                    m_guestUser;            // g[hҎ
  u32                                           m_guestUserNum;         // g[hҎҐ
  app::pss::pss_top_list::PssTopListUIListener* m_topListUIListener;    // gbvy[WthXi
};




}		// subproc
}		// pss
}		// subscreen
}		// field


#endif

