//============================================================================================
/**
 * @brief orrTuvZXug[h\ݎMiq@jvNX
 */
//============================================================================================
#include "pss_subproc_battle_receive.h"


namespace field {
namespace subscreen {
namespace pss {
namespace subproc {


//--------------------------------------------------------------------------------------------
/**
* @brief   RXgN^
*
* @param   none
*
* @return  none
*/
//--------------------------------------------------------------------------------------------
PssSubProcTradeReceive::PssSubProcTradeReceive( void ) : PssSubProcBase()
{
}

//--------------------------------------------------------------------------------------------
/**
* @brief   fXgN^
*
* @param   none
*
* @return  none
*/
//--------------------------------------------------------------------------------------------
PssSubProcTradeReceive::~PssSubProcTradeReceive( void )
{
}


//--------------------------------------------------------------------------------------------
/**
* @brief   
*
* @param   gameProcMgr     GameProcManagerւ̃|C^
* @param   layout          LayoutSystemւ̃|C^
* @param   beaconResponder PssBeaconResponderւ̃|C^
* @param   iconMgr         PlayerIconManagerւ̃|C^
* @param   hostUser        \҂̃thL[
* @param   msgData         bZ[Wf[^
* @param   wordset         [hZbg
* @param   paramWork       Procp[^p̈
*
* @return  PssSubProcBaseւ̃|C^
*/
//--------------------------------------------------------------------------------------------
PssSubProcBase* PssSubProcTradeReceive::Init(
                      gamesystem::GameProcManager *gameProcMgr,
                      gfl::grp::g2d::LytSys *layout,
                      netapp::pss::PssBeaconResponder* beaconResponder,
                      xy_system::player_icon::PlayerIconManager* iconMgr,
                      const gflnet::friends::FriendKey& hostUser,
                      gfl::str::MsgData* msgData, WordSet* wordset, void* paramWork )
{
  InitBase( gameProcMgr, layout, beaconResponder, paramWork );
  InitPssMatchingLib( m_gameMgr->GetGameData()->GetPssTradeMachingInfo() );

  m_pssPersonalMgr  = m_gameMgr->GetPssPersonalDataManager();
  m_playerIconMgr   = iconMgr;
  m_msgData         = msgData;
  m_wordset         = wordset;
  m_seq             = TRADE_RECIVE_MAINSEQ_CATCH;

  SetMatchingInfo( gameProcMgr, hostUser );
  InitTradeReceiveCatch();

  return this;
}


//--------------------------------------------------------------------------------------------
/**
* @brief   }b`O̐ݒ
*
* @param   gameProcMgr     GameProcManagerւ̃|C^
* @param   hostUser        \҂̃thL[
*
* @return  none
*/
//--------------------------------------------------------------------------------------------
void PssSubProcTradeReceive::SetMatchingInfo( gamesystem::GameProcManager *gameProcMgr, const gflnet::friends::FriendKey& hostUser )
{
  netapp::pss::PssPersonalDataManager* pssPersonalMgr = m_gameMgr->GetPssPersonalDataManager();
  netapp::pss::PssPersonalData*        hostPersonal   = pssPersonalMgr->GetPersonalData( hostUser );
  GFL_ASSERT( (hostPersonal != NULL) );

  const netapp::pss::PacketTradeInvite&  invite = hostPersonal->GetPacketTradeInvite();
  gflnet::friends::FriendKey             guests;

  if( invite.isWIFI ){
    guests.initialize( static_cast<gflnet::friends::PrincipalId>(invite.guestFriendKey) );
  }
  else{
    guests.initialize( static_cast<gflnet::friends::LocalFriendCode>(invite.guestFriendKey) );
  }

  // }b`Oݒ
  m_tradeMatchingInf->SetupHost( hostUser,
                            invite.ticketID,
                            invite.isWIFI,
                            invite.guestUserNum, guests );
}


//--------------------------------------------------------------------------------------------
/**
* @brief   XV
*
* @param   none
*
* @return  ANZXR[h
*/
//--------------------------------------------------------------------------------------------
field::subscreen::pss::E_PSS_PROC_RESULT PssSubProcTradeReceive::Update( void )
{
  switch( m_seq )
  {
    case TRADE_RECIVE_MAINSEQ_CATCH:
      m_seq = MainSeq_TradeReceiveCatch();
      break;
    case TRADE_RECIVE_MAINSEQ_SAVE:
      m_seq = MainSeq_TradeReceiveSave();
      break;
    case TRADE_RECIVE_MAINSEQ_MATCHING:
      m_seq = MainSeq_TradeReceiveMatching();
      break;
    case TRADE_RECIVE_MAINSEQ_CANCEL_ACTION:
      m_seq = MainSeq_TradeReceiveCancelAction();
      break;
  }

  if( m_seq == TRADE_RECIVE_MAINSEQ_COLOSSEUM_TRADE ){
    return RET_TRADE_GOTO_TRADE;
  }
  else if( m_seq == TRADE_RECIVE_MAINSEQ_CANCEL )
  {
    SetReciveTrade(false);    // sQӎv𑼎҂ɑM
    return RET_TRADE_CANCEL;
  }

  return RET_NONE;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   󂯓ʁFuJnv
 *
 * @param   none
 *
 * @return  ȂtrueAsȂfalseԋp
 */
//--------------------------------------------------------------------------------------------
bool PssSubProcTradeReceive::InitTradeReceiveCatch(void)
{
  netapp::pss::PssPersonalData*  hostUser = m_pssPersonalMgr->GetPersonalData( m_tradeMatchingInf->GetHostUser() );

  // Î҂ItCH
  if( (hostUser == NULL) || !hostUser->IsOnline() ){
    return false;
  }

  const netapp::pss::PacketPersonalInfo&  personal   = hostUser->GetPacketPersonalInfo();
  const netapp::pss::PacketTradeInvite&   battleInfo = hostUser->GetPacketTradeInvite();

  // PROC
  app::pss::pss_user_notify::APP_PARAM *param = static_cast<app::pss::pss_user_notify::APP_PARAM*>(m_paramWork);
  param->m_layout          = m_layout;
  param->m_messageData     = m_msgData;
  param->m_wordset         = m_wordset;
  param->m_execMode        = app::pss::pss_user_notify::E_MODE_TRADE_NOTIFY;
  param->m_playerIconMgr   = m_playerIconMgr;
  param->m_targetPlayerNum = 1;

  // Ҏ҂ݒ
  param->m_targetPlayer[0].initialize( personal.myPrincipalId, personal.myLocalFriendCode );

  m_subProc = dll::CreatePssUserNotifyProc( m_gameProcMgr, param );
  m_subProc->InitFunc( m_gameProcMgr );

  return true;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		󂯓ʃCV[PXF󂯂邩H
 *
 * @param		none
 *
 * @return	e
 */
//--------------------------------------------------------------------------------------------
PssSubProcTradeReceive::E_TRADE_RECIVE_SEQUENCE PssSubProcTradeReceive::MainSeq_TradeReceiveCatch(void)
{
  if( !UpdateSubProc() )
  {
    app::pss::pss_user_notify::APP_PARAM *param = static_cast<app::pss::pss_user_notify::APP_PARAM*>(m_paramWork);

    if( param->m_isSelectYes )
    {
      //InitTradeReceiveSave();
      //return TRADE_RECIVE_MAINSEQ_SAVE;

      // @TODO SROM̓Z[uȂ
      InitTradeReceiveStand();
      return TRADE_RECIVE_MAINSEQ_MATCHING;
    }
    else
    {
      gfl::grp::Fade_Reset( gfl::grp::Fade::DISP_LOWER );
      return TRADE_RECIVE_MAINSEQ_CANCEL;
    }
  }


  return TRADE_RECIVE_MAINSEQ_CATCH;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   󂯓ʁFuZ[uʁv
 *
 * @param   none
 *
 * @return  none
 */
//--------------------------------------------------------------------------------------------
void PssSubProcTradeReceive::InitTradeReceiveSave(void)
{
  app::report::APP_PARAM *param = static_cast<app::report::APP_PARAM*>(m_paramWork);
  param->m_layout       = m_layout;
  param->m_isEnableFade = false;
  param->m_heap         = gfl::heap::Manager::GetHeapByHeapId( HEAPID_FIELDMENU );
  param->m_devHeap      = gfl::heap::Manager::GetHeapByHeapId( HEAPID_FIELDMENU_DEV );

  m_subProc = dll::CreateReportMenuProc( m_gameProcMgr, param );
  m_subProc->InitFunc( m_gameProcMgr );
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		󂯓ʃCV[PXFZ[u
 *
 * @param		none
 *
 * @return	e
 */
//--------------------------------------------------------------------------------------------
PssSubProcTradeReceive::E_TRADE_RECIVE_SEQUENCE PssSubProcTradeReceive::MainSeq_TradeReceiveSave(void)
{
  if( !UpdateSubProc() )
  {
    app::report::APP_PARAM *param = static_cast<app::report::APP_PARAM*>(m_paramWork);

    if( param->m_isSaveSuccess )
    {
      InitTradeReceiveStand();
      return TRADE_RECIVE_MAINSEQ_MATCHING;
    }
    else
    {
      gfl::grp::Fade_Reset( gfl::grp::Fade::DISP_LOWER );
      return TRADE_RECIVE_MAINSEQ_CANCEL;
    }
  }

  return TRADE_RECIVE_MAINSEQ_SAVE;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   󂯓ʁFuڑ҂v
 *
 * @param   none
 *
 * @return  none
 */
//--------------------------------------------------------------------------------------------
void PssSubProcTradeReceive::InitTradeReceiveStand(void)
{
  app::pss::pss_message_window::APP_PARAM *param = static_cast<app::pss::pss_message_window::APP_PARAM*>(m_paramWork);

  param->m_layout        = m_layout;
  param->m_messageData   = m_msgData;
  param->m_wordset       = m_wordset;
  param->m_type          = app::pss::pss_message_window::E_TYPE_MESSAGE;
  param->m_messageText   = msg_pss_05_11_01;  // ł܂ŁA΂炭܂
  param->m_playerIconMgr = m_playerIconMgr;
  param->m_isDispLoading = true;
  param->m_inputLock     = true;

  // ʐMJnԂL^
  gfl::std::DateTime::GetNow( &m_connectStartingTime );

  m_subProc = dll::CreatePssMessageWindow( m_gameProcMgr, param );
  m_subProc->InitFunc( m_gameProcMgr );

  // Qӎv𑼎҂ɑM
  SetReciveTrade( true );
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   󂯓ʁFuڑvvZX
 *
 * @param   none
 *
 * @return  e
 */
//--------------------------------------------------------------------------------------------
PssSubProcTradeReceive::E_TRADE_RECIVE_SEQUENCE PssSubProcTradeReceive::MainSeq_TradeReceiveMatching(void)
{
  netapp::pss::PssPersonalDataManager* pssPersonalMgr = m_gameMgr->GetPssPersonalDataManager();
  netapp::pss::PssPersonalData*        hostUser       = pssPersonalMgr->GetPersonalData( m_tradeMatchingInf->GetHostUser() );
  app::pss::pss_message_window::Proc*  messageProc    = static_cast<app::pss::pss_message_window::Proc*>(m_subProc);

  UpdateSubProc();

  bool isDisconnect = false;

  if( (hostUser == NULL) || !hostUser->IsOnline() )
  {
    GFL_PRINT( "ERROR_REASON_1[%x] \n", hostUser );

    // Î҂ItC
    isDisconnect = true;
  }
  else
  {
    const netapp::pss::PacketTradeInvite& inviteInf = hostUser->GetPacketTradeInvite();

    // Î҂̃`PbghcAݕێĂhcƕsv
    if( !m_tradeMatchingInf->IsSameTicket( hostUser->GetFriendKey(), inviteInf.ticketID ) ){
      GFL_PRINT( "ERROR_REASON_2 \n" );
      isDisconnect = true;
    }
    // e~ʒm
    else if( hostUser->GetRequestCommand() == netapp::pss::PssDefine::E_PSS_PACKET_REQUEST_TRADE_CANCEL ){
      GFL_PRINT( "ERROR_REASON_3 \n" );
      isDisconnect = true;
    }
    // mQ҂Q
    else if( IsTradeGuestUserDisJoin( m_pssPersonalMgr ) ){
      GFL_PRINT( "ERROR_REASON_4 \n" );
      isDisconnect = true;
    }
    // eJnʒm
    else if( hostUser->GetRequestCommand() == netapp::pss::PssDefine::E_PSS_PACKET_REQUEST_TRADE_CONNECT )
    {
      if( messageProc->IsEnableFinish() )
      {
        ReleaseProc( &m_subProc );
        return TRADE_RECIVE_MAINSEQ_COLOSSEUM_TRADE;
      }
    }
  }

  // 60bԂŃ^CAEg
  if( IsTimeout( 60000 ) || isDisconnect )
  {
    if( messageProc->IsEnableFinish() )
    {
GFL_PRINT( "ERROR_ACTION  \n" );
      ReleaseProc( &m_subProc );
      InitTradeReceiveCancelAction();
      return TRADE_RECIVE_MAINSEQ_CANCEL_ACTION;
    }
  }

  return TRADE_RECIVE_MAINSEQ_MATCHING;
}



//--------------------------------------------------------------------------------------------
/**
 * @brief   󂯓ʁFuڑLZv
 *
 * @param   none
 *
 * @return  e
 */
//--------------------------------------------------------------------------------------------
void PssSubProcTradeReceive::InitTradeReceiveCancelAction( void )
{
  app::pss::pss_message_window::APP_PARAM *param = static_cast<app::pss::pss_message_window::APP_PARAM*>(m_paramWork);

  param->m_layout        = m_layout;
  param->m_messageData   = m_msgData;
  param->m_wordset       = m_wordset;
  param->m_type          = app::pss::pss_message_window::E_TYPE_MESSAGE;
  param->m_messageText   = msg_pss_10_11_01;  // sȂ܂B𒆎~܂B
  param->m_playerIconMgr = m_playerIconMgr;
  param->m_isDispLoading = false;
  param->m_inputLock     = false;

  m_subProc = dll::CreatePssMessageWindow( m_gameProcMgr, param );
  m_subProc->InitFunc( m_gameProcMgr );
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   󂯓ʁFuڑLZvvZX
 *
 * @param   none
 *
 * @return  e
 */
//--------------------------------------------------------------------------------------------
PssSubProcTradeReceive::E_TRADE_RECIVE_SEQUENCE PssSubProcTradeReceive::MainSeq_TradeReceiveCancelAction(void)
{
  // \݂LZ
  if( !UpdateSubProc() )
  {
    gfl::grp::Fade_Reset( gfl::grp::Fade::DISP_LOWER );
    return TRADE_RECIVE_MAINSEQ_CANCEL;
  }

  return TRADE_RECIVE_MAINSEQ_CANCEL_ACTION;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   ҂ւ̕ԓpPbg𑗐M
 *
 * @param   isJoin QȂtrueAQfȂfalsew
 *
 * @return  none
 */
//--------------------------------------------------------------------------------------------
void PssSubProcTradeReceive::SetReciveTrade( bool isJoin )
{
  netapp::pss::PssPersonalData* personal = m_pssPersonalMgr->GetMyData();
  personal->SetRecieveTrade( m_tradeMatchingInf->GetHostUser(), m_tradeMatchingInf->GetTicketID(), isJoin, m_tradeMatchingInf->IsWifi() );
  m_beaconResponder->SendMyData();
}







}		// subproc
}		// pss
}		// subscreen
}		// field

