//======================================================================
/**
 * @file	ari_bg_test.h
 * @brief	wieXg
 * @author	ariizumi
 * @data	12/06/06
 */
//======================================================================
#ifndef __ARI_BG_TEST_H__
#define __ARI_BG_TEST_H__

#include <gflib.h>
#include "gamesystem/GameManager.h"
#include "gamesystem/GameProcManager.h"
#include "gamesystem/GameProc.h"

#include "system/background/bg_system.h"

namespace test
{
namespace ariizumi
{
//V[O[v
enum
{
  BGTEST_SCENE_NORMAL,      //ʏ̃f
  BGTEST_SCENE_POST_EFFECT, //ꏈp
  BGTEST_SCENE_EDGE,        //GbWp

  BGTEST_SCENE_MAX,
};

class AriBgTest:public gamesystem::GameProc
{
public:
  //------------------------------------------------------------------
  /**
   * @brief	  PROC̏s֐
   * @return	Result 삪I RES_FINISHԂĂ炤MainFuncɐi
   */
  //------------------------------------------------------------------
  virtual gfl::proc::Result InitFunc(gfl::proc::Manager* pManager);
  //------------------------------------------------------------------
  /**
   * @brief	  PROC̃Cs֐
   * @return	Result 삪I RES_FINISHԂĂ炤EndFuncɐi
   */
  //------------------------------------------------------------------
  virtual gfl::proc::Result UpdateFunc(gfl::proc::Manager* pManager);
  virtual void DrawFunc(gfl::proc::Manager* pManager);
  //------------------------------------------------------------------
  /**
   * @brief	  PROC̏Is֐
   * @return	Result 삪I RES_FINISHԂĂ炤ŏIƉ߂
   */
  //------------------------------------------------------------------
  virtual gfl::proc::Result EndFunc(gfl::proc::Manager* pManager);

  virtual gamesystem::FrameMode GetFrameMode( void ) const { return gamesystem::FRAMEMODE_30; }

  void InitSystem(void);
  void TermSystem(void);
  
  bool UpdateSystem(void);
  void DrawSystem(void);
  
  void InitDebug(void);
  
  gfl::heap::HeapBase* mHeapMem;
  gfl::heap::HeapBase* mDeviceMem;

  //eAP[^
  gfl::heap::NwAllocator* mHeapAllocater;
  gfl::heap::NwAllocator* mDeviceAllocater;

  //OtBbNnVXe

  static const f32 NEAR_PLANE = 32.0f;
  static const f32 FAR_PLANE  = 6000.0f;
  static const f32 LAYOUT_DOWN_OFS = -1000.0f;

  gfl::grp::GraphicsSystem*     mGrpSys;
  gfl::grp::g2d::LytSys*        mLytSys;
  gfl::grp::g3d::System*        mG3dSys;

  gfl::grp::g3d::Scene*         mScene;
  gfl::grp::g3d::StereoCamera*  mCamera;
  gfl::grp::g3d::Resource *mResEnv;

  // UI
  gfl::ui::DeviceManager*  mDeviceManager;
  
  gfl::fs::ArcFile *mViewerArc;
  
  
  //BGVXe
  bg::System *mBgSystem;
  
  //̑
  int mLoadStep;
};

}//namespace ariizumi
}//namespace test

#endif //__ARI_BG_TEST_H__
