#if PM_DEBUG

//======================================================================
/**
 * @file	ari_bg_test.h
 * @brief	wieXg
 * @author	ariizumi
 * @data	12/06/06
 */
//======================================================================
#include <gflib.h>


#include "ari_bg_test.h"

namespace test
{
namespace ariizumi
{

//------------------------------------------------------------------
/**
 * @brief	  PROC̏s֐
 * @return	Result 삪I RES_FINISHԂĂ炤MainFuncɐi
 */
//------------------------------------------------------------------
gfl::proc::Result AriBgTest::InitFunc(gfl::proc::Manager* pManager)
{
  InitSystem();
  
  return gfl::proc::RES_FINISH;
}

//------------------------------------------------------------------
/**
 * @brief	  PROC̏Is֐
 * @return	Result 삪I RES_FINISHԂĂ炤ŏIƉ߂
 */
//------------------------------------------------------------------
gfl::proc::Result AriBgTest::EndFunc(gfl::proc::Manager* pManager)
{
  TermSystem();
  
  return gfl::proc::RES_FINISH;
}

//------------------------------------------------------------------
/**
 * @brief	  PROC̃Cs֐
 * @return	Result 삪I RES_FINISHԂĂ炤EndFuncɐi
 */
//------------------------------------------------------------------
gfl::proc::Result AriBgTest::UpdateFunc(gfl::proc::Manager* pManager)
{
  if( UpdateSystem() )
  {
    return gfl::proc::RES_FINISH;
  }

  return gfl::proc::RES_CONTINUE;
}

void AriBgTest::DrawFunc(gfl::proc::Manager* pManager)
{
  DrawSystem();
}

void AriBgTest::InitSystem(void)
{
  gfl::heap::HeapBase *sysHeap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP );
  gfl::heap::HeapBase *devHeap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP_DEVICE );

  mHeapMem = gfl::heap::Manager::CreateHeap( sysHeap , HEAPID_BATTLE_SYS , sysHeap->GetTotalAllocatableSize() , gfl::heap::HEAP_TYPE_EXP );
  mDeviceMem = gfl::heap::Manager::CreateHeap( devHeap , HEAPID_BATTLE_DEVICE , devHeap->GetTotalAllocatableSize() , gfl::heap::HEAP_TYPE_EXP );

  // eAP[^쐬
  mHeapAllocater = GFL_NEW(mHeapMem) gfl::heap::NwAllocator(mHeapMem);
  mDeviceAllocater = GFL_NEW(mDeviceMem) gfl::heap::NwAllocator(mDeviceMem);

#if GFL_HIO_ENABLE
  gfl::fs::FileSystem::InitializeHio( gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP_DEVICE ) );
#endif

  //UI
  mDeviceManager = GFL_SINGLETON_INSTANCE(gamesystem::GameManager)->GetUiDeviceManager();

  // OtBbNXVXe擾
  mGrpSys = GFL_SINGLETON_INSTANCE(gamesystem::GameManager)->GetGraphicsSystem();
  mGrpSys->InitializeApplicationMemory(mDeviceAllocater);

  GFL_SINGLETON_INSTANCE(gamesystem::GameManager)->SetRenderingParameter(0.0f);

  //2D
  static const gfl::grp::g2d::LytSysSetUp SetUp =
  {
    10,10 //㉺̃CAEg
  };

  mLytSys = GFL_NEW(mHeapMem) gfl::grp::g2d::LytSys(&SetUp, mHeapAllocater, mDeviceAllocater );
  gfl::grp::g2d::LytSys::SetDefaultFont( SystemFont_GetFont() , "cbf_std.bcfnt" );

  //ʂ̍W̒
  gfl::grp::ViewParam viewParam;
  gfl::std::MemCopy( &gfl::grp::g2d::Env::DefaultView[gfl::grp::DISPLAY_LOWER] , &viewParam , sizeof(gfl::grp::ViewParam) );
  viewParam.pos.y = LAYOUT_DOWN_OFS;
  viewParam.target.y = LAYOUT_DOWN_OFS;

  gfl::grp::g2d::Env *g2dEnv = mLytSys->GetGlobalEnv(gfl::grp::DISPLAY_LOWER);
  g2dEnv->SetCameraParam( gfl::grp::g2d::Env::CAMERA_NORMAL , gfl::grp::g2d::Env::DefaultProjection[gfl::grp::DISPLAY_LOWER] , viewParam );

  
  //3D
  gfl::grp::g3d::System::Description g3dDesc;
  g3dDesc.resource_object_num_max = 512;
  mG3dSys = GFL_NEW(mHeapMem) gfl::grp::g3d::System( mHeapAllocater, mDeviceAllocater , &g3dDesc );

  //RootNodes
  gfl::grp::g3d::Scene::Description sceneDesc;
  gfl::grp::g3d::SceneCalculateGroup::Description sceneCalcDesc[2];
  sceneCalcDesc[0].max_scene_nodes = 1024;
  sceneCalcDesc[0].max_models = 1024;
  sceneCalcDesc[0].max_skeletal_models = 1024;
  sceneCalcDesc[0].max_cameras = 64;
  sceneCalcDesc[0].max_lights = 64;
  sceneCalcDesc[0].max_fragment_lights = 64;
  sceneCalcDesc[0].max_vertex_lights = 64;
  sceneCalcDesc[0].max_hemisphere_lights = 64;
  sceneCalcDesc[0].max_ambient_lights = 64;
  sceneCalcDesc[0].max_animatable_nodes = 1024; //@todoƂ
  sceneDesc.scene_draw_group_num = BGTEST_SCENE_MAX;
  sceneDesc.scene_calculate_group_description_array = sceneCalcDesc;
  sceneDesc.own_light_num_max = 16; //@todoƂ
  mScene = GFL_NEW(mHeapMem) gfl::grp::g3d::Scene( mDeviceAllocater , &sceneDesc );

  //GbWVXe
  gfl::grp::RenderTarget::Description   rtDesc;
  gfl::grp::FrameBufferManager          *frame_buffer_manager = mGrpSys->GetFrameBufferManager();
  gfl::grp::RenderTarget                *left_render_target = frame_buffer_manager->GetRenderTarget( mGrpSys->GetCurrentFrameBufferID(gfl::grp::DISPLAY_UPPER) );

  rtDesc.depth_address = left_render_target->GetDepthAddress();
  rtDesc.depth_area = gfl::grp::MEMORY_AREA_VRAMB;

  mScene->CreateEdgeMapSystem( mHeapAllocater , mDeviceAllocater , BGTEST_SCENE_EDGE , &rtDesc );
  gfl::grp::g3d::G3DPostEffectSystem::Description   desc;
  desc.edge_draw_group_id = BGTEST_SCENE_POST_EFFECT;
  desc.bloom_filter_enable = false;
  desc.edge_type = gfl::grp::g3d::G3DEdgeFilter::DOUBLE_LAYERED_EDGE;
  desc.edge_enable = true;
  mScene->CreatePostEffectSystem( mHeapAllocater, mDeviceAllocater, &desc , mGrpSys );
  mScene->SetEdgeColor( 0.4f,0.4f,0.4f );
  
  //W
  gfl::math::VEC3 camPos( 238.0f,136.0f,453.0f );
  gfl::math::VEC3 camTrg( -35.0f,70.0f,0.0f );
  
  mCamera = GFL_NEW(mHeapMem) gfl::grp::g3d::StereoCamera;
  mCamera->Create( mDeviceAllocater ,
                   camPos,
                   camTrg,
                   NEAR_PLANE,
                   FAR_PLANE ,
                   GFL_MATH_DEG_TO_RAD(30));
  mCamera->SetDepthRange(0.0f);
  gfl::grp::g3d::Camera::SetCameraAspectRatio(mCamera->GetBaseCamera()->GetNwCamera(), 400.0f/240.0f);

  mScene->AddSceneNode( mCamera );
  
  //
//  mResEnv = GFL_NEW(mDeviceMem) gfl::grp::g3d::Resource;
//  mResEnv->LoadAndSetup( mDeviceAllocater , mViewerArc , GARC_poke_viewer_SceneEnvironment_BCENV );
//  mScene->BuildSceneUsingResource( mDeviceAllocater, mDeviceAllocater, mResEnv );

  // SceneInitializer Ń}eA\[g̏肷 MaterialId ݒ肵܂B
  // SceneTraverser ŃV[m[h̎Wƒ񉻂 SceneContext ɒǉs܂B
  mScene->Initialize();

  // Jʒu𐢊EWɂ邽߂ɈxXVĂ܂B
  mScene->Calculate();

  // V[̎QƉsݒ肵܂B
  mScene->SetSceneEnvironmentUsingOwnObject();
  
  //-----------------------------------------------------------
  //CAEg
  

  InitDebug();
  
  
  
  //BGVXe
  mBgSystem = GFL_NEW(mHeapMem)bg::System;
  
  bg::InitSystemParam initSysParam;

  initSysParam.heapAllocator = mHeapAllocater;
  initSysParam.deviceAllocator = mDeviceAllocater;

  initSysParam.grpSys = mGrpSys;
  initSysParam.g3dSys = mG3dSys;
  initSysParam.scene  = mScene;
  initSysParam.readMng= GFL_SINGLETON_INSTANCE( gamesystem::GameManager )->GetFileReadManager();
  
  initSysParam.mdlCalcGroup = 0;
  initSysParam.mdlDrawGroup = BGTEST_SCENE_NORMAL;
  
  initSysParam.useEnv = true;
  initSysParam.isAsync = true;
  
  mBgSystem->Init(initSysParam);
  
  
  
  //̑
  mLoadStep = 0;
}

void AriBgTest::TermSystem(void)
{
  //BGVXe
  mBgSystem->Exit();
  GFL_DELETE mBgSystem;
  
  gfl::debug::DebugWin_RemoveGroupByName( L"BG_Debug" );

  mScene->RemoveSceneNode( mCamera );
  
  GFL_DELETE mResEnv;
  GFL_DELETE mCamera;
  GFL_DELETE mScene;
  GFL_DELETE mG3dSys;

  GFL_DELETE mLytSys;
  mGrpSys->FinalizeApplicationMemory();
  
  GFL_DELETE mHeapAllocater;
  GFL_DELETE mDeviceAllocater;
  gfl::heap::Manager::DeleteHeap( mHeapMem );
  gfl::heap::Manager::DeleteHeap( mDeviceMem );

}

bool AriBgTest::UpdateSystem(void)
{
  gfl::ui::Button *uiButton = mDeviceManager->GetButton(0);
  gfl::ui::VectorDevice *uiCrossKey = mDeviceManager->GetCrossKey(0);
  gfl::ui::TouchPanel *uiTouchPanel = mDeviceManager->GetTouchPanel(0);
  
  enum
  {
    STEP_WAIT = 0,
    STEP_LOADING,
    STEP_DISP,
    STEP_DELETE,
  };
  
  switch( mLoadStep )
  {
  case STEP_WAIT:
    if( uiButton->IsTrigger( gfl::ui::BUTTON_A ) )
    {
      bg::InitTypeParam initParam;
      initParam.groundType = bg::BGTYPE_GRASS;
      initParam.farType = bg::BGTYPE_GRASS;
      initParam.objType = bg::OBJTYPE_NONE;
      
      initParam.useSky = true;
      
      mBgSystem->StartLoad(initParam);
      
      mLoadStep = STEP_LOADING;
    }
    break;

  case STEP_LOADING:
    if( mBgSystem->IsFinishLoad() )
    {
      mBgSystem->Create();
      mBgSystem->AddScene();
      mLoadStep = STEP_DISP;
    }
    break;

  case STEP_DISP:
    if( uiButton->IsTrigger( gfl::ui::BUTTON_A ) )
    {
      mBgSystem->RemoveScene();
      mLoadStep = STEP_DELETE;
    }
    break;
    
  case STEP_DELETE:
    mBgSystem->Delete();
    mLoadStep = STEP_WAIT;
    break;

  }
  
  
  mScene->Calculate();
  // _ɈˑXV RenderQueue ̍\zs܂B
  mScene->SubmitView(mCamera,true,true,0);
  mScene->SubmitViewOfEdge( mCamera);
  mLytSys->UpdateAll();

  return false;
}

void AriBgTest::DrawSystem(void)
{
  gfl::grp::RenderTarget* upperFrameBuffer = mGrpSys->GetCurrentFrameBuffer(gfl::grp::DISPLAY_UPPER);
  gfl::grp::RenderTarget* rightFrameBuffer = mGrpSys->GetCurrentFrameBuffer(gfl::grp::DISPLAY_UPPER_RIGHT);
  gfl::grp::RenderTarget* lowerFrameBuffer = mGrpSys->GetCurrentFrameBuffer(gfl::grp::DISPLAY_LOWER);

  mScene->StereoEdgeMapDraw( mGrpSys, mCamera );

  mScene->CommandSaveStereoDraw( mGrpSys ,
                                  mCamera ,
                                  upperFrameBuffer,
                                  rightFrameBuffer );
  mScene->StereoPostEffectDraw( mGrpSys, mCamera ); 

  mLytSys->DrawAll( mGrpSys, gfl::grp::DISPLAY_UPPER, upperFrameBuffer, rightFrameBuffer );
  mLytSys->DrawAll( mGrpSys, gfl::grp::DISPLAY_LOWER, lowerFrameBuffer );
  

}


void AriBgTest::InitDebug(void)
{
  
#if GFL_DEBUG
  gfl::debug::DebugWinGroup *topGroup = gfl::debug::DebugWin_AddGroup( L"BG_Debug" );
/*
  gfl::debug::DebugWinGroup *dispGroup = gfl::debug::DebugWin_AddGroup( L"\" , topGroup );
  gfl::debug::DebugWinGroup *loadGroup = gfl::debug::DebugWin_AddGroup( L"|Pǂݍ" , topGroup );
  
  gfl::debug::DebugWinItemValueInt<int>   *itemInt;
  gfl::debug::DebugWinItemValueInt<bool>   *itemBool;
  gfl::debug::DebugWinItemValueColorF32 *itemCol;

  itemInt = gfl::debug::DebugWin_AddItemValueIntMsg( loadGroup , L"|Pԍ" , &mMonsNo ,  ARCID_MESSAGE , GARC_message_monsname_DAT , 1 , 721 );
  itemInt = gfl::debug::DebugWin_AddItemValueInt( loadGroup , L"[V[ba:0 kw:1]" , &mMotionType ,0,1,1);
  gfl::debug::DebugWin_AddItemUpdateFunc( loadGroup , L"ǂݍ" , this , &AriBgTest::LoadDebugFunc );
  gfl::debug::DebugWin_AddItemUpdateFunc( loadGroup , L"" , this , &AriBgTest::UnloadDebugFunc );

  itemCol = gfl::debug::DebugWin_AddItemValueColorF32( dispGroup  , L"wiF" , &mBgColor );
  itemCol->SetChangedValueFunc( AriBgTest::UpdateDebugMenuDisp , this );
  itemBool = gfl::debug::DebugWin_AddItemValueBool( dispGroup  , L"@GbW" , &mEdgeEnable );
  itemBool->SetChangedValueFunc( AriBgTest::UpdateDebugMenuDisp , this );
  itemInt = gfl::debug::DebugWin_AddItemValueInt( dispGroup  , L"GbW[h" , &mEdgeType , 0 , 4 , 1 );
  itemInt->SetChangedValueFunc( AriBgTest::UpdateDebugMenuDisp , this );
*/
#endif //GFL_DEBUG
}


}//namespace ariizumi
}//namespace test

#endif // PM_DEBUG
