//======================================================================
/**
 * @file	bg_system.cpp
 * @brief	wi`VXe
 * @author	ariizumi
 * @data	12/06/06
 */
//======================================================================
#include <gflib.h>

#include "system/background/bg_system.h"
#include "background.gaix"

namespace bg
{
  
System::System()
{
}

System::~System()
{
}

void System::Init(const InitSystemParam &sysParam)
{
  mHeapAllocator = sysParam.heapAllocator;
  mDeviceAllocator = sysParam.deviceAllocator;
  
  mGrpSys = sysParam.grpSys;
  mG3dSys = sysParam.g3dSys;
  mScene  = sysParam.scene;
  mReadMng= sysParam.readMng;
  
  mMdlCalcGroup = sysParam.mdlCalcGroup;
  mMdlDrawGroup = sysParam.mdlDrawGroup;
  
  mUseEnvFile = sysParam.useEnv;
  mIsCreateEnv = false;
  mIsAsyncLoad = sysParam.isAsync;
  mReadMng->AppendManageFile( mHeapAllocator->GetHeapBase() , ARCID_BACKGROUND , false );

  mArcFile = NULL;

  mResGround = NULL;
  mMdlGround = NULL;
  mResFar = NULL;
  mMdlFar = NULL;
  mResEnv = NULL;
}

void System::Exit(void)
{
  if( mResEnv )
  {
    GFL_DELETE mResEnv;
    mResEnv = NULL;
  }

  mReadMng->RemoveManageFile( ARCID_BACKGROUND );
}

void System::StartLoad(const InitTypeParam &typeParam)
{
  mStackFileNum = 0;
  for( int i=0;i<ASYNC_FILE_NUM;i++ )
  {
    mAsyncBuf[i] = NULL;
  }

  if( mUseEnvFile && mIsCreateEnv == false )
  {
    FileLoadFunc( &mFileBuf[RES_ENV] , GARC_background_bg_env_BCENV , mDeviceAllocator->GetHeapBase() );
  }
  
  FileLoadFunc( &mFileBuf[RES_G_MDL ] , GARC_background_btl_G_kusa_BCMDL , mDeviceAllocator->GetHeapBase() );
  FileLoadFunc( &mFileBuf[RES_G_SKLA] , GARC_background_btl_G_kusa_BCSKLA , mDeviceAllocator->GetHeapBase() );
  FileLoadFunc( &mFileBuf[RES_G_MATA] , GARC_background_btl_G_kusa_BCMATA , mDeviceAllocator->GetHeapBase() );
  FileLoadFunc( &mFileBuf[RES_G_MDLA] , GARC_background_btl_G_kusa_BCMDLA , mDeviceAllocator->GetHeapBase() );
  FileLoadFunc( &mFileBuf[RES_F_MDL ] , GARC_background_btl_F_kusa_BCMDL , mDeviceAllocator->GetHeapBase() );
}

bool System::IsFinishLoad(void)
{
  for( int i = 0;i<mStackFileNum;i++ )
  {
    if( mAsyncBuf[i] != NULL )
    {
      const bool ret = mReadMng->IsReadFinished( mAsyncBuf[i] );
      if( ret )
      {
        mAsyncBuf[i] = NULL;
      }
      else
      {
        return false;
      }
    }
  }
  return true;
}

void System::Create(void)
{
  gfl::grp::g3d::Resource::Description resDesc;
  gfl::grp::g3d::Model::Description mdlDesc;

  u32 common_resource_flag = gfl::grp::g3d::Resource::COMMON_RESOURCE_NONE;
  common_resource_flag |= gfl::grp::g3d::Resource::COMMON_RESOURCE_DEFAULT_SHADER_BIT;

  if( mUseEnvFile && mIsCreateEnv == false )
  {
    //
    mResEnv = GFL_NEW(mDeviceAllocator->GetHeapBase()) gfl::grp::g3d::Resource;
    mResEnv->AttachBufferAndSetup( mDeviceAllocator , mFileBuf[RES_ENV] );
    mScene->BuildSceneUsingResource( mDeviceAllocator, mDeviceAllocator, mResEnv );
    mIsCreateEnv = true;

    mScene->Initialize();
  }

  mdlDesc.material_buffer_option = gfl::grp::g3d::Model::MATERIAL_BUFFER_OPTION_ALL_MATERIAL;

  mResGround = GFL_NEW(mDeviceAllocator->GetHeapBase()) gfl::grp::g3d::Resource;
  mResGround->AttachBufferAndSetup( mDeviceAllocator , mFileBuf[RES_G_MDL] , &resDesc , false , common_resource_flag );

  mdlDesc.animation_slot_num = 3;
  mMdlGround = GFL_NEW(mDeviceAllocator->GetHeapBase()) gfl::grp::g3d::Model();
  mMdlGround->Create( mHeapAllocator, mDeviceAllocator, mResGround, 0 , &mdlDesc);

  mResFar = GFL_NEW(mDeviceAllocator->GetHeapBase()) gfl::grp::g3d::Resource;
  mResFar->AttachBufferAndSetup( mDeviceAllocator , mFileBuf[RES_F_MDL] , &resDesc , false , common_resource_flag );
  
  //̓AjȂ
  mdlDesc.animation_slot_num = 0;
  mMdlFar = GFL_NEW(mDeviceAllocator->GetHeapBase()) gfl::grp::g3d::Model();
  mMdlFar->Create( mHeapAllocator, mDeviceAllocator, mResFar, 0 , &mdlDesc);

  // V[̎QƉsݒ肵܂B
  mScene->SetSceneEnvironmentUsingOwnObject();
}

void System::Delete(void)
{
  GFL_DELETE mMdlFar;
  mMdlFar = NULL;
  
  GFL_DELETE mResFar;
  mResFar = NULL;
  
  GFL_DELETE mMdlGround;
  mMdlGround = NULL;

  GFL_DELETE mResGround;
  mResGround = NULL;
  //ResEnv͏ȂI
}

void System::AddScene(void)
{
  mScene->AddModelToSceneCalculateGroupAndSceneDrawGroup(mMdlGround,mMdlCalcGroup,mMdlDrawGroup);
  mScene->AddModelToSceneCalculateGroupAndSceneDrawGroup(mMdlFar,mMdlCalcGroup,mMdlDrawGroup);
}

void System::RemoveScene(void)
{
  mScene->RemoveSceneNode( mMdlGround );
  mScene->RemoveSceneNode( mMdlFar );
}

void System::Update(void)
{
}

void System::Draw(void)
{
}

void System::FileLoadFunc( void **buf , gfl::fs::ArcFile::ARCDATID fileId , gfl::heap::HeapBase *heap )
{
  //񓯊ARCID_POKE_MODELpI
  if( mIsAsyncLoad )
  {
    mReadMng->AddReadRequest( buf ,
                              NULL ,
                              heap ,
                              128 ,
                              ARCID_BACKGROUND ,
                              fileId );
  
    if( mStackFileNum >= ASYNC_FILE_NUM )
    {
      GFL_ASSERT_MSG( 0,"t@CǗȂ\n" );
    }
    mAsyncBuf[mStackFileNum] = buf;
    mStackFileNum++;
  }
  else
  {
    //const u32 size = arc->GetDataSize(fileId);
    //*buf = arc->LoadData( fileId , heap , 128 );
    
  }
}
  


}//namespace bg
