//======================================================================
/**
 * @file	bg_system.h
 * @brief	wi`VXe
 * @author	ariizumi
 * @data	12/06/06
 */
//======================================================================

#if !defined( _BG_SYSTEM_H__ )
#define _BG_SYSTEM_H__

#pragma once

namespace bg
{
//VXepp[^
typedef struct
{
  gfl::heap::NwAllocator* heapAllocator;
  gfl::heap::NwAllocator* deviceAllocator;
  
  gfl::grp::GraphicsSystem*     grpSys;
  gfl::grp::g3d::System*        g3dSys;
  gfl::grp::g3d::Scene*         scene;
  gfl::fs::FileReadManager*     readMng;
  
  s32 mdlCalcGroup;
  s32 mdlDrawGroup;
  
  bool useEnv;
  bool isAsync;

}InitSystemParam;

//^Cvw nʁAi
typedef enum
{
  BGTYPE_GRASS,
  BGTYPE_SEA,
  
  BGTYPE_NONE,
  
  BGTYPE_MAX,
}BGTYPE;

//^Cvw OBJ
typedef enum
{
  OBJTYPE_GRASS,
  
  OBJTYPE_NONE,
  
  OBJTYPE_MAX,
}OBJTYPE;

//pp[^
typedef struct
{
  BGTYPE groundType;
  BGTYPE farType;
  
  OBJTYPE objType;
  
  bool useSky;
  
}InitTypeParam;


//----------------------------------
//p

class System
{
public:
  System();
  virtual ~System();
  
  void Init(const InitSystemParam &sysParam);
  void Exit(void);

  void StartLoad(const InitTypeParam &typeParam);
  bool IsFinishLoad(void);
  void Create(void);
  void Delete(void);

  void AddScene(void);
  void RemoveScene(void);

  void Update(void);
  void Draw(void);
  
private:

  void FileLoadFunc( void **buf , gfl::fs::ArcFile::ARCDATID fileId , gfl::heap::HeapBase *heap );

  enum
  {
    RES_G_MDL,
    RES_G_SKLA,
    RES_G_MATA,
    RES_G_MDLA,
    RES_F_MDL,
    RES_ENV,
    
    REM_MAX,
  };

  gfl::heap::NwAllocator* mHeapAllocator;
  gfl::heap::NwAllocator* mDeviceAllocator;

  gfl::grp::GraphicsSystem*     mGrpSys;
  gfl::grp::g3d::System*        mG3dSys;
  gfl::grp::g3d::Scene*         mScene;
  gfl::fs::FileReadManager*     mReadMng;

  gfl::fs::ArcFile*             mArcFile;

  gfl::grp::g3d::Resource *mResGround;
  gfl::grp::g3d::Model    *mMdlGround;

  gfl::grp::g3d::Resource *mResFar;
  gfl::grp::g3d::Model    *mMdlFar;
  
  gfl::grp::g3d::Resource *mResEnv;

  s32 mMdlCalcGroup;
  s32 mMdlDrawGroup;

  bool mIsAsyncLoad;
  bool mUseEnvFile;
  bool mIsCreateEnv;

  //񓯊ǂ݊Ǘ
  static const int ASYNC_FILE_NUM = 8;
  int mStackFileNum;
  void** mAsyncBuf[ASYNC_FILE_NUM];
  
  void *mFileBuf[REM_MAX];
  
};
  
}//namespace bg
#endif // _BG_SYSTEM_H__
