
#include "EditScene.h"
#include "Scene.h"
#include "Main.h"

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(promotion)

static const Edit s_motion[] = 
{
  {
    L"BA01_TOUJYOU01",
    TRMOT_OTHER_BA01_TOUJYOU01
  },
  {
    L"BA40_POSE01",
    TRMOT_OTHER_BA40_POSE01
  },
  {
    L"BA55_VIDEOLOOP01",
    TRMOT_OTHER_BA55_VIDEOLOOP01
  },
  {
    L"BA55_VIDEOPOSEA03",
    TRMOT_OTHER_BA55_VIDEOPOSEA03
  },
  {
    L"VIDEOPOSEB03",
    TRMOT_OTHER_BA55_VIDEOPOSEB03
  },
  {
    L"VIDEOPOSEC03",
    TRMOT_OTHER_BA55_VIDEOPOSEC03
  },
};

static const Edit s_rotate[] = 
{
  {
    L"ʌ",
    ROTATE_FIXED_FRONT
  },
  {
    L"",
    ROTATE_FIXED_LEFT
  },
  {
    L"E",
    ROTATE_FIXED_RIGHT
  },
  {
    L"",
    ROTATE_FIXED_BACK
  },
  {
    L"Eɉ葱",
    ROTATE_LEFT
  },
  {
    L"ɉ葱",
    ROTATE_RIGHT
  },
};

static const Edit s_bgm[] = {
  {
    L"STRM_BGM_PVD_01",
    STRM_BGM_PVD_01
  },
  {
    L"STRM_BGM_PVD_02",
    STRM_BGM_PVD_02
  },
  {
    L"STRM_BGM_PVD_03",
    STRM_BGM_PVD_03
  },
};

static const Edit s_se[] = {
  {
    L"SEQ_SE_PVD_001",
    SEQ_SE_PVD_001
  },
  {
    L"SEQ_SE_PVD_002",
    SEQ_SE_PVD_002
  },
  {
    L"SEQ_SE_PVD_003",
    SEQ_SE_PVD_003
  },
};

static const Edit s_camera[] = 
{
  {
    L"_videopose01_BCCAM",
    GARC_promotion_cam_ba55_videopose01_BCCAM
  },
  {
    L"_videopose02_BCCAM",
    GARC_promotion_cam_ba55_videopose02_BCCAM
  },
  {
    L"_videopose03_BCCAM",
    GARC_promotion_cam_ba55_videopose03_BCCAM
  },
  {
    L"_videopose04_BCCAM",
    GARC_promotion_cam_ba55_videopose04_BCCAM
  },
};
static const Edit s_text[] = 
{
  {
    L"",
    TELOP_TEXT_HIDE
  },
  {
    L"w҂̃g[i[x",
    TELOP_TEXT_KITAI
  },
  {
    L"w̖x",
    TELOP_TEXT_SONONAMO
  },
  {
    L"w̉낵ˁx",
    TELOP_TEXT_YOROSHIKU
  },
  {
    L"w}WŁIx",
    TELOP_TEXT_MAJIDE
  },
};
static const Edit s_text_pos[] = 
{
  {
    L"",
    TELOP_POS_CENTER
  },
  {
    L"",
    TELOP_POS_LEFT
  },
  {
    L"E",
    TELOP_POS_RIGHT
  },
  {
    L"",
    TELOP_POS_TOP
  },
  {
    L"",
    TELOP_POS_TOP | TELOP_POS_LEFT
  },
  {
    L"E",
    TELOP_POS_TOP | TELOP_POS_RIGHT
  },
  {
    L"",
    TELOP_POS_BOTTOM
  },
  {
    L"",
    TELOP_POS_BOTTOM | TELOP_POS_LEFT
  },
  {
    L"E",
    TELOP_POS_BOTTOM | TELOP_POS_RIGHT
  },
};

static const Edit s_bg[] = 
{
  {
    L"bg001()",
    GARC_promotion_bg001_BCTEX
  },
  {
    L"bg002()",
    GARC_promotion_bg002_BCTEX
  },
  {
    L"bg003(/)",
    GARC_promotion_bg003_BCTEX
  },
};

static const Edit s_blightness[] = 
{
  {
    L"ӂ",
    BG_BLIGHTNESS_MAX
  },
  {
    L"₭",
    BG_BLIGHTNESS_HIGH
  },
  {
    L"炢",
    BG_BLIGHTNESS_MIDDLE
  },
  {
    L"قڂ",
    BG_BLIGHTNESS_LOW
  },
  {
    L"܂",
    BG_BLIGHTNESS_MIN
  },
};

#define TMP(x) {L###x,x},
static const Edit s_particle[] = 
{
  TMP(GARC_wazaeff_particle_Fire_Beam_BCPTL)
  TMP(GARC_wazaeff_particle_Fire_hit_BCPTL)
  TMP(GARC_wazaeff_particle_ea001_BCPTL)
  TMP(GARC_wazaeff_particle_ea002_BCPTL)
  TMP(GARC_wazaeff_particle_ea003_BCPTL)
  TMP(GARC_wazaeff_particle_ea004_BCPTL)
  TMP(GARC_wazaeff_particle_ea011_BCPTL)
  TMP(GARC_wazaeff_particle_ea011flash_BCPTL)
  TMP(GARC_wazaeff_particle_ea012_BCPTL)
  TMP(GARC_wazaeff_particle_ea013_BCPTL)
  TMP(GARC_wazaeff_particle_ea013flash_BCPTL)
  TMP(GARC_wazaeff_particle_ea014_BCPTL)
  TMP(GARC_wazaeff_particle_eb001_1_BCPTL)
  TMP(GARC_wazaeff_particle_eb001_2_BCPTL)
  TMP(GARC_wazaeff_particle_eb001_3_BCPTL)
  TMP(GARC_wazaeff_particle_eb001_4_BCPTL)
  TMP(GARC_wazaeff_particle_eb003_1_BCPTL)
  TMP(GARC_wazaeff_particle_eb003_2_BCPTL)
  TMP(GARC_wazaeff_particle_eb004_1_BCPTL)
  TMP(GARC_wazaeff_particle_eb004_2_BCPTL)
  TMP(GARC_wazaeff_particle_ee001_ca_BCPTL)
  TMP(GARC_wazaeff_particle_ee001_ca_aura_BCPTL)
  TMP(GARC_wazaeff_particle_ee001_ca_aura_loop_BCPTL)
  TMP(GARC_wazaeff_particle_ee001_ca_floor_BCPTL)
  TMP(GARC_wazaeff_particle_ee002_ca_BCPTL)
  TMP(GARC_wazaeff_particle_ee003_ca_BCPTL)
  TMP(GARC_wazaeff_particle_ee004_ca_down_BCPTL)
  TMP(GARC_wazaeff_particle_ee004_ca_ring_BCPTL)
  TMP(GARC_wazaeff_particle_ee005_ca_BCPTL)
  TMP(GARC_wazaeff_particle_ee005_ca_boxfl_BCPTL)
  TMP(GARC_wazaeff_particle_ee006_ca_BCPTL)
  TMP(GARC_wazaeff_particle_ee007_ca_BCPTL)
  TMP(GARC_wazaeff_particle_ee100_ca_ballopen_BCPTL)
  TMP(GARC_wazaeff_particle_ee105_ca_BCPTL)
  TMP(GARC_wazaeff_particle_es001_ca_BCPTL)
  TMP(GARC_wazaeff_particle_es002_ca_BCPTL)
  TMP(GARC_wazaeff_particle_es003_ca_BCPTL)
  TMP(GARC_wazaeff_particle_es004_ca_BCPTL)
  TMP(GARC_wazaeff_particle_es005_ca_BCPTL)
  TMP(GARC_wazaeff_particle_es006_ca_BCPTL)
  TMP(GARC_wazaeff_particle_es007_ca_BCPTL)
  TMP(GARC_wazaeff_particle_es008_ca_BCPTL)
  TMP(GARC_wazaeff_particle_es009_ca_BCPTL)
  TMP(GARC_wazaeff_particle_es010_ca_BCPTL)
  TMP(GARC_wazaeff_particle_ew001_df_ca_hit_BCPTL)
  TMP(GARC_wazaeff_particle_ew002_df_ca_hit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew002_df_ca_slash01_BCPTL)
  TMP(GARC_wazaeff_particle_ew003_df_ca_hit_BCPTL)
  TMP(GARC_wazaeff_particle_ew003_df_ca_in_BCPTL)
  TMP(GARC_wazaeff_particle_ew004_df_ca_hit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew005_df_ca_hit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew006_at_ca_koban_BCPTL)
  TMP(GARC_wazaeff_particle_ew006_at_ca_kobanhit_BCPTL)
  TMP(GARC_wazaeff_particle_ew008_df_ca_icehit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew008_df_ca_icemove01_BCPTL)
  TMP(GARC_wazaeff_particle_ew009_df_ca_thunderhit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew009_df_ca_thundermove01_BCPTL)
  TMP(GARC_wazaeff_particle_ew010_df_ca_slash_hit_BCPTL)
  TMP(GARC_wazaeff_particle_ew010_df_ca_slash_pt_BCPTL)
  TMP(GARC_wazaeff_particle_ew011_df_ca_hit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew012_df_ca_hasami01_hit_BCPTL)
  TMP(GARC_wazaeff_particle_ew013_1_at_ca_kama_cutter_BCPTL)
  TMP(GARC_wazaeff_particle_ew013_1_at_ca_kama_gene_BCPTL)
  TMP(GARC_wazaeff_particle_ew013_df_ca_kama_hit_BCPTL)
  TMP(GARC_wazaeff_particle_ew013_df_tr_kama_cutter_BCPTL)
  TMP(GARC_wazaeff_particle_ew014_at_ca_attackup01_BCPTL)
  TMP(GARC_wazaeff_particle_ew014_at_ca_hit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew016_at_ca_wind01_BCPTL)
  TMP(GARC_wazaeff_particle_ew016_at_tr_windline01_BCPTL)
  TMP(GARC_wazaeff_particle_ew016_df_ca_wind01_BCPTL)
  TMP(GARC_wazaeff_particle_ew017_df_ca_featherhit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew018_at_tr_wind01_BCPTL)
  TMP(GARC_wazaeff_particle_ew021_df_ca_hit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew022_df_ca_tsutahit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew023_df_ca_leg01hit_BCPTL)
  TMP(GARC_wazaeff_particle_ew023_df_ca_leg01smoke_BCPTL)
  TMP(GARC_wazaeff_particle_ew024_df_ca_hit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew025_df_ca_hit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew025_df_ca_lineout01_BCPTL)
  TMP(GARC_wazaeff_particle_ew028_at_ca_sand01_BCPTL)
  TMP(GARC_wazaeff_particle_ew028_df_ca_sand01_BCPTL)
  TMP(GARC_wazaeff_particle_ew029_df_ca_hit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew030_df_ca_drillhit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew031_df_ca_hit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew032_at_ca_drillatk01_BCPTL)
  TMP(GARC_wazaeff_particle_ew032_df_ca_drill01_BCPTL)
  TMP(GARC_wazaeff_particle_ew034_df_ca_hit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew034_df_ca_smoke01_BCPTL)
  TMP(GARC_wazaeff_particle_ew036_at_ca_attackdome01_BCPTL)
  TMP(GARC_wazaeff_particle_ew036_df_ca_hit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew037_df_ca_punchhit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew038_at_ca_dmghit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew038_at_ca_powerin01_BCPTL)
  TMP(GARC_wazaeff_particle_ew038_df_ca_hit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew039_at_ca_gene01_BCPTL)
  TMP(GARC_wazaeff_particle_ew040_df_ca_poisonhit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew042_df_ca_hit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew043_df_ca_eyeflash01_BCPTL)
  TMP(GARC_wazaeff_particle_ew044_df_ca_toothhit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew045_at_ca_voice01_BCPTL)
  TMP(GARC_wazaeff_particle_ew046_at_ca_voice01_BCPTL)
  TMP(GARC_wazaeff_particle_ew047_at_ca_song01_BCPTL)
  TMP(GARC_wazaeff_particle_ew048_at_ca_soundwave01_BCPTL)
  TMP(GARC_wazaeff_particle_ew048_at_ca_soundwave01move_BCPTL)
  TMP(GARC_wazaeff_particle_ew048_df_ca_soundwave01hit_BCPTL)
  TMP(GARC_wazaeff_particle_ew049_at_ca_sonichit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew049_at_ca_sonicshot01_BCPTL)
  TMP(GARC_wazaeff_particle_ew050_at_ca_flash01_BCPTL)
  TMP(GARC_wazaeff_particle_ew050_df_ca_dontmove01_BCPTL)
  TMP(GARC_wazaeff_particle_ew051_at_ca_water01_BCPTL)
  TMP(GARC_wazaeff_particle_ew051_at_ca_water01muzzlefl_BCPTL)
  TMP(GARC_wazaeff_particle_ew051_df_ca_water01_BCPTL)
  TMP(GARC_wazaeff_particle_ew052_at_ca_firesparks01_BCPTL)
  TMP(GARC_wazaeff_particle_ew052_df_ca_firesparks01_BCPTL)
  TMP(GARC_wazaeff_particle_ew053_at_ca_fire_bar_BCPTL)
  TMP(GARC_wazaeff_particle_ew053_df_ca_fire_dmg_BCPTL)
  TMP(GARC_wazaeff_particle_ew054_at_tr_smoke01_BCPTL)
  TMP(GARC_wazaeff_particle_ew055_at_ca_water01_BCPTL)
  TMP(GARC_wazaeff_particle_ew055_at_ca_water01muzzlefl_BCPTL)
  TMP(GARC_wazaeff_particle_ew055_df_ca_water01_BCPTL)
  TMP(GARC_wazaeff_particle_ew056_at_ca_water01_BCPTL)
  TMP(GARC_wazaeff_particle_ew056_at_ca_water01muzzlefl_BCPTL)
  TMP(GARC_wazaeff_particle_ew056_df_ca_water01_BCPTL)
  TMP(GARC_wazaeff_particle_ew057_at_ca_seawave01_BCPTL)
  TMP(GARC_wazaeff_particle_ew057_at_ca_seawave02_BCPTL)
  TMP(GARC_wazaeff_particle_ew057_df_ca_water01_BCPTL)
  TMP(GARC_wazaeff_particle_ew058_at_ca_icebeam01_BCPTL)
  TMP(GARC_wazaeff_particle_ew058_at_ca_icebeamgene01_BCPTL)
  TMP(GARC_wazaeff_particle_ew058_df_ca_icebeam01hit_BCPTL)
  TMP(GARC_wazaeff_particle_ew059_at_tr_snow_BCPTL)
  TMP(GARC_wazaeff_particle_ew059_df_ca_dmg_BCPTL)
  TMP(GARC_wazaeff_particle_ew060_at_ca_phychobeam01_BCPTL)
  TMP(GARC_wazaeff_particle_ew060_at_ca_phychobeamgene01_BCPTL)
  TMP(GARC_wazaeff_particle_ew060_df_ca_phychobeam01hit_BCPTL)
  TMP(GARC_wazaeff_particle_ew061_at_ca_bubblebeam01_BCPTL)
  TMP(GARC_wazaeff_particle_ew061_at_ca_bubblebeamgene01_BCPTL)
  TMP(GARC_wazaeff_particle_ew061_df_ca_bubblebeam01hit_BCPTL)
  TMP(GARC_wazaeff_particle_ew062_at_ca_aurorabeam01_BCPTL)
  TMP(GARC_wazaeff_particle_ew062_at_ca_aurorabeamgene01_BCPTL)
  TMP(GARC_wazaeff_particle_ew062_df_ca_aurorabeam01hit_BCPTL)
  TMP(GARC_wazaeff_particle_ew063_at_ca_beam_BCPTL)
  TMP(GARC_wazaeff_particle_ew063_at_ca_gene_BCPTL)
  TMP(GARC_wazaeff_particle_ew063_at_tr_floorrock_BCPTL)
  TMP(GARC_wazaeff_particle_ew063_at_tr_line_BCPTL)
  TMP(GARC_wazaeff_particle_ew063_df_ca_hit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew063_df_ca_hit02_BCPTL)
  TMP(GARC_wazaeff_particle_ew064_df_ca_beak01_BCPTL)
  TMP(GARC_wazaeff_particle_ew064_df_ca_beak01hit_BCPTL)
  TMP(GARC_wazaeff_particle_ew065_df_ca_beak01hit_BCPTL)
  TMP(GARC_wazaeff_particle_ew066_df_ca_hit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew066_df_ca_rotbody01_BCPTL)
  TMP(GARC_wazaeff_particle_ew068_df_ca_hit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew068_df_ca_punch01_BCPTL)
  TMP(GARC_wazaeff_particle_ew069_at_tr_earthlight01_BCPTL)
  TMP(GARC_wazaeff_particle_ew069_at_tr_starbg01_BCPTL)
  TMP(GARC_wazaeff_particle_ew069_at_tr_starmovebg01_BCPTL)
  TMP(GARC_wazaeff_particle_ew069_at_tr_sun01_BCPTL)
  TMP(GARC_wazaeff_particle_ew070_at_ca_smoke01_BCPTL)
  TMP(GARC_wazaeff_particle_ew070_df_ca_hit_BCPTL)
  TMP(GARC_wazaeff_particle_ew071_at_ca_circle01_BCPTL)
  TMP(GARC_wazaeff_particle_ew071_df_ca_circle01_BCPTL)
  TMP(GARC_wazaeff_particle_ew072_at_ca_circle01_BCPTL)
  TMP(GARC_wazaeff_particle_ew072_df_ca_circle01_BCPTL)
  TMP(GARC_wazaeff_particle_ew073_1_df_ca_main_BCPTL)
  TMP(GARC_wazaeff_particle_ew073_1_df_ca_pt_BCPTL)
  TMP(GARC_wazaeff_particle_ew073_at_ca_seed_BCPTL)
  TMP(GARC_wazaeff_particle_ew073_df_ca_sprout_pt_BCPTL)
  TMP(GARC_wazaeff_particle_ew074_at_ca_attackup01_BCPTL)
  TMP(GARC_wazaeff_particle_ew075_at_ca_line_BCPTL)
  TMP(GARC_wazaeff_particle_ew075_at_tr_move_bg_BCPTL)
  TMP(GARC_wazaeff_particle_ew075_df_ca_hit_BCPTL)
  TMP(GARC_wazaeff_particle_ew076_1_at_ca_solargene01_BCPTL)
  TMP(GARC_wazaeff_particle_ew076_1_df_ca_solerbeam01_BCPTL)
  TMP(GARC_wazaeff_particle_ew076_1_df_ca_solerhit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew076_at_ca_solargene01_BCPTL)
  TMP(GARC_wazaeff_particle_ew077_at_ca_powder01_BCPTL)
  TMP(GARC_wazaeff_particle_ew077_df_ca_powder01_BCPTL)
  TMP(GARC_wazaeff_particle_ew078_at_ca_powder01_BCPTL)
  TMP(GARC_wazaeff_particle_ew078_df_ca_powder01_BCPTL)
  TMP(GARC_wazaeff_particle_ew079_at_ca_powder01_BCPTL)
  TMP(GARC_wazaeff_particle_ew079_df_ca_powder01_BCPTL)
  TMP(GARC_wazaeff_particle_ew080_at_ca_gene_BCPTL)
  TMP(GARC_wazaeff_particle_ew080_at_ca_line_BCPTL)
  TMP(GARC_wazaeff_particle_ew080_df_ca_hit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew080_df_ca_leaf_BCPTL)
  TMP(GARC_wazaeff_particle_ew081_at_ca_muzzle01_BCPTL)
  TMP(GARC_wazaeff_particle_ew082_at_ca_muzzle01_BCPTL)
  TMP(GARC_wazaeff_particle_ew082_at_ca_shot01_BCPTL)
  TMP(GARC_wazaeff_particle_ew082_df_ca_firehit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew082_df_ca_hit02_BCPTL)
  TMP(GARC_wazaeff_particle_ew083_at_ca_attackup01_BCPTL)
  TMP(GARC_wazaeff_particle_ew083_at_ca_gene01_BCPTL)
  TMP(GARC_wazaeff_particle_ew083_df_ca_hit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew084_at_ca_thundergene01_BCPTL)
  TMP(GARC_wazaeff_particle_ew084_df_ca_thunderhit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew085_at_ca_thundergene01_BCPTL)
  TMP(GARC_wazaeff_particle_ew085_df_ca_thunderhit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew086_at_ca_gene01_BCPTL)
  TMP(GARC_wazaeff_particle_ew086_df_ca_hit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew087_df_ca_floor01_BCPTL)
  TMP(GARC_wazaeff_particle_ew087_df_ca_thunder_BCPTL)
  TMP(GARC_wazaeff_particle_ew087_df_dr_smoke_BCPTL)
  TMP(GARC_wazaeff_particle_ew088_df_ca_headhit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew090_at_tr_bg01_BCPTL)
  TMP(GARC_wazaeff_particle_ew090_at_tr_quake01_BCPTL)
  TMP(GARC_wazaeff_particle_ew091_1_df_ca_hit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew091_at_ca_hole01_BCPTL)
  TMP(GARC_wazaeff_particle_ew092_at_ca_gene01_BCPTL)
  TMP(GARC_wazaeff_particle_ew092_df_ca_hit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew093_at_ca_espgene01_BCPTL)
  TMP(GARC_wazaeff_particle_ew093_df_ca_esphit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew094_at_ca_hypnotism01_BCPTL)
  TMP(GARC_wazaeff_particle_ew094_df_ca_phychohit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew095_at_ca_hypnotism01_BCPTL)
  TMP(GARC_wazaeff_particle_ew095_df_ca_hit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew096_at_ca_gene01_BCPTL)
  TMP(GARC_wazaeff_particle_ew097_at_ca_wind01_BCPTL)
  TMP(GARC_wazaeff_particle_ew098_at_ca_wind01_BCPTL)
  TMP(GARC_wazaeff_particle_ew098_df_ca_slash_hit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew099_at_ca_angry01_BCPTL)
  TMP(GARC_wazaeff_particle_ew099_df_ca_hit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew100_at_ca_teleport01_BCPTL)
  TMP(GARC_wazaeff_particle_ew100_at_ca_teleportfl01_BCPTL)
  TMP(GARC_wazaeff_particle_ew101_at_ca_gene01_BCPTL)
  TMP(GARC_wazaeff_particle_ew101_df_ca_hit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew101_df_ca_hitsmake01_BCPTL)
  TMP(GARC_wazaeff_particle_ew102_at_ca_circle01_BCPTL)
  TMP(GARC_wazaeff_particle_ew102_df_ca_magnetismcircle01_BCPTL)
  TMP(GARC_wazaeff_particle_ew102_df_ca_movecircle01_BCPTL)
  TMP(GARC_wazaeff_particle_ew103_at_ca_badsound01_BCPTL)
  TMP(GARC_wazaeff_particle_ew103_df_ca_badsoundhit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew105_at_ca_self_star_BCPTL)
  TMP(GARC_wazaeff_particle_ew106_at_ca_pt01_BCPTL)
  TMP(GARC_wazaeff_particle_ew107_at_ca_smallline01_BCPTL)
  TMP(GARC_wazaeff_particle_ew108_at_ca_moveball01_BCPTL)
  TMP(GARC_wazaeff_particle_ew108_df_ca_smoke01_BCPTL)
  TMP(GARC_wazaeff_particle_ew109_at_ca_movelight01_BCPTL)
  TMP(GARC_wazaeff_particle_ew109_df_ca_light01_BCPTL)
  TMP(GARC_wazaeff_particle_ew110_at_ca_bubble01_BCPTL)
  TMP(GARC_wazaeff_particle_ew110_at_ca_gene01_BCPTL)
  TMP(GARC_wazaeff_particle_ew111_at_ca_circleroll01_BCPTL)
  TMP(GARC_wazaeff_particle_ew111_at_ca_fl01_BCPTL)
  TMP(GARC_wazaeff_particle_ew112_at_ca_barrierfl01_BCPTL)
  TMP(GARC_wazaeff_particle_ew112_at_ca_circle01_BCPTL)
  TMP(GARC_wazaeff_particle_ew112_at_ca_fl01_BCPTL)
  TMP(GARC_wazaeff_particle_ew112_at_ca_ring01_BCPTL)
  TMP(GARC_wazaeff_particle_ew113_at_ca_lightwall01_BCPTL)
  TMP(GARC_wazaeff_particle_ew114_at_tr_smoke01_BCPTL)
  TMP(GARC_wazaeff_particle_ew115_at_ca_reflectorfl01_BCPTL)
  TMP(GARC_wazaeff_particle_ew116_at_ca_charge01_BCPTL)
  TMP(GARC_wazaeff_particle_ew117_at_ca_smoke01_BCPTL)
  TMP(GARC_wazaeff_particle_ew118_at_ca_hand01_BCPTL)
  TMP(GARC_wazaeff_particle_ew120_at_ca_explosion_BCPTL)
  TMP(GARC_wazaeff_particle_ew120_at_tr_ring_BCPTL)
  TMP(GARC_wazaeff_particle_ew120_df_ca_explosion_BCPTL)
  TMP(GARC_wazaeff_particle_ew121_df_ca_egghit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew122_df_ca_bero01_BCPTL)
  TMP(GARC_wazaeff_particle_ew123_at_ca_smoke01_BCPTL)
  TMP(GARC_wazaeff_particle_ew123_df_ca_smoke01_BCPTL)
  TMP(GARC_wazaeff_particle_ew123_df_ca_smokenx01_BCPTL)
  TMP(GARC_wazaeff_particle_ew124_at_ca_doro01muzzle_BCPTL)
  TMP(GARC_wazaeff_particle_ew124_at_ca_doroshot01_BCPTL)
  TMP(GARC_wazaeff_particle_ew124_df_ca_dorohit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew124_df_ca_shothit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew125_df_ca_hit_BCPTL)
  TMP(GARC_wazaeff_particle_ew126_at_ca_gene01_BCPTL)
  TMP(GARC_wazaeff_particle_ew126_at_ca_hit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew126_at_ca_shot01_BCPTL)
  TMP(GARC_wazaeff_particle_ew127_df_ca_waterfallhit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew128_df_ca_hit01_hit_BCPTL)
  TMP(GARC_wazaeff_particle_ew129_at_ca_starshot01_BCPTL)
  TMP(GARC_wazaeff_particle_ew129_df_ca_hit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew130_at_ca_charge01_BCPTL)
  TMP(GARC_wazaeff_particle_ew130_df_ca_headhit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew131_df_ca_hit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew133_at_ca_question01_BCPTL)
  TMP(GARC_wazaeff_particle_ew134_at_ca_gene01_BCPTL)
  TMP(GARC_wazaeff_particle_ew134_at_ca_success01_BCPTL)
  TMP(GARC_wazaeff_particle_ew135_at_ca_eggfl01_BCPTL)
  TMP(GARC_wazaeff_particle_ew135_df_ca_flash01_BCPTL)
  TMP(GARC_wazaeff_particle_ew136_df_ca_hit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew136_df_ca_hit02_BCPTL)
  TMP(GARC_wazaeff_particle_ew137_df_ca_eye01_BCPTL)
  TMP(GARC_wazaeff_particle_ew138_at_ca_hpup01_BCPTL)
  TMP(GARC_wazaeff_particle_ew138_df_ca_dreamsmoke01_BCPTL)
  TMP(GARC_wazaeff_particle_ew138_df_ca_movesmoke01_BCPTL)
  TMP(GARC_wazaeff_particle_ew139_at_ca_smoke01_BCPTL)
  TMP(GARC_wazaeff_particle_ew139_df_ca_smoke01_BCPTL)
  TMP(GARC_wazaeff_particle_ew140_at_ca_ball01_BCPTL)
  TMP(GARC_wazaeff_particle_ew141_at_ca_hpup01_BCPTL)
  TMP(GARC_wazaeff_particle_ew141_df_ca_hit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew141_df_ca_inpt01_BCPTL)
  TMP(GARC_wazaeff_particle_ew141_df_ca_uppt01_BCPTL)
  TMP(GARC_wazaeff_particle_ew142_df_ca_kiss01_BCPTL)
  TMP(GARC_wazaeff_particle_ew143_1_at_ca_wing01_BCPTL)
  TMP(GARC_wazaeff_particle_ew143_1_df_ca_featherhit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew143_at_ca_charge01_BCPTL)
  TMP(GARC_wazaeff_particle_ew145_at_ca_bubblemove01_BCPTL)
  TMP(GARC_wazaeff_particle_ew145_at_ca_bubblemuzzle01_BCPTL)
  TMP(GARC_wazaeff_particle_ew145_df_ca_bubblehit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew146_df_ca_piyopunch01_BCPTL)
  TMP(GARC_wazaeff_particle_ew147_at_ca_powder01_BCPTL)
  TMP(GARC_wazaeff_particle_ew147_df_ca_powder01_BCPTL)
  TMP(GARC_wazaeff_particle_ew148_at_ca_flashline01_BCPTL)
  TMP(GARC_wazaeff_particle_ew149_at_ca_espgene01_BCPTL)
  TMP(GARC_wazaeff_particle_ew149_at_ca_espmove01_BCPTL)
  TMP(GARC_wazaeff_particle_ew149_df_ca_esphit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew150_at_ca_jump01_BCPTL)
  TMP(GARC_wazaeff_particle_ew151_at_ca_melts01_BCPTL)
  TMP(GARC_wazaeff_particle_ew152_df_ca_crabhit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew154_df_ca_slash_hit_BCPTL)
  TMP(GARC_wazaeff_particle_ew155_at_ca_boomerang01_BCPTL)
  TMP(GARC_wazaeff_particle_ew156_at_ca_sleep01_BCPTL)
  TMP(GARC_wazaeff_particle_ew157_df_ca_rock_pt_BCPTL)
  TMP(GARC_wazaeff_particle_ew158_df_ca_tooth01_BCPTL)
  TMP(GARC_wazaeff_particle_ew159_at_ca_circleroll01_BCPTL)
  TMP(GARC_wazaeff_particle_ew159_at_ca_fl01_BCPTL)
  TMP(GARC_wazaeff_particle_ew159_at_ca_squarefl01_BCPTL)
  TMP(GARC_wazaeff_particle_ew160_at_ca_texture01_BCPTL)
  TMP(GARC_wazaeff_particle_ew161_at_ca_triatk_gene01_BCPTL)
  TMP(GARC_wazaeff_particle_ew161_at_ca_triatk_muzzle01_BCPTL)
  TMP(GARC_wazaeff_particle_ew161_at_ca_triatk_shot01fire_BCPTL)
  TMP(GARC_wazaeff_particle_ew161_at_ca_triatk_shot01ice_BCPTL)
  TMP(GARC_wazaeff_particle_ew161_at_ca_triatk_shot01thunder_BCPTL)
  TMP(GARC_wazaeff_particle_ew162_df_ca_tooth01_BCPTL)
  TMP(GARC_wazaeff_particle_ew163_df_ca_slash01_BCPTL)
  TMP(GARC_wazaeff_particle_ew165_at_ca_hit_BCPTL)
  TMP(GARC_wazaeff_particle_ew165_df_ca_hit_BCPTL)
  TMP(GARC_wazaeff_particle_ew166_at_ca_get01_BCPTL)
  TMP(GARC_wazaeff_particle_ew166_df_ca_pencil01_BCPTL)
  TMP(GARC_wazaeff_particle_ew167_df_ca_hit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew167_df_ca_hit02_BCPTL)
  TMP(GARC_wazaeff_particle_ew168_df_ca_hit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew169_at_ca_muzzle01_BCPTL)
  TMP(GARC_wazaeff_particle_ew169_at_ca_thread01_BCPTL)
  TMP(GARC_wazaeff_particle_ew169_df_ca_hit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew169_df_ca_hit02_BCPTL)
  TMP(GARC_wazaeff_particle_ew170_df_ca_eye01_BCPTL)
  TMP(GARC_wazaeff_particle_ew172_at_ca_circleroll01_BCPTL)
  TMP(GARC_wazaeff_particle_ew172_at_ca_fireroll01_BCPTL)
  TMP(GARC_wazaeff_particle_ew173_at_ca_snore01_BCPTL)
  TMP(GARC_wazaeff_particle_ew173_df_ca_snore01_BCPTL)
  TMP(GARC_wazaeff_particle_ew174_1_at_ca_curse01_BCPTL)
  TMP(GARC_wazaeff_particle_ew174_1_at_ca_hit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew174_at_ca_curse01_BCPTL)
  TMP(GARC_wazaeff_particle_ew175_at_ca_panic01_BCPTL)
  TMP(GARC_wazaeff_particle_ew176_df_ca_texture2_01_BCPTL)
  TMP(GARC_wazaeff_particle_ew177_at_ca_aeroshot01_BCPTL)
  TMP(GARC_wazaeff_particle_ew177_at_ca_gene01_BCPTL)
  TMP(GARC_wazaeff_particle_ew177_at_ca_muzzle01_BCPTL)
  TMP(GARC_wazaeff_particle_ew177_at_tr_bgwind01_BCPTL)
  TMP(GARC_wazaeff_particle_ew177_df_ca_hit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew178_at_ca_powder01_BCPTL)
  TMP(GARC_wazaeff_particle_ew178_df_ca_powder01_BCPTL)
  TMP(GARC_wazaeff_particle_ew179_at_ca_returnstrike01_BCPTL)
  TMP(GARC_wazaeff_particle_ew179_df_ca_hit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew181_at_ca_movsnow01_BCPTL)
  TMP(GARC_wazaeff_particle_ew181_at_ca_snow01_BCPTL)
  TMP(GARC_wazaeff_particle_ew181_df_ca_snow01_BCPTL)
  TMP(GARC_wazaeff_particle_ew182_at_ca_barrier01_BCPTL)
  TMP(GARC_wazaeff_particle_ew183_df_ca_punch01_BCPTL)
  TMP(GARC_wazaeff_particle_ew184_at_ca_face01_BCPTL)
  TMP(GARC_wazaeff_particle_ew185_df_ca_hit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew186_df_ca_angel01_BCPTL)
  TMP(GARC_wazaeff_particle_ew186_df_ca_kiss01_BCPTL)
  TMP(GARC_wazaeff_particle_ew187_df_ca_hit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew188_at_ca_hedoroshot01_BCPTL)
  TMP(GARC_wazaeff_particle_ew188_df_ca_hedorohit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew189_at_ca_doro01muzzle_BCPTL)
  TMP(GARC_wazaeff_particle_ew189_at_ca_doroshot01_BCPTL)
  TMP(GARC_wazaeff_particle_ew189_df_ca_dorohit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew189_df_ca_dorosly01_BCPTL)
  TMP(GARC_wazaeff_particle_ew190_at_ca_sumi01muzzle_BCPTL)
  TMP(GARC_wazaeff_particle_ew190_at_ca_sumishot01_BCPTL)
  TMP(GARC_wazaeff_particle_ew190_df_ca_sumihit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew190_df_ca_sumisly01_BCPTL)
  TMP(GARC_wazaeff_particle_ew192_at_ca_gene01_BCPTL)
  TMP(GARC_wazaeff_particle_ew192_at_ca_muzzle01_BCPTL)
  TMP(GARC_wazaeff_particle_ew192_at_ca_shot01_BCPTL)
  TMP(GARC_wazaeff_particle_ew193_df_ca_detects01_BCPTL)
  TMP(GARC_wazaeff_particle_ew210_df_ca_slash01_BCPTL)
  TMP(GARC_wazaeff_particle_ew232_df_ca_tsumehit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew299_df_ca_firehit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew299_df_ca_firemove01_BCPTL)
  TMP(GARC_wazaeff_particle_ew306_df_ca_tsumehit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew315_at_ca_fire_BCPTL)
  TMP(GARC_wazaeff_particle_ew315_at_ca_heat_start_BCPTL)
  TMP(GARC_wazaeff_particle_ew315_at_ca_smoke_BCPTL)
  TMP(GARC_wazaeff_particle_ew337_at_ca_aura01_BCPTL)
  TMP(GARC_wazaeff_particle_ew337_df_ca_tsumehit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew421_df_ca_hit_BCPTL)
  TMP(GARC_wazaeff_particle_ew437_at_ca_line_BCPTL)
  TMP(GARC_wazaeff_particle_ew437_at_tr_move_bg_BCPTL)
  TMP(GARC_wazaeff_particle_ew437_df_ca_hit_BCPTL)
  TMP(GARC_wazaeff_particle_ew533_df_ca_floor_BCPTL)
  TMP(GARC_wazaeff_particle_ew533_df_ca_slash_BCPTL)
  TMP(GARC_wazaeff_particle_ew567_at_ca_ghost01_BCPTL)
  TMP(GARC_wazaeff_particle_ew567_df_ca_ghost01_BCPTL)
  TMP(GARC_wazaeff_particle_ew567_df_ca_ghost02_BCPTL)
  TMP(GARC_wazaeff_particle_ew577_df_ca_hit01_BCPTL)
  TMP(GARC_wazaeff_particle_ew577_df_ca_life01_BCPTL)
  TMP(GARC_wazaeff_particle_ew580_at_ca_gene01_BCPTL)
  TMP(GARC_wazaeff_particle_ew580_at_ca_genegrass01_BCPTL)
  TMP(GARC_wazaeff_particle_ew580_at_ca_genein01_BCPTL)
  TMP(GARC_wazaeff_particle_ew581_at_ca_gene01_BCPTL)
  TMP(GARC_wazaeff_particle_ew581_at_ca_genein01_BCPTL)
  TMP(GARC_wazaeff_particle_ew581_at_tr_smoke01_BCPTL)
  TMP(GARC_wazaeff_particle_hidropomp_BCPTL)
  TMP(GARC_wazaeff_particle_se_002_doku_BCPTL)
  TMP(GARC_wazaeff_particle_w092_dokudoku_BCPTL)
  TMP(GARC_wazaeff_particle_w231_irontail_BCPTL)
  TMP(GARC_wazaeff_particle_w231_kirakira_BCPTL)
};
#undef TMP

int findIndex(int id, const Edit* table, int length)
{
  for(int i = 0; i < length; ++i)
  {
    if(id == table[i].id){return i;}
  }
  return -1;
}
wchar_t* findText(int id, const Edit* table, int length)
{
  if(id == -1){return L"-";}
  for(int i = 0; i < length; ++i)
  {
    if(id == table[i].id){return table[i].text;}
  }
  return L"error";
}
void EditScene::Enter()
{
  m_second = 0;
}

bool EditScene::Update()
{
  if(m_owner->GetButton()->IsRepeat(gfl::ui::BUTTON_UP))
  {
    --m_cursor;
    if(m_cursor < CURSOR_MIN){m_cursor = CURSOR_MAX;}
  }
  if(m_owner->GetButton()->IsRepeat(gfl::ui::BUTTON_DOWN))
  {
    ++m_cursor;
    if(m_cursor > CURSOR_MAX){m_cursor = CURSOR_MIN;}
  }
  
  // b𑀍
  if(m_owner->GetButton()->IsRepeat(gfl::ui::BUTTON_L))
  {
    --m_second;
    if(m_second < 0){m_second = 0;}
  }
  if(m_owner->GetButton()->IsRepeat(gfl::ui::BUTTON_R))
  {
    ++m_second;
    if(m_second == m_owner->GetRecordSize()){m_second = m_owner->GetRecordSize()-1;}
  }
  switch(m_cursor)
  {
  case CURSOR_SECOND:
    break;
    
  case CURSOR_MOTION:
  case CURSOR_ROTATION:
  case CURSOR_BGM:
  case CURSOR_SE:
  case CURSOR_CAMERA:
  case CURSOR_PARTICLE:
  case CURSOR_TEXT:
  case CURSOR_TEXT_POS:
  case CURSOR_BG:
  case CURSOR_BLIGHTNESS:
    {
      int index = this->GetIndexWithCursor(m_cursor);
      if(m_owner->GetButton()->IsRepeat(gfl::ui::BUTTON_LEFT))
      {
        --index;
        this->SetParamWithCursorAndIndex(m_cursor, index);
      }
      if(m_owner->GetButton()->IsRepeat(gfl::ui::BUTTON_RIGHT))
      {
        ++index;
        this->SetParamWithCursorAndIndex(m_cursor, index);
      }
      
    }
    break;
  }
  
  if(m_owner->GetButton()->IsTrigger(gfl::ui::BUTTON_B))
  {
    m_owner->SetNext<SelectScene>();
  }
  return true;
}

int EditScene::GetIndexWithCursor(int cursor)
{
  switch(cursor)
  {
  case CURSOR_MOTION:
    return findIndex(m_owner->GetRecord()[m_second].model.motion, s_motion, GFL_NELEMS(s_motion));
  case CURSOR_ROTATION:
    return findIndex(m_owner->GetRecord()[m_second].model.rotation, s_rotate, GFL_NELEMS(s_rotate));
  case CURSOR_BGM:
    return findIndex(m_owner->GetRecord()[m_second].bgm, s_bgm, GFL_NELEMS(s_bgm));
  case CURSOR_SE:
    return findIndex(m_owner->GetRecord()[m_second].se, s_se, GFL_NELEMS(s_se));
  case CURSOR_CAMERA:
    return findIndex(m_owner->GetRecord()[m_second].camera, s_camera, GFL_NELEMS(s_camera));
  case CURSOR_PARTICLE:
    return findIndex(m_owner->GetRecord()[m_second].particle, s_particle, GFL_NELEMS(s_particle));
  case CURSOR_TEXT:
    return findIndex(m_owner->GetRecord()[m_second].telop[0].text, s_text, GFL_NELEMS(s_text));
  case CURSOR_TEXT_POS:
    return findIndex(m_owner->GetRecord()[m_second].telop[0].pos, s_text_pos, GFL_NELEMS(s_text_pos));
  case CURSOR_BG:
    return findIndex(m_owner->GetRecord()[m_second].background.bg, s_bg, GFL_NELEMS(s_bg));
  case CURSOR_BLIGHTNESS:
    return findIndex(m_owner->GetRecord()[m_second].background.blightness, s_blightness, GFL_NELEMS(s_blightness));
  }
  GFL_ASSERT(1);
  return -1;
}

void EditScene::SetParamWithCursorAndIndex(int cursor, int index)
{
  int value = -1;
  switch(cursor)
  {
  case CURSOR_MOTION:
    if(index >= (int)GFL_NELEMS(s_motion)){return;}
    if(index >= 0){value = s_motion[index].id;}
    m_owner->GetRecord()[m_second].model.motion = value;
    break;
  case CURSOR_ROTATION:
    if(index >= (int)GFL_NELEMS(s_rotate)){return;}
    if(index >= 0){value = s_rotate[index].id;}
    m_owner->GetRecord()[m_second].model.rotation = value;
    break;
  case CURSOR_BGM:
    if(index >= (int)GFL_NELEMS(s_bgm)){return;}
    if(index >= 0){value = s_bgm[index].id;}
    m_owner->GetRecord()[m_second].bgm = value;
    break;
  case CURSOR_SE:
    if(index >= (int)GFL_NELEMS(s_se)){return;}
    if(index >= 0){value = s_se[index].id;}
    m_owner->GetRecord()[m_second].se = value;
    break;
  case CURSOR_CAMERA:
    if(index >= (int)GFL_NELEMS(s_camera)){return;}
    if(index >= 0){value = s_camera[index].id;}
    m_owner->GetRecord()[m_second].camera = value;
    break;
  case CURSOR_PARTICLE:
    if(index >= (int)GFL_NELEMS(s_particle)){return;}
    if(index >= 0){value = s_particle[index].id;}
    m_owner->GetRecord()[m_second].particle = value;
    break;
  case CURSOR_TEXT:
    if(index >= (int)GFL_NELEMS(s_text)){return;}
    if(index >= 0){value = s_text[index].id;}
    m_owner->GetRecord()[m_second].telop[0].text = value;
    break;
  case CURSOR_TEXT_POS:
    if(index >= (int)GFL_NELEMS(s_text_pos)){return;}
    if(index >= 0){value = s_text_pos[index].id;}
    m_owner->GetRecord()[m_second].telop[0].pos = value;
    break;
  case CURSOR_BG:
    if(index >= (int)GFL_NELEMS(s_bg)){return;}
    if(index >= 0){value = s_bg[index].id;}
    m_owner->GetRecord()[m_second].background.bg = value;
    break;
  case CURSOR_BLIGHTNESS:
    if(index >= (int)GFL_NELEMS(s_blightness)){return;}
    if(index >= 0){value = s_blightness[index].id;}
    m_owner->GetRecord()[m_second].background.blightness = value;
    break;
  }
  GFL_ASSERT(1);
}

void EditScene::Exit()
{
}

void EditScene::Draw()
{
  gfl::grp::util::DrawUtil::SetTextScale(0.4,0.4);
  
  gfl::grp::util::DrawUtil::DrawText(0, 0, L"<<<ҏWij>>>");
  
  Record rec = m_owner->GetRecord()[m_second];
  
  int y = 40; int y_add = 15;
  gfl::grp::util::DrawUtil::DrawText(0, y+15*m_cursor, L"r");
  gfl::grp::util::DrawUtil::DrawText(0, y, L"@bF%d", m_second);
  y += y_add;
  gfl::grp::util::DrawUtil::DrawText(0, y, L"@f̃[VF%ls", findText(rec.model.motion, s_motion, GFL_NELEMS(s_motion)));
  y += y_add;
  gfl::grp::util::DrawUtil::DrawText(0, y, L"@f̌@@@F%ls", findText(rec.model.rotation, s_rotate, GFL_NELEMS(s_rotate)));
  y += y_add;
  gfl::grp::util::DrawUtil::DrawText(0, y, L"@afl@@@@@@F%ls", findText(rec.bgm, s_bgm, GFL_NELEMS(s_bgm)));
  y += y_add;
  gfl::grp::util::DrawUtil::DrawText(0, y, L"@rd@@@@@@@F%ls", findText(rec.se, s_se, GFL_NELEMS(s_se)));
  y += y_add;
  gfl::grp::util::DrawUtil::DrawText(0, y, L"@J@@@@@@F%ls", findText(rec.camera, s_camera, GFL_NELEMS(s_camera)));
  y += y_add;
  gfl::grp::util::DrawUtil::DrawText(0, y, L"@p[eBN@@@F%ls", findText(rec.particle, s_particle, GFL_NELEMS(s_particle)));
  y += y_add;
  gfl::grp::util::DrawUtil::DrawText(0, y, L"@ebveLXg@F%ls", findText(rec.telop[0].text, s_text, GFL_NELEMS(s_text)));
  y += y_add;
  gfl::grp::util::DrawUtil::DrawText(0, y, L"@ebvʒu@@@F%ls", findText(rec.telop[0].pos, s_text_pos, GFL_NELEMS(s_text_pos)));
  y += y_add;
  gfl::grp::util::DrawUtil::DrawText(0, y, L"@wi@@@@@@@F%ls", findText(rec.background.bg, s_bg, GFL_NELEMS(s_bg)));
  y += y_add;
  gfl::grp::util::DrawUtil::DrawText(0, y, L"@wïÂ@@@@F%ls", findText(rec.background.blightness, s_blightness, GFL_NELEMS(s_blightness)));
  y += y_add;
}

GFL_NAMESPACE_END(promotion)
GFL_NAMESPACE_END(app)
