
//=============================================================================
/**
 * @file   CameraLookAtBase.cpp
 * @brief  J_NX
 * @author rc N
 * @date   2012.06.06
 */
//=============================================================================

#include "CameraLookAtBase.h"
#include "CameraUtility.h"

namespace field
{
  static const float SPRING_COE_MIN = 2.7f;
  static const gfl::math::VEC3 SPRING_COE_MIN_VEC(SPRING_COE_MIN, SPRING_COE_MIN, SPRING_COE_MIN);

  //-----------------------------------------------------------------------------
  // RXgN^
  //-----------------------------------------------------------------------------
  CCameraLookAtBase::CCameraLookAtBase() :
  m_inPosi    (gfl::math::VEC3_ZERO) ,
  m_inHopePosi(gfl::math::VEC3_ZERO)
  {
    m_inSpringCoe.SetParam(3.0f);
    m_inSpringCoe.Reset(SPRING_COE_MIN_VEC);
  }
  
  //-----------------------------------------------------------------------------
  // t[
  //-----------------------------------------------------------------------------
  void CCameraLookAtBase::Update(float* pfOfstMaxX, float* pfOfstMaxY, const CCameraTarget& inTarget, const CCameraInfo& inCamera, const ECameraBehindMode eMode, const float fDiffTime)
  {
    gfl::math::VEC3 inPreHopePosi = m_inHopePosi;
    m_inHopePosi = inTarget.GetCenterPosition();

    if( eMode == CAMERA_BEHIND_MODE_RESET )
    {
      m_inPosi = inPreHopePosi = m_inHopePosi;
      m_inSpringCoe.Reset(SPRING_COE_MIN_VEC);
    }
    
    gfl::math::VEC3 ainAxis[3];
    gfl::math::MTX33GetAxisX(&ainAxis[0], inCamera.m_inMatrix);
    gfl::math::MTX33GetAxisY(&ainAxis[1], inCamera.m_inMatrix);
    gfl::math::MTX33GetAxisZ(&ainAxis[2], inCamera.m_inMatrix);

    // ]ʒugpƂPt[ő傫ړƂɌ덷傫ȂĂ܂̂ŁAt[̘A𗘗pĂPt[O̊]ʒugpB
    const float fDistZ = gfl::math::FAbs(CUtil::GetAxisLength(inPreHopePosi - inCamera.m_inPosi, ainAxis[2]));
    (*pfOfstMaxY) = fDistZ*gfl::math::TanRad(0.5f*inCamera.m_fViewAngle);
    (*pfOfstMaxX) = inCamera.m_fAspectRatio*(*pfOfstMaxY);

    if( eMode != CAMERA_BEHIND_MODE_RESET )
    {
      const gfl::math::VEC3 inCurHopeVec = m_inHopePosi - m_inPosi;

      const float RATIO_X = 0.01f, RATIO_Y = 0.01f, RATIO_Z = 0.15f;
      const float afAxisDiffMax[3] = { RATIO_X*(*pfOfstMaxX), RATIO_Y*(*pfOfstMaxY), RATIO_Z*inCamera.m_fDistToLookAt };

      float afAxisDiff[3];
      gfl::math::VEC3 inHopeSpringCoe(SPRING_COE_MIN_VEC);
      for( int i = 0; i < 3; i++ )
      {
        afAxisDiff[i] = CUtil::GetAxisLength(inCurHopeVec, ainAxis[i]);

        const float fAxisDiffAbs = gfl::math::FAbs(afAxisDiff[i]);
        if( fAxisDiffAbs > afAxisDiffMax[i] )
        {
          inHopeSpringCoe[i] = (fAxisDiffAbs-afAxisDiffMax[i]) / (fAxisDiffAbs*fDiffTime);
          CUtil::MinClip(&(inHopeSpringCoe[i]), SPRING_COE_MIN);
        }
      }

      const gfl::math::VEC3 inSpringCoe = m_inSpringCoe.Update(inHopeSpringCoe, fDiffTime);
      for( int i = 0; i < 3; i++ ) m_inPosi += GetSpringInterpolateMove(inSpringCoe[i], INTERPOLATE_VEL_MAX_INFINITY, 0.0f, afAxisDiff[i], fDiffTime)*ainAxis[i];
  	}
  }

  //-----------------------------------------------------------------------------
  // fobO`
  //-----------------------------------------------------------------------------
  void CCameraLookAtBase::DrawDebug()
  {
#if 0
    const gfl::math::VEC3 inSpringCoe = m_inSpringCoe.GetValue();
    gfl::grp::util::DrawUtil::DrawText(10, 10, L"%.2f %.2f %.2f", inSpringCoe.x, inSpringCoe.y, inSpringCoe.z);
#endif
  }

} // namespace field


/*  EOF  */





