
#if PM_DEBUG

///////////////////////////////////////////////////////////////////////////////////////
/**
 * @file   test_ikuta_game_CTitleFrontEnd.h
 * @brief  [VlC~jQ[]^CgtgGh
            ʑ
 * @author junya ikuta
 * @date  2012/06/05() 16:59
 */
///////////////////////////////////////////////////////////////////////////////////////
#pragma once

// sys
#include <grp/g2d/gfl_LytSys.h>

// appSys

// app
#include "../test_ikuta_game_CResourceObjectBase.h"        


namespace test {
  namespace ikuta {
    namespace game {

      class CTitleFrontEnd : public CResourceObjectBase
      {
        GFL_FORBID_COPY_AND_ASSIGN( CTitleFrontEnd );                // ֎~

        typedef CResourceObjectBase base;

        public:

        enum STATE {
          STATE_NULL = 0,          // 
          STATE_LOAD,              //
          STATE_WAIT,              // ҋ@H
          STATE_FRAME_IN,          // \Aj[V
          STATE_UPDATE,            // ʏXVASTATE_FRAME_IN玩őJڂB^b`̂蔻ōs
          STATE_FRAME_OUT,         // \Aj[V
          
          STATE_MAX
        };

        enum MESSAGE {
          MESSAGE_SETUP_TITLE = 0,          // ^CgJnԂɃZbgAbv
          MESSAGE_SETUP_TITLE_ENTER,        // ^CgŌ{^ꂽԂɂ
   
          MESSAGE_MAX
        };


        // e̎؂蕨
        struct RENTAL_PTR_SET{

          gfl::grp::g2d::LytSys*        pLayOutSystem;        // 郌CAEgVXe
          app::util::Heap*              pHeap;                // gpq[v  
          gfl::fs::FileReadManager*     pFileReadManager;     // 񓯊t@Cǂݍ
          gfl::ui::TouchPanel*          pTouchpanel;          // ^b`plԂ̎擾


          RENTAL_PTR_SET() :
            pLayOutSystem( NULL ),
            pHeap( NULL ),
            pFileReadManager( NULL ),
            pTouchpanel( NULL )
          {
          }
        };

        // p\
        struct SETUP_PARAM{
          u32                           arcId;                // gpA[Nt@CID

          SETUP_PARAM() : 
            arcId( 0 )
          {
          }
        };

        //------------------------------------------------------------------
        /**
         * @name     CTitleFrontEnd[RXgN^]
         * @brief    ϐ̏s
         */
        //------------------------------------------------------------------
        CTitleFrontEnd( void );

        //------------------------------------------------------------------
        /**
         * @name     ~CTitleFrontEnd[fXgN^]
         * @brief    FinalizeĂяo
         */
        //------------------------------------------------------------------
        virtual ~CTitleFrontEnd();

        //------------------------------------------------------------------
        /**
         * @name      Initialize
         * @brief     A[hI܂ŊĂ܂B 
         * @pram      rRentalPtr  ؂蕨̃|C^Zbg[const]
         * @pram      rSetUp      [const]
         * @return    true : 
         */
        //------------------------------------------------------------------
        bool Initialize( const RENTAL_PTR_SET& rRentalPtr, const SETUP_PARAM& rSetUp);

        //------------------------------------------------------------------
        /**
         * @name     Finalize
         * @brief    I
         */
        //------------------------------------------------------------------
        void Finalize( void );

        //------------------------------------------------------------------
        /**
         * @name      Update
         * @brief     XVA[hLoadUpdate𐄏
         * @return    ݂̏
         */
        //------------------------------------------------------------------
        STATE Update( void );

        //------------------------------------------------------------------
        /**
         * @name     LoadUpdate[virtual]
         * @brief    [hǂݐi߂鏃z֐A[hIŕKSetUpLoadAndSetupEnd()ĂԁB
         * @return   true : [hs
         */
        //------------------------------------------------------------------
        bool LoadUpdate(void);   

       //------------------------------------------------------------------
        /**
         * @name      Draw
         * @brief     `揈AȂ
         */
        //------------------------------------------------------------------
        void Draw( void );

        //------------------------------------------------------------------
        /**
         * @name      AddScene
         * @brief     V[(CAEgVXe)Ɏgǉ
         */
        //------------------------------------------------------------------
        void AddScene(void);      
      
        //------------------------------------------------------------------
        /**
         * @name      RemoveScene
         * @brief     V[(CAEgVXe)玩g菜
         */
        //------------------------------------------------------------------
        void RemoveScene(void);      

        //------------------------------------------------------------------
        /**
         * @name      Message
         * @brief     ÕbZ[W
         * @param     message     bZ[Wʎq
         * @return    true : K؂ɏꂽ
         */
        //------------------------------------------------------------------
        b32 Message(MESSAGE message);     

        //------------------------------------------------------------------
        /**
         * @name      IsStateEnd
         * @brief     ݂̏ԂIĂ邩擾
         * @return    true : IĂ
         */
        //------------------------------------------------------------------
        b32 IsStateEnd( void ) const
        {
          return m_StateEndFlag;
        } 

        protected:

        //------------------------------------------------------------------
        /**
         * @name      ChangeAnimation
         * @brief     Aj[V̊Jn
         * @param     index       Aj[Vԍ
         */
        //------------------------------------------------------------------
        void StartAnimation( u32 index );

        //------------------------------------------------------------------
        /**
         * @name      StopAnimation
         * @brief     Aj[ṼXgbv
         * @param     index       Aj[Vԍ
         */
        //------------------------------------------------------------------
        void StopAnimation( u32 index );

        //------------------------------------------------------------------
        /**
         * @name      StopAnimationAll
         * @brief     SẴAj[VXgbv
         */
        //------------------------------------------------------------------
        void StopAnimationAll( void );

        // ʏϐ
        STATE                           m_State;              // ԕϐ
        b32                             m_StateEndFlag;       // true L̏Ԃłׂ͏IĂ

        // VXe
        RENTAL_PTR_SET*                 m_pRentalPtrSet;      // w̎؂蕨̕ۊ


        // \[X֘A
        gfl::grp::g2d::LytResID         m_ResID;              // CAEgVXeID
        gfl::grp::g2d::LytWk*           m_pLayOutWorkLower;   // CAEg1

        void*                           m_pBuf;               // 񓯊ǂݍݗpobt@|C^ 
      };

    } // namespace game
  } // namespace ikuta
} // namespace test

#endif // PM_DEBUG


// EOF
