

#if PM_DEBUG

///////////////////////////////////////////////////////////////////////////////////////
/**
 * @file   test_ikuta_game_CTitleFrontEnd.cpp
 * @brief  [VlC~jQ[]^CgtgGh
 ʑ
 * @author junya ikuta
 * @date  2012/06/05() 16:59
 */
///////////////////////////////////////////////////////////////////////////////////////
#pragma once

// sys

// appSys

// app
#include "test_ikuta_game_CTitleFrontEnd.h"        
#include "../resource/test_ikuta_game_resource_LayOut.h"

// res
//#include "../resource/frontend_play_upper_pane.h"

namespace test {
  namespace ikuta {
    namespace game {

      //------------------------------------------------------------------
      /**
       * @name     CTitleFrontEnd[RXgN^]
       * @brief    ϐ̏s
       */
      //------------------------------------------------------------------
      CTitleFrontEnd::CTitleFrontEnd( void ) :
        m_State( STATE_NULL ),
        m_StateEndFlag( false ),
        m_pRentalPtrSet( NULL ),
        m_ResID( 0 ),
        m_pLayOutWorkLower( NULL ),
        m_pBuf( NULL )
      {

      }

      //------------------------------------------------------------------
      /**
       * @name     ~CTitleFrontEnd[fXgN^]
       * @brief    FinalizeĂяo
       */
      //------------------------------------------------------------------
      CTitleFrontEnd::~CTitleFrontEnd()
      {
        Finalize();
      }

      //------------------------------------------------------------------
      /**
       * @name      Initialize
       * @brief     A[hI܂ŊĂ܂B 
       * @pram      rRentalPtr  ؂蕨̃|C^Zbg[const]
       * @pram      rSetUp      [const]
       * @return    true : 
       */
      //------------------------------------------------------------------
      bool CTitleFrontEnd::Initialize( const RENTAL_PTR_SET& rRentalPtr, const SETUP_PARAM& rSetUp)
      {
        // `FbN
        //   GFL_ASSERT
        //  rRentalPtr.

        // ܂؂蕨[
        m_pRentalPtrSet = GFL_NEW( rRentalPtr.pHeap->pHeap )RENTAL_PTR_SET;
        *m_pRentalPtrSet = rRentalPtr;


        // 񓯊\[X̓ǂݍ
        m_pRentalPtrSet->pFileReadManager->AddReadRequest(
            &m_pBuf,
            NULL,
            m_pRentalPtrSet->pHeap->pDevHeap,
            128,
            rSetUp.arcId,
            LAYOUT_ARCID_FRONTEND_PLAY_UPPER,
            true
            );

        // [hԂɈڍs
        base::LoadStart();
        m_State = STATE_LOAD;
        m_StateEndFlag = false;
        return true;   

      }

      //------------------------------------------------------------------
      /**
       * @name     Finalize
       * @brief    I
       */
      //------------------------------------------------------------------
      void CTitleFrontEnd::Finalize( void )
      {

      }

      //------------------------------------------------------------------
      /**
       * @name      Update
       * @brief     XVA[hLoadUpdate𐄏
       * @return    ݂̏
       */
      //------------------------------------------------------------------
      CTitleFrontEnd::STATE CTitleFrontEnd::Update( void )
      {
        if( m_StateEndFlag )
          return m_State;

        switch( m_State )
        {
        case STATE_LOAD:
          LoadUpdate();
          break;

        case STATE_FRAME_IN:
          {

            break;
          }
        }

        return m_State;
      }

      //------------------------------------------------------------------
      /**
       * @name     LoadUpdate[virtual]
       * @brief    [hǂݐi߂鏃z֐A[hIŕKSetUpLoadAndSetupEnd()ĂԁB
       * @return   true : [hs
       */
      //------------------------------------------------------------------
      bool CTitleFrontEnd::LoadUpdate(void)
      {
        if(m_State != STATE_LOAD)
          return false;

        bool endFlag(true);

        // f̓ǂݍ
        if( !m_pLayOutWorkUpper )
        {
          // ǂݍ݂҂
          if( m_pRentalPtrSet->pFileReadManager->IsReadFinished(&m_pBuf) )
          {
            // \[Xǂݍ
            m_ResID = m_pRentalPtrSet->pLayOutSystem->LoadLytRes(
                m_pRentalPtrSet->pHeap->pDevHeapAllocator, 
                m_pBuf
                );
            //         GFL_SAFE_DELETE_ARRAY( m_pBuf );

            // VRAMɃeNX`]
            m_pRentalPtrSet->pLayOutSystem->TransferAllTexture( m_ResID, gfl::grp::MEMORY_AREA_FCRAM );

            // CAEg[N𐶐
            m_pLayOutWorkLower = m_pRentalPtrSet->pLayOutSystem->CreateLytWk( 
                m_ResID, 
                FRONTEND_PLAY_UPPER_DATID_CLYT, 
                &A_FRONTEND_PLAY_UPPER_ANIMATION_ID_INDEX[0], 
                FRONTEND_PLAY_UPPER_ANIMATION_MAX, 
                FRONTEND_PLAY_UPPER_ANIMATION_MAX, 
                &LAYOUT_WORK_SETUP, 
                false            
                );

            m_pLayOutWorkLower->SetAutoDrawFlag( false ); 
          }
          else
          {
            endFlag = false;
          }
        }

        if( endFlag )
        {
          m_State = STATE_UPDATE;
          base::LoadAndSetupEnd();

          return false;
        }

        return true;
      }

      //------------------------------------------------------------------
      /**
       * @name      Draw
       * @brief     `揈AȂ
       */
      //------------------------------------------------------------------
      void CTitleFrontEnd::Draw( void )
      {

      }

      //------------------------------------------------------------------
      /**
       * @name      AddScene
       * @brief     V[(CAEgVXe)Ɏgǉ
       */
      //------------------------------------------------------------------
      void CTitleFrontEnd::AddScene(void)
      {
        m_pLayOutWorkUpper->SetAutoDrawFlag( true ); 
      }

      //------------------------------------------------------------------
      /**
       * @name      RemoveScene
       * @brief     V[(CAEgVXe)玩g菜
       */
      //------------------------------------------------------------------
      void CTitleFrontEnd::RemoveScene(void)
      {
        m_pLayOutWorkUpper->SetAutoDrawFlag( false ); 
      }

      //------------------------------------------------------------------
      /**
       * @name      Message
       * @brief     ÕbZ[W
       * @param     message     bZ[Wʎq
       * @return    true : K؂ɏꂽ
       */
      //------------------------------------------------------------------
      b32 CTitleFrontEnd::Message(MESSAGE message)
      {
        switch( message )
        {
        case MESSAGE_SETUP_TITLE:         // ^Cg
          {

            return true;
          }
        case MESSAGE_SETUP_TITLE_ENTER :  // ^CgŌ{^ꂽԂɃZbgAbv
          {
            ChangeAnimation( FRONTEND_PLAY_UPPER_ANIMATION_FRAME_IN );
            m_State = STATE_FRAME_IN;
            m_StateEndFlag = false;
            return true;
          }
        }
        return false;
      }

      //  protected:

      //------------------------------------------------------------------
      /**
       * @name      StartAnimation
       * @brief     Aj[V̊Jn
       * @param     index       Aj[Vԍ
       */
      //------------------------------------------------------------------
      void CTitleFrontEnd::StartAnimation( u32 index)
      {
        if(!m_pLayOutWorkLower->IsBindAnime(index))
          m_pLayOutWorkLower->BindAnime( index );

        m_pLayOutWorkLower->SetAnimeFrame( index, 0);
        m_pLayOutWorkLower->SetAutoAnime( index , true );
      }

      //------------------------------------------------------------------
      /**
       * @name      StopAnimation
       * @brief     Aj[ṼXgbv
       * @param     index       Aj[Vԍ
       */
      //------------------------------------------------------------------
      void CTitleFrontEnd::StopAnimation( u32 index )
      {
        if(!m_pLayOutWorkLower->IsBindAnime(index))
          return;

        m_pLayOutWorkLower->UnBindAnime( index );
        m_pLayOutWorkLower->SetAutoAnime( index , false );
      }

      //------------------------------------------------------------------
      /**
       * @name      StopAnimationAll
       * @brief     SẴAj[VXgbv
       */
      //------------------------------------------------------------------
      void CTitleFrontEnd::StopAnimationAll( void )
      {
        // I[gAj̃It͕KvH
        // for()

        m_pLayOutWorkLower->UnBindAnimeAll();
      }

    } // namespace game
  } // namespace ikuta
} // namespace test

#endif // PM_DEBUG


// EOF
