


#if PM_DEBUG

///////////////////////////////////////////////////////////////////////////////////////
/**
 * @file   test_ikuta_game_CTimer.cpp
 * @brief  [VlC~jQ[]Ԑ
 CPlayFrontEndɒlm点AGetState()ŏԂĎăQ[IB
 * @author junya ikuta
 * @date   2012/05/23() 17:21
 */
///////////////////////////////////////////////////////////////////////////////////////
#pragma once

// sys

// appSys

// app
#include "test_ikuta_game_CTimer.h"
#include "test_ikuta_game_CPlayFrontEnd.h"        

namespace test {
  namespace ikuta {
    namespace game {

      //------------------------------------------------------------------
      /**
       * @name      CTimer[RXgN^]
       * @brief     ϐ̏s
       */
      //------------------------------------------------------------------
      CTimer::CTimer( void ) :
        m_State( STATE_NULL ),
        m_StateEndFlag( false ),
        m_pSetUp( NULL ),
        m_pRentalPtrSet( NULL )
      {


      }

      //------------------------------------------------------------------
      /**
       * @name      ~CTimer[fXgN^]
       * @brief     Finalize()ĂяoB
       */
      //------------------------------------------------------------------
      CTimer::~CTimer( void )
      {
        Finalize();
      }

      //------------------------------------------------------------------
      /**
       * @name      Initialize
       * @brief     
       * @pram      rRentalPtr  ؂蕨̃|C^Zbg[const]
       * @pram      rSetUp      [const]
       * @return    true : 
       */
      //------------------------------------------------------------------
      b32 CTimer::Initialize( const RENTAL_PTR_SET& rRentalPtr, const SETUP_PARAM& rSetUp)
      {
        // ܂؂蕨[
        m_pRentalPtrSet = GFL_NEW( rRentalPtr.pHeap->pHeap )RENTAL_PTR_SET;
        *m_pRentalPtrSet = rRentalPtr;

        m_pSetUp = GFL_NEW( rRentalPtr.pHeap->pHeap )SETUP_PARAM;
        *m_pSetUp = rSetUp;

        // Abt[lɕϊ
        SetUpFrameCntDown();

        m_State = STATE_WAIT;
        m_StateEndFlag = true;

        return true;
      }

      //------------------------------------------------------------------
      /**
       * @name     Finalize
       * @brief    I
       */
      //------------------------------------------------------------------
      void CTimer::Finalize( void )
      {

      }

      //------------------------------------------------------------------
      /**
       * @name      Update
       * @brief     XVACPlayFrontEndɒlm点
       * @return    ݂̏
       */
      //------------------------------------------------------------------
      CTimer::STATE CTimer::Update( void )
      {
        if( m_StateEndFlag )
          return m_State;

        switch( m_State )
        {
        case STATE_UPDATE:
          {

            // JEg炷
            if( m_FremeCntDown == 0)
            {
              m_StateEndFlag = true;
              m_State = STATE_END;
            }
            else
              m_FremeCntDown--;

            SetFrontEnd();
            break;
          }
        }

        return m_State;
      }


      //------------------------------------------------------------------
      /**
       * @name      Message
       * @brief     ÕbZ[W
       * @param     message     bZ[Wʎq
       * @return    true : K؂ɏꂽ
       */
      //------------------------------------------------------------------
      b32 CTimer::Message(MESSAGE message)
      {
        switch( message )
        {
          // Zbg
        case MESSAGE_SETUP_TITLE_ENTER:

          m_State = STATE_UPDATE;
          m_StateEndFlag = false;

          SetUpFrameCntDown();
          SetFrontEnd();

          return true;
        }

        return false;
      }


      //  protected:

      //------------------------------------------------------------------
      /**
       * @name      SetUpFrameCntDown
       * @brief     ݒ肩ct[lZbgAbv
       */
      //------------------------------------------------------------------
      void CTimer::SetUpFrameCntDown( void )
      {
        m_FremeCntDown = (m_pSetUp->minute * 60 + m_pSetUp->second) * m_pSetUp->frameRate;
      }

      //------------------------------------------------------------------
      /**
       * @name      SetFrontEnd
       * @brief     CPlayFrontEnd()Ɏc莞Ԃm点
       */
      //------------------------------------------------------------------
      void CTimer::SetFrontEnd( void )
      {
        u32 second(m_FremeCntDown / m_pSetUp->frameRate);

        m_pRentalPtrSet->pPlayFrontEnd->SetTime(
            second / 60,  // 
            second % 60   // b
            );
      }

    } // namespace game
  } // namespace ikuta
} // namespace test

#endif // PM_DEBUG

// EOF
