
#if PM_DEBUG

///////////////////////////////////////////////////////////////////////////////////////
/**
 * @file   test_ikuta_game_CPlayFrontEnd.h
 * @brief  [VlC~jQ[]Q[tgGh
            XRAƐԂ\AlCTimerCLostChildManagerZbgB
 * @author junya ikuta
 * @date  2012/05/25() 09:34 
 */
///////////////////////////////////////////////////////////////////////////////////////
#pragma once

// sys
#include <grp/g2d/gfl_LytSys.h>

// appSys

// app
#include "../test_ikuta_game_CResourceObjectBase.h"        


namespace test {
  namespace ikuta {
    namespace game {

      class CPlayFrontEnd : public CResourceObjectBase
      {
        GFL_FORBID_COPY_AND_ASSIGN( CPlayFrontEnd );                // ֎~

        typedef CResourceObjectBase base;

        public:

        enum STATE {
          STATE_NULL = 0,          // 
          STATE_LOAD,              //
          STATE_WAIT,              // ҋ@H
          STATE_FRAME_IN,          // \Aj[V
          STATE_UPDATE,            // ʏXV
          STATE_FRAME_OUT,         // \Aj[V
          
          STATE_MAX
        };

        enum MESSAGE {
          MESSAGE_SETUP_TITLE_ENTER = 0,    // ^CgŌ{^ꂽԂɂ
   
          MESSAGE_MAX
        };


        // e̎؂蕨
        struct RENTAL_PTR_SET{

          gfl::grp::g2d::LytSys*        pLayOutSystem;        // 郌CAEgVXe
          app::util::Heap*              pHeap;                // gpq[v  
          gfl::fs::FileReadManager*     pFileReadManager;     // 񓯊t@Cǂݍ
          
          RENTAL_PTR_SET() :
            pLayOutSystem( NULL ),
            pHeap( NULL ),
            pFileReadManager( NULL )
          {
          }
        };

        // p\
        struct SETUP_PARAM{
          u32                           arcId;                // gpA[Nt@CID

          SETUP_PARAM() : 
            arcId( 0 )
          {
          }
        };

        //------------------------------------------------------------------
        /**
         * @name     CPlayFrontEnd[RXgN^]
         * @brief    ϐ̏s
         */
        //------------------------------------------------------------------
        CPlayFrontEnd( void );

        //------------------------------------------------------------------
        /**
         * @name     ~CPlayFrontEnd[fXgN^]
         * @brief    FinalizeĂяo
         */
        //------------------------------------------------------------------
        virtual ~CPlayFrontEnd();

        //------------------------------------------------------------------
        /**
         * @name      Initialize
         * @brief     A[hI܂ŊĂ܂B 
         * @pram      rRentalPtr  ؂蕨̃|C^Zbg[const]
         * @pram      rSetUp      [const]
         * @return    true : 
         */
        //------------------------------------------------------------------
        bool Initialize( const RENTAL_PTR_SET& rRentalPtr, const SETUP_PARAM& rSetUp);

        //------------------------------------------------------------------
        /**
         * @name     Reset
         * @brief    p[^AInitializeɐ퓮AInitializȅԂɂȂ
         */
        //------------------------------------------------------------------
        void Reset( void );

        //------------------------------------------------------------------
        /**
         * @name     Finalize
         * @brief    I
         */
        //------------------------------------------------------------------
        void Finalize( void );

        //------------------------------------------------------------------
        /**
         * @name      Update
         * @brief     XVA[hLoadUpdate𐄏
         * @return    ݂̏
         */
        //------------------------------------------------------------------
        STATE Update( void );

        //------------------------------------------------------------------
        /**
         * @name     LoadUpdate[virtual]
         * @brief    [hǂݐi߂鏃z֐A[hIŕKSetUpLoadAndSetupEnd()ĂԁB
         * @return   true : [hs
         */
        //------------------------------------------------------------------
        bool LoadUpdate(void);   

       //------------------------------------------------------------------
        /**
         * @name      Draw
         * @brief     `揈AȂ
         */
        //------------------------------------------------------------------
        void Draw( void );

        //------------------------------------------------------------------
        /**
         * @name      AddScene
         * @brief     V[(CAEgVXe)Ɏgǉ
         */
        //------------------------------------------------------------------
        void AddScene(void);      
      
        //------------------------------------------------------------------
        /**
         * @name      RemoveScene
         * @brief     V[(CAEgVXe)玩g菜
         */
        //------------------------------------------------------------------
        void RemoveScene(void);      

        //------------------------------------------------------------------
        /**
         * @name      Message
         * @brief     ÕbZ[W
         * @param     message     bZ[Wʎq
         * @return    true : K؂ɏꂽ
         */
        //------------------------------------------------------------------
        b32 Message(MESSAGE message);     

        b32 IsStateEnd( void ) const
        {
          return m_StateEndFlag;
        } 

        //------------------------------------------------------------------
        /**
         * @name      SetTime
         * @brief     c莞Ԃ̐Zbg
         * @param     minute : (0`9)
         * @param     second : b(0`59)
         */
        //------------------------------------------------------------------
        void SetTime( u32 minute, u32 second );

        //------------------------------------------------------------------
        /**
         * @name      SetScore
         * @brief     ݂̃XRAZbg
         * @param     score : XRA(0`99)
         */
        //------------------------------------------------------------------
        void SetScore( u32 score );

        protected:

        //------------------------------------------------------------------
        /**
         * @name      ChangeAnimation
         * @brief     Aj[V̕ύX
         * @param     index       Aj[Vԍ
         */
        //------------------------------------------------------------------
        void ChangeAnimation( u32 index);

        //------------------------------------------------------------------
        /**
         * @name      SetNumberPane
         * @brief     w̃}eAy[Ɏw̐Zbg
         * @param     index       }eAy[index
         * @param     num         (0`9)
         */
        //------------------------------------------------------------------
        void SetNumberPaneMaterial( gfl::grp::g2d::LytPaneIndex index, u32 num );



        // ʏϐ
        STATE                           m_State;              // ԕϐ
        b32                             m_StateEndFlag;       // true L̏Ԃłׂ͏IĂ

        // VXe
        RENTAL_PTR_SET*                 m_pRentalPtrSet;      // w̎؂蕨̕ۊ


        // \[X֘A
        gfl::grp::g2d::LytResID         m_ResID;              // CAEgVXeID
        gfl::grp::g2d::LytWk*           m_pLayOutWorkUpper;   // CAEg1

        void*                           m_pBuf;               // 񓯊ǂݍݗpobt@|C^ 
      };

    } // namespace game
  } // namespace ikuta
} // namespace test

#endif // PM_DEBUG


// EOF
