

#if PM_DEBUG

///////////////////////////////////////////////////////////////////////////////////////
/**
 * @file   test_ikuta_game_CPlayFrontEnd.cpp
 * @brief  [VlC~jQ[]Q[tgGh
 XRAƐ
 * @author junya ikuta
 * @date  2012/05/25() 09:34 
 */
///////////////////////////////////////////////////////////////////////////////////////
#pragma once

// appSys

// app
#include "test_ikuta_game_CPlayFrontEnd.h"        
#include "../resource/test_ikuta_game_resource_LayOut.h"

// res
#include "../resource/frontend_play_upper_pane.h"

namespace test {
  namespace ikuta {
    namespace game {


      //------------------------------------------------------------------
      /**
       * @name     CPlayFrontEnd[RXgN^]
       * @brief    ϐ̏s
       */
      //------------------------------------------------------------------
      CPlayFrontEnd::CPlayFrontEnd( void ) :
        m_State( STATE_NULL ),
        m_StateEndFlag( false ),
        m_pRentalPtrSet( NULL ),
        m_ResID( gfl::grp::g2d::LYTSYS_RESID_ERROR ),
        m_pLayOutWorkUpper( 0 ),
        m_pBuf( 0 )
      {

      }

      //------------------------------------------------------------------
      /**
       * @name     ~CPlayFrontEnd[fXgN^]
       * @brief    FinalizeĂяo
       */
      //------------------------------------------------------------------
      CPlayFrontEnd::~CPlayFrontEnd()
      {
        Finalize();
      }

      //------------------------------------------------------------------
      /**
       * @name      Initialize
       * @brief     A[hI܂ŊĂ܂B 
       * @pram      rRentalPtr  ؂蕨̃|C^Zbg[const]
       * @pram      rSetUp      [const]
       * @return    true : 
       */
      //------------------------------------------------------------------
      bool CPlayFrontEnd::Initialize( const RENTAL_PTR_SET& rRentalPtr, const SETUP_PARAM& rSetUp)
      {
        // `FbN
        //   GFL_ASSERT
        //  rRentalPtr.

        // ܂؂蕨[
        m_pRentalPtrSet = GFL_NEW( rRentalPtr.pHeap->pHeap )RENTAL_PTR_SET;
        *m_pRentalPtrSet = rRentalPtr;


        // 񓯊\[X̓ǂݍ
        m_pRentalPtrSet->pFileReadManager->AddReadRequest(
            &m_pBuf,
            NULL,
            m_pRentalPtrSet->pHeap->pDevHeap,
            128,
            rSetUp.arcId,
            LAYOUT_ARCID_FRONTEND_PLAY_UPPER,
            true
            );

        // [hԂɈڍs
        base::LoadStart();
        m_State = STATE_LOAD;
        m_StateEndFlag = false;
        return true;
      }

      //------------------------------------------------------------------
      /**
       * @name     Reset
       * @brief    p[^AInitializeɐ퓮AInitializȅԂɂȂ
       */
      //------------------------------------------------------------------
      void CPlayFrontEnd::Reset( void )
      {
      }

      //------------------------------------------------------------------
      /**
       * @name     Finalize
       * @brief    I
       */
      //------------------------------------------------------------------
      void CPlayFrontEnd::Finalize( void )
      {

      }

      //------------------------------------------------------------------
      /**
       * @name      Update
       * @brief     XVA[hLoadUpdate𐄏
       * @return    ݂̏
       */
      //------------------------------------------------------------------
      CPlayFrontEnd::STATE CPlayFrontEnd::Update( void )
      {

        if( m_StateEndFlag )
          return m_State;

        switch( m_State )
        {
        case STATE_LOAD:
          LoadUpdate();
          break;

        case STATE_FRAME_IN:
          {

            break;
          }
        }

        return m_State;
      }

      //------------------------------------------------------------------
      /**
       * @name     LoadUpdate[virtual]
       * @brief    [hǂݐi߂鏃z֐A[hIŕKSetUpLoadAndSetupEnd()ĂԁB
       * @return   true : [hs
       */
      //------------------------------------------------------------------
      bool CPlayFrontEnd::LoadUpdate(void)
      {
        if(m_State != STATE_LOAD)
          return false;

        bool endFlag(true);

        // f̓ǂݍ
        if( !m_pLayOutWorkUpper )
        {
          // ǂݍ݂҂
          if( m_pRentalPtrSet->pFileReadManager->IsReadFinished(&m_pBuf) )
          {
            // \[Xǂݍ
            m_ResID = m_pRentalPtrSet->pLayOutSystem->LoadLytRes(
                m_pRentalPtrSet->pHeap->pDevHeapAllocator, 
                m_pBuf
                );
            //         GFL_SAFE_DELETE_ARRAY( m_pBuf );

            // VRAMɃeNX`]
            m_pRentalPtrSet->pLayOutSystem->TransferAllTexture( m_ResID, gfl::grp::MEMORY_AREA_FCRAM );

            // CAEg[N𐶐
            m_pLayOutWorkUpper = m_pRentalPtrSet->pLayOutSystem->CreateLytWk( 
                m_ResID, 
                FRONTEND_PLAY_UPPER_DATID_CLYT, 
                &A_FRONTEND_PLAY_UPPER_ANIMATION_ID_INDEX[0], 
                FRONTEND_PLAY_UPPER_ANIMATION_MAX, 
                FRONTEND_PLAY_UPPER_ANIMATION_MAX, 
                &LAYOUT_WORK_SETUP, 
                false            
                );

            m_pLayOutWorkUpper->SetAutoDrawFlag( false ); 
          }
          else
          {
            endFlag = false;
          }
        }

        if( endFlag )
        {
          m_State = STATE_UPDATE;
          base::LoadAndSetupEnd();

          return false;
        }

        return true;
      }

      //------------------------------------------------------------------
      /**
       * @name      Draw
       * @brief     `揈AȂ
       */
      //------------------------------------------------------------------
      void CPlayFrontEnd::Draw( void )
      {

      }

      //------------------------------------------------------------------
      /**
       * @name      AddScene
       * @brief     V[(CAEgVXe)Ɏgǉ
       */
      //------------------------------------------------------------------
      void CPlayFrontEnd::AddScene(void)
      {
        m_pLayOutWorkUpper->SetAutoDrawFlag( true ); 
      }

      //------------------------------------------------------------------
      /**
       * @name      RemoveScene
       * @brief     V[(CAEgVXe)玩g菜
       */
      //------------------------------------------------------------------
      void CPlayFrontEnd::RemoveScene(void)
      {
        m_pLayOutWorkUpper->SetAutoDrawFlag( false ); 
      }

      //------------------------------------------------------------------
      /**
       * @name      Message
       * @brief     ÕbZ[W
       * @param     message     bZ[Wʎq
       * @return    true : K؂ɏꂽ
       */
      //------------------------------------------------------------------
      b32 CPlayFrontEnd::Message(MESSAGE message)
      {
        switch( message )
        {
        case MESSAGE_SETUP_TITLE_ENTER :  // ^CgŌ{^ꂽԂɃZbgAbv
          {
            ChangeAnimation( FRONTEND_PLAY_UPPER_ANIMATION_FRAME_IN );
            m_State = STATE_FRAME_IN;
            m_StateEndFlag = false;
            return true;
          }
        }
        return false;
      }


      //------------------------------------------------------------------
      /**
       * @name      SetTime
       * @brief     c莞Ԃ̐Zbg
       * @param     minute : 
       * @param     second : b
       */
      //------------------------------------------------------------------
      void CPlayFrontEnd::SetTime( u32 minute, u32 second )
      {
        SetNumberPaneMaterial(PANENAME_FRONTEND_PLAY_UPPER_MATERIAL_TIME_MINUTE, minute);

        SetNumberPaneMaterial(PANENAME_FRONTEND_PLAY_UPPER_MATERIAL_TIME_SECOND2, second / 10);
        SetNumberPaneMaterial(PANENAME_FRONTEND_PLAY_UPPER_MATERIAL_TIME_SECOND1, second % 10);
      }

      //------------------------------------------------------------------
      /**
       * @name      SetScore
       * @brief     ݂̃XRAZbg
       * @param     score : XRA(0`99)
       */
      //------------------------------------------------------------------
      void CPlayFrontEnd::SetScore( u32 score )
      {
        SetNumberPaneMaterial( PANENAME_FRONTEND_PLAY_UPPER_MATERIAL_SCORE2, score / 10 );
        SetNumberPaneMaterial( PANENAME_FRONTEND_PLAY_UPPER_MATERIAL_SCORE1, score % 10 );
      }


      // protected

      //------------------------------------------------------------------
      /**
       * @name      ChangeAnimation
       * @brief     Aj[V̕ύX
       * @param     index       Aj[Vԍ
       */
      //------------------------------------------------------------------
      void CPlayFrontEnd::ChangeAnimation( u32 index)
      {
        if(!m_pLayOutWorkUpper->IsBindAnime(index))
          m_pLayOutWorkUpper->BindAnime( index );

        m_pLayOutWorkUpper->SetAnimeFrame( index, 0);
        m_pLayOutWorkUpper->SetAutoAnime( index , true );
      }


      //------------------------------------------------------------------
      /**
       * @name      SetNumberPane
       * @brief     w̃}eAy[Ɏw̐Zbg
       * @param     index       }eAy[index
       * @param     num         (0`9)
       */
      //------------------------------------------------------------------
      void CPlayFrontEnd::SetNumberPaneMaterial( gfl::grp::g2d::LytPaneIndex index, u32 num )
      {
        gfl::grp::g2d::LytMaterial* pPaneMat = m_pLayOutWorkUpper->GetMaterial( index );
        nw::lyt::TexSRT texSrt(pPaneMat->GetTexSRT(0));

        texSrt.translate.x = (num % 5) * 0.2f;
        texSrt.translate.y = (num / 5) * 0.5f;

        pPaneMat->SetTexSRT(0, texSrt);
      }



    } // namespace game
  } // namespace ikuta
} // namespace test

#endif // PM_DEBUG


// EOF
