//============================================================================================
/**
 * @file    Main.h
 * @brief   v[VrfIĐdg
 * @author  ito_isao
 * @date    12.05.25
 */
//============================================================================================
#ifndef __APP_PROMOTION_PLAYER_H__
#define __APP_PROMOTION_PLAYER_H__

#include <gflib.h>
#include "system/sequence/Command.h"
#include "Record.h"

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(promotion)

class Main;

class Player
{
public:
  // con, des
  Player( Main* m_owner, app::util::Heap* heap );
  ~Player();
  
  // vC[̃ZbgAbvs܂
  // ̌AKvȃt@C̃[h𒆂ōŝŁA
  // [hǂgpOɊmFĂ
  void LoadRecords(Record* array, int num);
  
  //! L[hǂԂ
  bool IsReady();
  
  // ĐǂԂ܂/falseԂہAĐIEĐĂȂԂ̋ʂ͍s܂
  bool IsPlaying();
  
  //! V[PXt@C̍Đs܂
  //! @note KL[hɎsĉ
  void Play();
  
  // XVEt[Ăł
  void Update();
  
  // ǂݍ񂾃V[PXt@C̕ЂÂs܂
  // force_unloadtrueɂƁA
  // IsPlayingtrueԂԂŌĂяoĂASSERTŎ~܂ȂȂ܂B
  void UnLoad(bool force_unload = false);
  
  
private:
  void CreateModelCommand(const Model& model, int sec);
  void CreateBackGroundCommand(const BackGround& id, int sec);
  void CreateBGMCommand(int id, int sec);
  void CreateSECommand(int id, int sec);
  void CreateCameraCommand(int id, int sec);
  void CreateParticleCommand(int id, int sec);
  void CreateEffectCommand(int id, int sec);
  void CreateTelopCommand(const Telop& id, int sec);
  
private:
  Main* m_owner;
  app::util::Heap* m_heap;
  xy_system::sequence::CommandList m_list;
  int m_frame;
  bool m_playing;
};

GFL_NAMESPACE_END(promotion)
GFL_NAMESPACE_END(app)

#endif //__APP_PROMOTION_PLAYER_H__
