
#include "Player.h"
#include "Command.h"


GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(promotion)

static const int FPS = 30;

//------------------------------------------------------------------------------
// con, des
//------------------------------------------------------------------------------
Player::Player( Main* owner, app::util::Heap* heap ) : m_owner(owner), m_heap(heap)
{
}

Player::~Player()
{
}

//------------------------------------------------------------------------------
// Loadn
//------------------------------------------------------------------------------
bool Player::IsReady()
{
  // @todo 񓯊ǂݍ݂ɑΉȂACKv
  return true;
}

void Player::Play()
{
  m_playing = true;
  m_frame = 0;
}

bool Player::IsPlaying()
{
  return m_playing;
}

//------------------------------------------------------------------------------
void Player::UnLoad(bool force_unload)
{
  if(!force_unload)
  {
    GFL_ASSERT(m_playing != true);
  }
  m_playing = false;
  
  for(xy_system::sequence::CommandList::Iterator it = m_list.begin(); it != m_list.end(); ++it)
  {
    it->Finalize();
    GFL_DELETE(&*it);
  }
  m_list.clear();
}
//------------------------------------------------------------------------------
// Update
//------------------------------------------------------------------------------
void Player::Update()
{
  if(!m_playing){return;}
  
  int finished = 0;
  for(xy_system::sequence::CommandList::Iterator it = m_list.begin(); it != m_list.end(); ++it)
  {
    int start = it->GetStartFrame();
    int end = it->GetEndFrame();
    if(start > m_frame){break;}
    if(end < m_frame){++finished; continue;}
    if(start == m_frame){it->Enter();}
    it->Exec();
    if(end == m_frame){it->Exit();}
  }
  ++m_frame;
  
  GFL_PRINT("%d\n", m_frame);
  
  if(finished == m_list.size()){m_playing = false;}
}

//------------------------------------------------------------------------------
// Command
//------------------------------------------------------------------------------
void Player::LoadRecords(Record* array, int num)
{
  for(int i = 0; i < num; ++i)
  {
    Record r = array[i];
    {
      this->CreateModelCommand(r.model, i);
    }
    this->CreateBackGroundCommand(r.background, i);
    this->CreateBGMCommand(r.bgm, i);
    this->CreateSECommand(r.se, i);
    this->CreateCameraCommand(r.camera, i);
    this->CreateParticleCommand(r.particle, i);
    this->CreateEffectCommand(r.effect, i);
    for(int j = 0; j < 2; ++j)
    {
      this->CreateTelopCommand(r.telop[j], i);
    }
  }
}

//------------------------------------------------------------------------------
// f
//------------------------------------------------------------------------------
void Player::CreateModelCommand(const Model& model, int sec)
{
  if(model.motion != -1)
  {
    xy_system::sequence::ICommand* com = GFL_NEW(m_heap->pHeap) ChangeTrainerMotionCommand(m_owner, model.motion);
    com->SetStartFrame(sec*FPS);
    com->SetEndFrame(sec*FPS);
    m_list.push_back(com);
  }
  if(model.rotation != -1)
  {
    xy_system::sequence::ICommand* com = GFL_NEW(m_heap->pHeap) ChangeTrainerRotationCommand(m_owner, model.rotation);
    com->SetStartFrame(sec*FPS);
    com->SetEndFrame(sec*FPS);
    m_list.push_back(com);
  }
}
//------------------------------------------------------------------------------
// wi
//------------------------------------------------------------------------------
void Player::CreateBackGroundCommand(const BackGround& background, int sec)
{
  if(background.bg == 0)
  {
  }
  else if(background.bg != -1)
  {
    xy_system::sequence::ICommand* com = GFL_NEW(m_heap->pHeap) ChangeBGCommand(m_owner, background.bg);
    com->SetStartFrame(sec*FPS);
    com->SetEndFrame(sec*FPS);
    m_list.push_back(com);
  }
  if(background.blightness != -1)
  {
    xy_system::sequence::ICommand* com = GFL_NEW(m_heap->pHeap) ChangeBGBlightnessCommand(m_owner, background.blightness);
    com->SetStartFrame(sec*FPS);
    com->SetEndFrame(sec*FPS);
    m_list.push_back(com);
  }
}
//------------------------------------------------------------------------------
// BGM
//------------------------------------------------------------------------------
void Player::CreateBGMCommand(int id, int sec)
{
  if(id != -1)
  {
    xy_system::sequence::ICommand* com = GFL_NEW(m_heap->pHeap) PlayBGMCommand(m_owner, id);
    com->SetStartFrame(sec*FPS);
    com->SetEndFrame(sec*FPS);
    m_list.push_back(com);
  }
}
//------------------------------------------------------------------------------
// SE
//------------------------------------------------------------------------------
void Player::CreateSECommand(int id, int sec)
{
  if(id != -1)
  {
    xy_system::sequence::ICommand* com = GFL_NEW(m_heap->pHeap) PlaySECommand(m_owner, id);
    com->SetStartFrame(sec*FPS);
    com->SetEndFrame(sec*FPS);
    m_list.push_back(com);
  }
}
//------------------------------------------------------------------------------
// J
//------------------------------------------------------------------------------
void Player::CreateCameraCommand(int id, int sec)
{
  if(id != -1)
  {
    xy_system::sequence::ICommand* com = GFL_NEW(m_heap->pHeap) ChangeCameraCommand(m_owner, id);
    com->SetStartFrame(sec*FPS);
    com->SetEndFrame(sec*FPS);
    m_list.push_back(com);
  }
}
//------------------------------------------------------------------------------
// p[eBN
//------------------------------------------------------------------------------
void Player::CreateParticleCommand(int id, int sec)
{
  switch(id)
  {
  default:
    return;
  }
}
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
void Player::CreateEffectCommand(int id, int sec)
{
  switch(id)
  {
  default:
    return;
  }
}
//------------------------------------------------------------------------------
// ebv
//------------------------------------------------------------------------------
void Player::CreateTelopCommand(const Telop& telop, int sec)
{
  // ebv̍폜
  if(telop.text == 0)
  {
    xy_system::sequence::ICommand* com = GFL_NEW(m_heap->pHeap) HideTelopCommand(m_owner, 0);
    com->SetStartFrame(sec*FPS);
    com->SetEndFrame(sec*FPS);
    m_list.push_back(com);
  }
  // ebv̍Đ
  else if(telop.text != -1)
  {
    xy_system::sequence::ICommand* com = GFL_NEW(m_heap->pHeap) ChangeTelopCommand(m_owner, 0, telop);
    com->SetStartFrame(sec*FPS);
    com->SetEndFrame(sec*FPS);
    m_list.push_back(com);
  }
}
GFL_NAMESPACE_END(promotion)
GFL_NAMESPACE_END(app)

