//============================================================================================
/**
 * @file    Main.h
 * @brief   v[VrfĨCƂȂScene
 * @author  ito_isao
 * @date    12.05.25
 */
//============================================================================================

#ifndef __APP_PROMOTION_MAIN_H__
#define __APP_PROMOTION_MAIN_H__

#include <gflib.h>

#include "Record.h"
#include "IScene.h"

#include "app/util/app_util_heap.h"
#include "app/util/app_util_3d.h"
#include "app/util/app_util_2d.h"

#include "trainer/TrModelManager.h"


GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(promotion)

enum
{
  SCENE_BG,
};

//------------------------------------------------------------------------------
// eƂȂNX
//------------------------------------------------------------------------------
class Main : public IScene<Main>
{
public:
  static const int FADE_TIME;
  static const int ROTATE_SPEED;
  
public:
  Main();
  ~Main();
  
  virtual void Enter();
  virtual bool Update();
  virtual void Exit();
  
  void Draw();
  
  template<class T>
  void SetNext()
  {
    m_next = GFL_NEW(m_heap.pHeap) T();
    m_next->SetOwner(this);
  }
  
  bool IsFinished(){return m_finish;}
  void SetFinished(){m_finish = true;}
  
  //------------------------------------------------------------------
  // 擾n
  //------------------------------------------------------------------
  gfl::ui::Button* GetButton(){return m_button;}
  app::util::Heap* GetHeap(){return &m_heap;}
  
  
  //------------------------------------------------------------------
  // eV[Ă΂ł낤̂
  //------------------------------------------------------------------
  
  // g[i[fn
  // 쐬
  void CreateTrainerModel();
  bool IsTrainerModelCreated();
  // j
  void DestroyTrainerModel();
  // [V̕ύX
  void ChangeTrainerMotion(int motion);
  void ChangeTrainerRotation(int rotate_mode);
  
  
  // bZ[Wn
  void ChangeTelop(int index, const Telop& telop);
  void HideTelop(int index);
  
  // wi
  void ChangeBG(int index);
  void ChangeBGBlightness(int index);
  
  // Jn
  void ChangeCamera(int index);
  
private:
  void Create3D();
  void Destroy3D();
  
  void Create2D();
  void Destroy2D();
  
  void CreateBG();
  
  gfl::grp::g3d::StereoCamera* CreateCamera(int index);
  
  void UpdateTrainerModelManager();
  
  
private:
  IScene<Main>* m_current;
  IScene<Main>* m_next;
  bool m_finish;
  
  // q[v
  app::util::Heap m_heap;
  
  // UIn
  gfl::ui::DeviceManager* m_device_manager;
  gfl::ui::Button* m_button;
  
  // CAEgn
  app::util::G2DUtil* m_layout;
  
  // OtBbNn
  gfl::grp::GraphicsSystem* m_graphics;
  app::util::G3DUtil* m_3d;
  
  // g[i[fn
  trainer::TrModelManager* m_model_manager;
  trainer::TrModel* m_trainer;
  bool m_trainer_created;
  int m_rotate_trainer;
  
  // Jn
  gfl::grp::g3d::Resource* m_res;
  
  // BGn
  // Cg
  gfl::grp::g3d::Light* m_light;
  gfl::grp::g3d::LightSet* m_lightset;
  
  // J
  gfl::grp::g3d::StereoCamera* m_bg_camera;
  // wi\[X
  gfl::grp::g3d::Resource* m_bg_res;
  gfl::grp::g3d::Resource* m_bg_tex_res;
  // f
  gfl::grp::g3d::Model* m_bg_model;
  
};

GFL_NAMESPACE_END(promotion)
GFL_NAMESPACE_END(app)

#endif //__APP_PROMOTION_MAIN_H__
