
#include "Main.h"
#include "Scene.h"
#include "Command.h"
//#include "system/heap_define.h"

#include "trainer/TrModelManager.h"
#include "arc/arc_def.h"
#include "arc/promotion.gaix"
#include "arc/kisekae_data.gaix"
#include "arc/message.gaix"
#include "message/msg_promo_video.h"
#include "lyt/layout.h"
#include "lyt/layout_pane.h"

#include "gamesystem/GameManager.h"
#include "gamesystem/GameData.h"

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(promotion)

//------------------------------------------------------------------------------
// 萔`
//------------------------------------------------------------------------------
#define PROMOTION_APP_HEAP_SIZE (0x100000)
#define PROMOTION_DEV_HEAP_SIZE (0x1500000)
const int Main::FADE_TIME = 5;
const int Main::ROTATE_SPEED = 12;

//------------------------------------------------------------------------------
// eƂȂV[
//------------------------------------------------------------------------------
Main::Main() : 
m_current(NULL),
m_next(NULL),
m_finish(false)
{
  m_owner = this;
  
  
  // q[v̍쐬
  m_heap.Create(HEAPID_PROMOTION_APP, PROMOTION_APP_HEAP_SIZE,
                HEAPID_PROMOTION_DEV, PROMOTION_DEV_HEAP_SIZE);
  
  // UIfoCX̎擾
  gamesystem::GameManager* game_manager = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
  m_device_manager = game_manager->GetUiDeviceManager();
  m_button = m_device_manager->GetButton(gfl::ui::CTR_DeviceManager::BUTTON_STANDARD);
  
  // OtBbN
  m_graphics = game_manager->GetGraphicsSystem();
  m_graphics->InitializeApplicationMemory(m_heap.pDevHeapAllocator);
  this->Create3D();
  this->CreateBG();
  m_3d->SetupG3dScene();
  
  // CAEg
  this->Create2D();
  
}

Main::~Main()
{
  this->Exit();
  
  // CAEg̍폜
  this->Destroy2D();
  
  // g[i[f̍폜
  this->DestroyTrainerModel();
  
  this->Destroy3D();
  m_graphics->FinalizeApplicationMemory();
}
//------------------------------------------------------------------------------
void Main::Enter()
{
  GFL_PRINT("enter:main\n");
  // ̃V[𐶐
  this->SetNext<InitScene>();
}

void Main::Exit()
{
  GFL_PRINT("exit:main\n");
  if(m_current != NULL)
  {
    m_current->Exit();
    GFL_DELETE(m_current);
    m_current = NULL;
  }
}
//------------------------------------------------------------------------------
bool Main::Update()
{
  if(m_next != NULL)
  {
    if(m_current != NULL)
    {
      m_current->Exit();
      GFL_DELETE(m_current);
    }
    m_current = m_next;
    m_current->Enter();
    m_next = NULL;
    return true;
  }
  
  if(m_current)
  {
    m_current->Update();
  }
  
  this->UpdateTrainerModelManager();
  
  if(this->IsFinished())
  {
    return false;
  }
  
  return true;
}
//------------------------------------------------------------------------------
// CAEg̏
//------------------------------------------------------------------------------
void Main::Create2D()
{
  m_layout = GFL_NEW(m_heap.pHeap) app::util::G2DUtil( &m_heap );
  static const app::util::G2DUtil::LYT_RES_DATA res[] = {
    {ARCID_PROMOTION, 0, 0},
  };
  static const app::util::G2DUtil::LYTWK_DATA data[] = {
    {
      0,      // ݒ肵\[X̃CfbNX
      LYTRES_LAYOUT_P_VIDEO_UPPER_BCLYT,
      NULL,   // ł̓Aj͖
      0,      // Aj[Vf[^IDe[u
      0,      // o^Aj[Vő吔
      false,
      app::util::G2DUtil::SETUP_UPPER,
      true,   // \ݒ
    }
  };
  m_layout->CreateLayoutSystem(&m_heap);
  m_layout->SetDefaultFont("cbf_std.bcfnt");
  m_layout->CreateLayoutEnv( &m_heap );
  m_layout->CreateLayoutWork( res, GFL_NELEMS(res), GFL_NELEMS(data), &m_heap, false);
  m_layout->SetLayoutWork( data, 0, GFL_NELEMS(data) );
  m_layout->SetLayoutDrawEnable(0, true);
  
  m_layout->CreateMessageData(GARC_message_promo_video_DAT, gfl::str::MsgData::LOAD_FULL, &m_heap);
}

void Main::Destroy2D()
{
  m_layout->DeleteMessageData();
  m_layout->DeleteLayoutWork();
  m_layout->DeleteLayoutEnv();
  m_layout->DeleteLayoutSystem();
  GFL_DELETE m_layout;
}
//------------------------------------------------------------------------------
// 3D̏
//------------------------------------------------------------------------------
void Main::Create3D()
{
  // G3DUtil̏
  m_3d = GFL_NEW(m_heap.pHeap) app::util::G3DUtil;
  m_3d->CreateG3dSystem(&m_heap);
  app::util::G3DUtil::SCENE_CREATE_DATA data;
  data.user_calc_group_num = 1;
  data.user_draw_group_num = 1;
  //m_3d->CreateG3dScene(app::util::G3DUtil::ENVIRONMENT_RES_NONE, 0, &m_heap, false, &data);
  m_3d->CreateG3dScene( ARCID_KISEKAE_DATA, GARC_kisekae_data_env_BCENV, &m_heap, false, &data );
  //m_3d->CreateG3dLight( ARCID_KISEKAE_DATA, GARC_kisekae_data_env_BCENV, &m_heap );
  m_3d->CreateEdgeSystem(
    GFL_SINGLETON_INSTANCE(gamesystem::GameManager)->GetGraphicsSystem(),
    app::util::G3DUtil::EDGE_SET_FLAG_UPPER,
    &m_heap
  );
  // J̍쐬
  gfl::grp::g3d::StereoCamera* camera = this->CreateCamera(GARC_promotion_cam_ba55_videopose02_BCCAM);
  m_3d->GetScene()->AddSceneNode(camera);
  m_3d->SetCamera(app::util::G3DUtil::SETUP_CAMERA_UPPER, camera);
  
  app::util::G3DUtilCreateTrModelEnv(m_3d, &m_heap);
  
  // ւf
  xy_system::dress_up::DressUpManagerCreate(
    m_heap.pHeap,
    m_heap.pHeap,
    m_heap.pDevHeap
  );
  
  // g[i[f}l[W̍쐬
  m_model_manager = GFL_NEW(m_heap.pHeap) trainer::TrModelManager(
    m_heap.pHeap,
    GFL_SINGLETON_INSTANCE(gamesystem::GameManager)->GetFileReadManager()
  );
}
//------------------------------------------------------------------------------
void Main::Destroy3D()
{
  GFL_ASSERT_MSG(m_model_manager->IsAbleToDestroy(), "g[i[f}l[W폜ł܂B\n");
  GFL_DELETE m_model_manager;
  m_model_manager = NULL;

  // ւf
  xy_system::dress_up::DressUpManagerDestroy();

  // G3DUtil
  app::util::G3DUtilDeleteTrModelEnv(m_3d);
  m_3d->GetScene()->RemoveSceneNode(m_bg_camera);
  m_3d->GetScene()->RemoveSceneNode(m_bg_model);
  GFL_DELETE m_bg_model;
  GFL_DELETE m_bg_res;
  GFL_DELETE m_bg_tex_res;
  GFL_DELETE m_bg_camera;
  m_3d->DeleteG3dCamera();
  m_3d->DeleteEdgeSystem();
  m_3d->DeleteG3dScene();
  if(m_res != NULL){m_res->Unload();GFL_DELETE(m_res);}
  m_3d->DeleteG3dSystem();
  GFL_DELETE m_3d;
  m_3d = NULL;
  
}

//------------------------------------------------------------------------------
// 3Ďɕ`悷Awȉ
//------------------------------------------------------------------------------
void Main::CreateBG()
{ // ˉeJ쐬
  gfl::grp::g3d::Camera::Description desc;
  gfl::grp::g3d::Camera::InitializeDescriptionForLookAtOrtho(
    &desc,
    gfl::math::VEC3(0,400,0),
    gfl::math::VEC3(0,0,0),
    gfl::math::VEC3(0,0,-1),
    1,
    400.0/240.0,
    240,
    gfl::math::VEC2(0,0),
    -1,
    100000,
    gfl::math::PIVOT_NONE
  );
  m_bg_camera = GFL_NEW(m_heap.pDevHeap) gfl::grp::g3d::StereoCamera();
  m_bg_camera->Create(m_heap.pDevHeapAllocator, &desc);
  m_3d->GetScene()->AddSceneNode(m_bg_camera);
  
  
  // wipf̍쐬
  
  // GJEgGtFNg̃A[JCut@Cǂݍ
  gfl::fs::ArcFile* af = GFL_NEW(m_heap.pHeap) gfl::fs::ArcFile(m_heap.pHeap, ARCID_PROMOTION, gfl::fs::ArcFile::OPEN);
  // ŃfāAwipV[O[vɓo^
  
  // BGpf̃\[X쐬
  u32 common_resource_flag = gfl::grp::g3d::Resource::COMMON_RESOURCE_NONE;
  common_resource_flag |= gfl::grp::g3d::Resource::COMMON_RESOURCE_DEFAULT_SHADER_BIT;
  m_bg_res = GFL_NEW(m_heap.pHeap) gfl::grp::g3d::Resource;
  m_bg_res->LoadAndSetup(m_heap.pDevHeapAllocator, af, GARC_promotion_encount_panelB_05_BCMDL, NULL, common_resource_flag);
  
  
  m_bg_model = GFL_NEW(m_heap.pHeap) gfl::grp::g3d::Model();
  m_bg_model->Create(
    m_heap.pHeapAllocator,
    m_heap.pDevHeapAllocator,
    m_bg_res,
    0,
    NULL
  );
  
  // Sceneɒǉ @todo draw_indexcalc_index͐l𒼐ڎw肵Ȃ
  //m_3d->GetScene()->AddSceneNode(m_bg_model);
  //m_3d->GetScene()->AddNodeToCalcAndDraw(m_bg_model, m_3d->GetSceneCalcGroupIndex(0), m_3d->GetSceneDrawGroupIndex(0));
  m_3d->GetScene()->AddModelToSceneDrawGroup(m_bg_model, m_3d->GetSceneDrawGroupIndex(0));
  
  // fobOpEŃeNX`Ă܂
  m_bg_tex_res = GFL_NEW(m_heap.pHeap) gfl::grp::g3d::Resource;
  m_bg_tex_res->LoadAndSetup(m_heap.pDevHeapAllocator, af, GARC_promotion_bg001_BCTEX, NULL, common_resource_flag);
  // eNX`쐬AfɃeNX`\t
  // fɓ\t
  m_bg_model->SetMaterialTextureMapperTexture(0,0,m_bg_tex_res, 0);
  
  
  
  GFL_DELETE(af);
}
//------------------------------------------------------------------------------
// `
//------------------------------------------------------------------------------
void Main::Draw()
{
  
  gfl::grp::RenderTarget* upper_frame_buffer[3];

  upper_frame_buffer[0] = m_graphics->GetCurrentFrameBuffer(gfl::grp::DISPLAY_UPPER);
  upper_frame_buffer[1] = m_graphics->GetCurrentFrameBuffer(gfl::grp::DISPLAY_UPPER_RIGHT);
  
  for(int i = 0; i < 2; ++i)
  {
    m_graphics->BindCurrentCommandList(upper_frame_buffer[i]);
    gfl::grp::util::DrawUtil::BeginRender(upper_frame_buffer[i]);

    // ŕ`悷
    // G3DUtil
    //gfl::grp::util::DrawUtil::DrawText(0, 0, L"Hello, Promotion World");

    gfl::grp::util::DrawUtil::EndRender();
  }
  
  upper_frame_buffer[2] = m_graphics->GetCurrentFrameBuffer(gfl::grp::DISPLAY_LOWER);
  
  m_graphics->BindCurrentCommandList(upper_frame_buffer[2]);
  gfl::grp::util::DrawUtil::BeginRender(upper_frame_buffer[2]);

  // ŕ`悷
  //m_scene.DrawBottom(m_graphics);

  gfl::grp::util::DrawUtil::EndRender();
  
  // ŔwʂBGp̃V[`
  //m_3d->GetScene()->StereoDraw(GFL_SINGLETON_INSTANCE(gamesystem::GameManager)->GetGraphicsSystem(), m_bg_camera);
  m_3d->GetScene()->StereoDraw(GFL_SINGLETON_INSTANCE(gamesystem::GameManager)->GetGraphicsSystem(), m_bg_camera, upper_frame_buffer[0], upper_frame_buffer[1], m_3d->GetSceneDrawGroupIndex(0));
  
  // CƂȂV[̕`
  m_3d->Draw3D( GFL_SINGLETON_INSTANCE(gamesystem::GameManager)->GetGraphicsSystem() );
  
  // őOʂɃCAEg`
  m_layout->Draw2D( GFL_SINGLETON_INSTANCE(gamesystem::GameManager)->GetGraphicsSystem(), 0 );
}


//------------------------------------------------------------------------------
// g[i[f̍쐬
//------------------------------------------------------------------------------
void Main::CreateTrainerModel()
{
  xy_system::dress_up::HeroineFashion fashion = xy_system::dress_up::HEROINE_FASHION_DEFAULT;
  xy_system::dress_up::Individual ind;
  ind.section_type = xy_system::dress_up::SECTION_TYPE_BATTLE;
  ind.model_type = xy_system::dress_up::MODEL_TYPE_HEROINE;
  ind.fashion = &fashion;
  
  trainer::TrModel::Description desc = {
    BTL_TR_GRA_ID_HEROINE,
    trainer::TrModel::MODEL_TYPE_BTL_DRESS,
    trainer::TrModel::MOTION_TYPE_OTHER,
    &ind
  };
  
  m_trainer = m_model_manager->RequestCreateModel(
    m_heap.pHeapAllocator,
    m_heap.pDevHeapAllocator,
    desc
  );
  
  m_trainer_created = false;
}
bool Main::IsTrainerModelCreated()
{
  return m_trainer_created;
}
void Main::DestroyTrainerModel()
{
  GFL_ASSERT_MSG(m_model_manager->IsAbleToDestroyModel(m_trainer), "g[i[f%폜ł܂B\n");
  m_model_manager->DestroyModel(m_trainer);
  m_trainer = NULL;
  m_trainer_created = false;
}

void Main::UpdateTrainerModelManager()
{
  enum
  {
    CALC_INDEX = 0,  // @todo `ق悢
    DRAW_INDEX = 0   // @todo src/app/util/app_util_3d.cppɒ`Ăapp::util::SCENE_DRAW_GROUP_MODELɂB
  };
  // g[i[̓ǂݍ݂I^C~Oł̂݁Afǉ
  if(m_trainer != NULL && !m_trainer_created)
  {
    if(m_model_manager->IsModelCreated(m_trainer))
    {
      m_trainer_created = true;
      m_trainer->AddModelToScene(
        m_3d->GetScene(),
        CALC_INDEX,
        DRAW_INDEX
      );
    }
  }
  if(m_rotate_trainer == ROTATE_RIGHT)
  {
    gfl::math::VEC3 v;
    m_trainer->GetRotateXYZ(&v);
    v.y += GFL_MATH_DEG_TO_RAD(ROTATE_SPEED);
    m_trainer->SetRotateXYZ(v);
  }
  if(m_rotate_trainer == ROTATE_LEFT)
  {
    gfl::math::VEC3 v;
    m_trainer->GetRotateXYZ(&v);
    v.y -= GFL_MATH_DEG_TO_RAD(ROTATE_SPEED);
    m_trainer->SetRotateXYZ(v);
  }
  
  m_model_manager->CalculateBefore();
  m_3d->GetScene()->Calculate();
  m_model_manager->CalculateAfter();
  m_bg_camera->UpdateCameraMatrix();
  m_3d->GetScene()->SubmitView(m_bg_camera, true, true, m_3d->GetSceneDrawGroupIndex(0));
  m_3d->Update3D(false);
  //m_3d->GetScene()->SubmitView(m_bg_camera);
}

//------------------------------------------------------------------------------
// g[i[̃[V̕ύX
//------------------------------------------------------------------------------
void Main::ChangeTrainerMotion(int motion)
{
  m_trainer->ChangeMotion(motion);
  m_trainer->SetMotionLoop(true);
}

//------------------------------------------------------------------------------
// g[i[̉]̕ύX
//------------------------------------------------------------------------------
void Main::ChangeTrainerRotation(int rotate_mode)
{
  m_rotate_trainer = -1;
  switch(rotate_mode)
  {
  case ROTATE_FIXED_FRONT:
    m_trainer->SetRotateXYZ(gfl::math::VEC3(0,GFL_MATH_DEG_TO_RAD(0),0));
    break;
  case ROTATE_FIXED_RIGHT:
    m_trainer->SetRotateXYZ(gfl::math::VEC3(0,GFL_MATH_DEG_TO_RAD(90),0));
    break;
  case ROTATE_FIXED_BACK:
    m_trainer->SetRotateXYZ(gfl::math::VEC3(0,GFL_MATH_DEG_TO_RAD(180),0));
    break;
  case ROTATE_FIXED_LEFT:
    m_trainer->SetRotateXYZ(gfl::math::VEC3(0,GFL_MATH_DEG_TO_RAD(270),0));
    break;
  case ROTATE_RIGHT:
    m_rotate_trainer = ROTATE_RIGHT;
    break;
  case ROTATE_LEFT:
    m_rotate_trainer = ROTATE_LEFT;
    break;
  };
}
//------------------------------------------------------------------------------
// ebv̍쐬
//------------------------------------------------------------------------------
void Main::ChangeTelop(int index, const Telop& telop)
{
  // @todo indexɉPANENAME_P_VIDEO_UPPER_PANE_P_WINDOW_BG_01~4؂ւ
  // @todo eLXg̒`؂
  m_layout->SetPaneVisible(0, PANENAME_P_VIDEO_UPPER_PANE_P_WINDOW_BG_01, true);
  
  switch(telop.text)
  {
  case 1:
    // ܊҂̃g[i[
    m_layout->SetTextBoxPaneString(0, PANENAME_P_VIDEO_UPPER_PANE_P_TEXT_01, telop_01, &m_heap);
    break;
  case 2:
    // ̖Fg[i[FI
    // l[hZbgɓo^
    {
      gamesystem::GameManager* gameManager = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
      savedata::MyStatus*    status      = gameManager->GetGameData()->GetPlayerStatus();
      m_layout->SetRegisterPlayerName( 0, status );
      m_layout->SetTextBoxPaneStringExpand(0, PANENAME_P_VIDEO_UPPER_PANE_P_TEXT_01, telop_02, &m_heap);
    }
    break;
  case 3:
    // g[i[̉@낵ˁI
    // l[hZbgɓo^
    {
      gamesystem::GameManager* gameManager = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
      savedata::MyStatus*    status      = gameManager->GetGameData()->GetPlayerStatus();
      m_layout->SetRegisterPlayerName( 0, status );
      m_layout->SetTextBoxPaneStringExpand(0, PANENAME_P_VIDEO_UPPER_PANE_P_TEXT_01, telop_03, &m_heap);
    }
    break;
  }
  
  // ebvʒu̐ݒ
  gfl::math::VEC3 pos;
  if(telop.pos & TELOP_POS_CENTER)
  {
  }
  if(telop.pos & TELOP_POS_TOP)
  {
    pos.y = 100;
  }
  if(telop.pos & TELOP_POS_BOTTOM)
  {
    pos.y = -100;
  }
  if(telop.pos & TELOP_POS_LEFT)
  {
    pos.x = -50;
  }
  if(telop.pos & TELOP_POS_RIGHT)
  {
    pos.x = 50;
  }
  m_layout->SetPanePos(0, PANENAME_P_VIDEO_UPPER_PANE_P_WINDOW_BG_01, &pos);
}

void Main::HideTelop(int index)
{
  m_layout->SetPaneVisible(0, PANENAME_P_VIDEO_UPPER_PANE_P_WINDOW_BG_01, false);
}

//------------------------------------------------------------------------------
// wi̍쐬
//------------------------------------------------------------------------------
void Main::ChangeBG(int index)
{
  
}
void Main::ChangeBGBlightness(int index)
{
  float c = 0;
  switch(index)
  {
  case BG_BLIGHTNESS_MAX:
    c = 1.0f;
    break;
  case BG_BLIGHTNESS_HIGH:
    c = 0.75f;
    break;
  case BG_BLIGHTNESS_MIDDLE:
    c = 0.5f;
    break;
  case BG_BLIGHTNESS_LOW:
    c = 0.25f;
    break;
  case BG_BLIGHTNESS_MIN:
    c = 0.0f;
    break;
  }
  m_bg_model->SetMaterialBlendMode(0, gfl::grp::g3d::Model::MATERIAL_BLEND_MODE_BLEND);
  m_bg_model->SetMaterialColorDiffuse(0, c,c,c);
}
//------------------------------------------------------------------------------
// J̕ύX // @todo 񓯊ǂݍ݂ɑΉKv
//------------------------------------------------------------------------------
gfl::grp::g3d::StereoCamera* Main::CreateCamera(int index)
{
  gfl::fs::ArcFile* af = GFL_NEW_LOW(m_heap.pHeap) gfl::fs::ArcFile(m_heap.pHeap, ARCID_PROMOTION, gfl::fs::ArcFile::OPEN);
  // \[X̃ZbgAbv
  m_res = GFL_NEW(m_heap.pHeap) gfl::grp::g3d::Resource;
  m_res->Load(m_heap.pDevHeapAllocator, af, index);
  // \[XDescription̍쐬
  gfl::grp::g3d::Camera::ResourceDescription desc;
  desc.animation_enable = true;
  gfl::grp::g3d::StereoCamera* cam = GFL_NEW(m_heap.pHeap) gfl::grp::g3d::StereoCamera();
  cam->Create(m_heap.pHeapAllocator, m_heap.pDevHeapAllocator, m_res, 0, &desc);
  //cam->SetCameraPosition(gfl::math::VEC3(0.0f, 100.0f, 250.0f));
  //cam->SetTargetPosition(gfl::math::VEC3(0.0f, 100.0f, 0.0f));
  cam->ChangeAnimation(m_heap.pDevHeapAllocator, m_res, 0, m_res->GetCameraMemberAnimSetCount(0));
  cam->SetAnimationLoop(false);
  
  // ǂݏÎō폜
  GFL_DELETE af;
  return cam;
  /*
    ,
    ,
    0.1f, 
    1000.0f,
    GFL_MATH_DEG_TO_RAD(37.8f),
    0.0f,
    gfl::grp::g3d::StereoCamera::DEPTH_LEVEL_DEFAULT,
    gfl::grp::g3d::StereoCamera::DEPTH_RANGE_DEFAULT,
    gfl::grp::g3d::StereoCamera::REAL_SWITCH_DEFAULT*/
}
void Main::ChangeCamera(int index)
{
  //index = GARC_promotion_cam_ba55_videopose02_BCCAM;
  GFL_PRINT("ChangeCamera:%d\n", index);
  
  // JƍȂĂ܂o[W
  gfl::grp::g3d::StereoCamera* cam = m_3d->GetCamera(app::util::G3DUtil::SETUP_CAMERA_UPPER);
  m_3d->GetScene()->RemoveSceneNode(cam);
  GFL_DELETE(cam);
  m_res->Unload(); GFL_DELETE(m_res);
  
  cam = this->CreateCamera(index);
  m_3d->GetScene()->AddSceneNode(cam, 1);
  m_3d->SetCamera(app::util::G3DUtil::SETUP_CAMERA_UPPER, cam);
  
  
#if 0 // Jc܂܁A\[Xւo[W
  // J̃\[Xǂ
  // A[Nt@Cǂ
  gfl::fs::ArcFile* af = GFL_NEW_LOW(m_heap.pHeap) gfl::fs::ArcFile(m_heap.pHeap, ARCID_PROMOTION, gfl::fs::ArcFile::OPEN);
  // \[X̃ZbgAbv
  gfl::grp::g3d::Resource* res = GFL_NEW(m_heap.pHeap) gfl::grp::g3d::Resource();
  res->Load(m_heap.pDevHeapAllocator, af, index);
  // JύX
  gfl::grp::g3d::StereoCamera* cam = m_3d->GetCamera(app::util::G3DUtil::SETUP_CAMERA_UPPER);
  cam->ChangeAnimation(
    m_heap.pDevHeapAllocator,
    res,
    0,
    res->GetCameraMemberAnimSetCount(0)
  );
  m_res->Unload(); GFL_DELETE(m_res);
  m_res = res;
  cam->SetAnimationLoop(false);
  
  // ǂݏÎō폜
  GFL_DELETE af;
#endif
}

GFL_NAMESPACE_END(promotion)
GFL_NAMESPACE_END(app)
