//============================================================================================
/**
 * @file    Command.h
 * @brief   v[VrfI̊eR}h
 * @author  ito_isao
 * @date    12.05.25
 */
//============================================================================================
#ifndef __APP_PROMOTION_COMMAND_H__
#define __APP_PROMOTION_COMMAND_H__

#include <gflib.h>
#include "Record.h"

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(promotion)

class Main;

enum
{
  ROTATE_FIXED_FRONT,   // 
  ROTATE_FIXED_LEFT,    // 
  ROTATE_FIXED_RIGHT,   // E
  ROTATE_FIXED_BACK,    // 
  ROTATE_RIGHT,         // Eɉ葱
  ROTATE_LEFT,          // ɉ葱
};

enum
{
  BG_BLIGHTNESS_MAX,
  BG_BLIGHTNESS_HIGH,
  BG_BLIGHTNESS_MIDDLE,
  BG_BLIGHTNESS_LOW,
  BG_BLIGHTNESS_MIN,
};

enum
{
  TELOP_POS_CENTER = 0,
  TELOP_POS_TOP = 1,
  TELOP_POS_BOTTOM = 2,
  TELOP_POS_LEFT = 4,
  TELOP_POS_RIGHT = 8,
};

//------------------------------------------------------------------------------
// x[X
//------------------------------------------------------------------------------
class IPromotionCommand : public xy_system::sequence::ICommand
{
public:
  IPromotionCommand(Main* owner) : m_owner(owner){}
  virtual void Exec() = 0;
protected:
  Main* m_owner;
};
//------------------------------------------------------------------------------
// fn
//------------------------------------------------------------------------------
class ChangeTrainerMotionCommand : public IPromotionCommand
{
public:
  ChangeTrainerMotionCommand(Main* owner, int motion);
  virtual void Enter();
  virtual void Exec(){}
private:
  int m_motion;
};
class ChangeTrainerRotationCommand : public IPromotionCommand
{
public:
  ChangeTrainerRotationCommand(Main* owner, int m_rotation);
  virtual void Enter();
  virtual void Exec(){}
private:
  int m_rotation;
};

//------------------------------------------------------------------------------
// BGn
//------------------------------------------------------------------------------
class ChangeBGCommand : public IPromotionCommand
{
public:
  ChangeBGCommand(Main* owner, int bg);
  virtual void Enter();
  virtual void Exec(){}
private:
  int m_bg;
};
class ChangeBGBlightnessCommand : public IPromotionCommand
{
public:
  ChangeBGBlightnessCommand(Main* owner, int bg);
  virtual void Enter();
  virtual void Exec(){}
private:
  int m_bg;
};

//------------------------------------------------------------------------------
// Jn
//------------------------------------------------------------------------------
class ChangeCameraCommand : public IPromotionCommand
{
public:
  ChangeCameraCommand(Main* owner, int camera);
  virtual void Enter();
  virtual void Exec(){}
private:
  int m_camera;
};

//------------------------------------------------------------------------------
// ebvn
//------------------------------------------------------------------------------
// ebv𐶐
class ChangeTelopCommand : public IPromotionCommand
{
public:
  ChangeTelopCommand(Main* owner, int index, const Telop& telop);
  virtual void Enter();
  virtual void Exec(){}
private:
  int m_index;
  Telop m_telop;
};
// 
class HideTelopCommand : public IPromotionCommand
{
public:
  HideTelopCommand(Main* owner, int index);
  virtual void Enter();
  virtual void Exec(){}
private:
  int m_index;
};

//------------------------------------------------------------------------------
// TEhn
//------------------------------------------------------------------------------
class PlaySECommand : public IPromotionCommand
{
public:
  PlaySECommand(Main* owner, int label);
  virtual void Enter();
  virtual void Exec(){}
private:
  int m_label;
};
class PlayBGMCommand : public IPromotionCommand
{
public:
  PlayBGMCommand(Main* owner, int label);
  virtual void Enter();
  virtual void Exec(){}
private:
  int m_label;
};


GFL_NAMESPACE_END(promotion)
GFL_NAMESPACE_END(app)

#endif //__APP_PROMOTION_COMMAND_H__

