
#include "Command.h"
#include "Main.h"

#include "sound/sound.h"

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(promotion)

//------------------------------------------------------------------------------
// fn
//------------------------------------------------------------------------------
ChangeTrainerMotionCommand::ChangeTrainerMotionCommand(Main* owner, int motion) : 
IPromotionCommand(owner),
m_motion(motion)
{
  GFL_PRINT("ChangeTrainerMotionCommand::Created\n");
}
void ChangeTrainerMotionCommand::Enter()
{
  GFL_PRINT("ChangeTrainerMotionCommand::Enter\n");
  m_owner->ChangeTrainerMotion(m_motion);
}
//------------------------------------------------------------------------------
ChangeTrainerRotationCommand::ChangeTrainerRotationCommand(Main* owner, int rotation) : 
IPromotionCommand(owner),
m_rotation(rotation)
{
  GFL_PRINT("ChangeTrainerRotationCommand::Created\n");
}
void ChangeTrainerRotationCommand::Enter()
{
  GFL_PRINT("ChangeTrainerRotationCommand::Enter\n");
  m_owner->ChangeTrainerRotation(m_rotation);
}
//------------------------------------------------------------------------------
// BGn
//------------------------------------------------------------------------------
ChangeBGCommand::ChangeBGCommand(Main* owner, int bg) : 
IPromotionCommand(owner),
m_bg(bg)
{
  GFL_PRINT("ChangeBGCommand::Created\n");
}
void ChangeBGCommand::Enter()
{
  GFL_PRINT("ChangeBGCommand::Enter\n");
  m_owner->ChangeBG(m_bg);
}
//------------------------------------------------------------------------------
ChangeBGBlightnessCommand::ChangeBGBlightnessCommand(Main* owner, int bg) : 
IPromotionCommand(owner),
m_bg(bg)
{
  GFL_PRINT("ChangeBGBlightnessCommand::Created\n");
}
void ChangeBGBlightnessCommand::Enter()
{
  GFL_PRINT("ChangeBGBlightnessCommand::Enter\n");
  m_owner->ChangeBGBlightness(m_bg);
}
//------------------------------------------------------------------------------
// Jn
//------------------------------------------------------------------------------
ChangeCameraCommand::ChangeCameraCommand(Main* owner, int camera) : 
IPromotionCommand(owner),
m_camera(camera)
{
  GFL_PRINT("ChangeCameraCommand::Created\n");
}
void ChangeCameraCommand::Enter()
{
  GFL_PRINT("ChangeCameraCommand::Enter\n");
  m_owner->ChangeCamera(m_camera);
}

//------------------------------------------------------------------------------
// ebvn
//------------------------------------------------------------------------------
ChangeTelopCommand::ChangeTelopCommand(Main* owner, int index, const Telop& telop) : 
IPromotionCommand(owner),
m_index(index),
m_telop(telop)
{
  GFL_PRINT("ChangeTelopCommand::Created\n");
}
void ChangeTelopCommand::Enter()
{
  GFL_PRINT("ChangeTelopCommand::Enter\n");
  m_owner->ChangeTelop(m_index, m_telop);
}
//------------------------------------------------------------------------------
HideTelopCommand::HideTelopCommand(Main* owner, int index) : 
IPromotionCommand(owner),
m_index(index)
{
  GFL_PRINT("HideTelopCommand::Created\n");
}
void HideTelopCommand::Enter()
{
  GFL_PRINT("HideTelopCommand::Enter\n");
  m_owner->HideTelop(m_index);
}

//------------------------------------------------------------------------------
// TEhn
//------------------------------------------------------------------------------
PlaySECommand::PlaySECommand(Main* owner, int label) : 
IPromotionCommand(owner),
m_label(label)
{
  GFL_PRINT("PlaySECommand::Created\n");
}
void PlaySECommand::Enter()
{
  GFL_PRINT("PlaySECommand::Enter\n");
  xy_snd::PlaySE(m_label);
}
//------------------------------------------------------------------------------
PlayBGMCommand::PlayBGMCommand(Main* owner, int label) : 
IPromotionCommand(owner),
m_label(label)
{
  GFL_PRINT("PlayBGMCommand::Created\n");
}
void PlayBGMCommand::Enter()
{
  GFL_PRINT("PlayBGMCommand::Enter\n");
  xy_snd::StartBGM(m_label);
}

GFL_NAMESPACE_END(promotion)
GFL_NAMESPACE_END(app)

