//============================================================================
/**
 *	GAME FREAK inc.
 *
 *	@file		MapReplace.h
 *	@brief  }bvu
 *
 */
//============================================================================

#ifndef __MAPREPLACE_H__
#define __MAPREPLACE_H__

#include  <gflib.h>
#include "MapReplaceDef.h"

namespace field{

//--------------------------------------------------------------
/**
 * @}bv̎wID
 */
//--------------------------------------------------------------
#define MAPREPLACE_ID_01  0
#define MAPREPLACE_ID_02  1
#define MAPREPLACE_ID_03  2
#define MAPREPLACE_ID_04  3
#define MAPREPLACE_ID_05  4
#define MAPREPLACE_ID_06  5
#define MAPREPLACE_ID_07  6
#define MAPREPLACE_ID_08  7
#define MAPREPLACE_ID_09  8
#define MAPREPLACE_ID_10  9

class MapReplace
{
  public:
  //--------------------------------------------------------------
  /// }bvuNGXg̎
  //--------------------------------------------------------------
  typedef enum {
    REPLACE_REQ_NON = 0,
    REPLACE_REQ_BLOCK,
    REPLACE_REQ_MATRIX,
  }REPLACE_REQUEST;

  private:
  enum {
    MAPREPLACE_EVENT_TYPE_NUM = 10,
    MAPREPLACE_DATASIZE = 12, //@todo Ro[^[͂悤ɂ
    MAP_REPLACE_DATA_COUNT = 4, //@todo Ro[^[͂悤ɂ
  };

  
  enum {
    REPID_BASE_KEY = 0,
    REPID_VAR_A,
    //REPID_VAR_B,
    //REPID_VAR_C,
    //REPID_VAR_D,

    REPID_MAX,
  };

  struct REPLACE_DATA{
    u16 matrix_id;    ///<ΏۂƂȂ}gbNXw
    u16 layer_id;      ///<郌C[in`ubNA}gbNXHj
    u16 type;          ///<̃^Cv
    u16 keys[ REPID_MAX ];    ///<f[^
    u16 dummy;
  };  //12byte

  struct REPLACE_OFFSET{
    u32 version_pos;     ///<^CvVer.̏ꍇ̃ItZbgl
    u32 flag_pos[MAPREPLACE_EVENT_TYPE_NUM]; ///tOɂ鏑̏ꍇ̃ItZbgl
  };
  
  gfl::fs::ArcFile* m_Arc;
  int m_DataMax;
  
  REPLACE_OFFSET m_Offsets;
  REPLACE_DATA m_RepData;
  
  public:
  
  MapReplace( gamesystem::GameData* p_gdata, gfl::heap::HeapBase* heap );
  ~MapReplace();
  u32 GetDataMax( void );
  u32 Load( u32 idx );
  REPLACE_REQUEST GetReplaceValue( u32 *before, u32 *after );

  private:
  void MakeReplaceOffset( gamesystem::GameData* p_gdata );
  int GetReplaceTablePos( MAPREPLACE_TYPE rep_type );
};

} // namespace field

#endif	// __MAPREPLACE_H__


