//============================================================================
/**
 *	GAME FREAK inc.
 *
 *	@file		MapReplace.h
 *	@brief  }bvu
 *
 */
//============================================================================

#include "MapReplace.h"

namespace field{


typedef enum {
  REPLACE_FLAG_VALUE01 = 0x1220,  //kagaya
  REPLACE_FLAG_VALUE02 = 0x0224,  //nozomu
  REPLACE_FLAG_VALUE03 = 0x0206,  //tomoya
  REPLACE_FLAG_VALUE04 = 0x1209,  //iwasawa
  REPLACE_FLAG_VALUE05 = 0x0316,  //obata
  REPLACE_FLAG_VALUE06 = 0x1227,  //masafumi
  REPLACE_FLAG_VALUE07 = 0x0830,  //nakatsui
  REPLACE_FLAG_VALUE08 = 0x0408,  //matsumiya
  REPLACE_FLAG_VALUE09 = 0x0120,  //fuchino
  REPLACE_FLAG_VALUE10 = 0x1028,  //watanabe
}REPLACE_FLAGS; //@todo

//--------------------------------------------------------------
//--------------------------------------------------------------
typedef struct {
  u16 rep_data_type;
  u16 rep_data_id;
  u16 wk_id;
  u16 wk_value;
}REPLACE_EVENT_DATA;

//--------------------------------------------------------------
//--------------------------------------------------------------
static const REPLACE_EVENT_DATA replaceEventTable[] = {
  { MAPREPLACE_TYPE_EVENT01, MAPREPLACE_ID_01, 0/*WK_SYS_MAPREPLACE01*/, REPLACE_FLAG_VALUE01 },
  { MAPREPLACE_TYPE_EVENT02, MAPREPLACE_ID_02, 1/*WK_SYS_MAPREPLACE02*/, REPLACE_FLAG_VALUE02 },
  { MAPREPLACE_TYPE_EVENT03, MAPREPLACE_ID_03, 2/*WK_SYS_MAPREPLACE03*/, REPLACE_FLAG_VALUE03 },
  { MAPREPLACE_TYPE_EVENT04, MAPREPLACE_ID_04, 3/*WK_SYS_MAPREPLACE04*/, REPLACE_FLAG_VALUE04 },
  { MAPREPLACE_TYPE_EVENT05, MAPREPLACE_ID_05, 4/*WK_SYS_MAPREPLACE05*/, REPLACE_FLAG_VALUE05 },
  { MAPREPLACE_TYPE_EVENT06, MAPREPLACE_ID_06, 5/*WK_SYS_MAPREPLACE06*/, REPLACE_FLAG_VALUE06 },
  { MAPREPLACE_TYPE_EVENT07, MAPREPLACE_ID_07, 6/*WK_SYS_MAPREPLACE07*/, REPLACE_FLAG_VALUE07 },
  { MAPREPLACE_TYPE_EVENT08, MAPREPLACE_ID_08, 7/*WK_SYS_MAPREPLACE08*/, REPLACE_FLAG_VALUE08 },
  { MAPREPLACE_TYPE_EVENT09, MAPREPLACE_ID_09, 8/*WK_SYS_MAPREPLACE09*/, REPLACE_FLAG_VALUE09 },
  { MAPREPLACE_TYPE_EVENT10, MAPREPLACE_ID_10, 9/*WK_SYS_MAPREPLACE10*/, REPLACE_FLAG_VALUE10 },
};

///SDK_COMPILER_ASSERT( NELEMS(replaceEventTable) == MAPREPLACE_EVENT_TYPE_NUM );


//--------------------------------------------------------------
/**
 * @brief RXgN^
 *
 */
//--------------------------------------------------------------
MapReplace::MapReplace( gamesystem::GameData* p_gdata, gfl::heap::HeapBase* heap )
{
#if 1     //@todo
  m_Arc = NULL; 
  m_DataMax = 0;
#else
  u16 size;
  m_Arc = GFL_NEW_LOW( heap ) gfl::fs::ArcFile(  heap , ARCID_FLDMAP_REPLACE, gfl::fs::ArcFile::OPEN );
  size = m_Arc->GetDataSize( arcID );
  m_DataMax = size / MAPREPLACE_DATASIZE;

  GFL_ASSERT( m_DataMax == MAP_REPLACE_DATA_COUNT );
  GFL_ASSERT( size % MAPREPLACE_DATASIZE == 0 );

  //uItZbglOɎZoĂ
  MakeReplaceOffset( p_gdata );
#endif  
}

//--------------------------------------------------------------
/**
 * @brief fXgN^
 *
 */
//--------------------------------------------------------------
MapReplace::~MapReplace()
{
  if ( m_Arc != NULL )
  {
    GFL_DELETE m_Arc;
  }
}

//--------------------------------------------------------------
/**
 * @brief ItZbg̐
 *
 * @note
 * CxgtȎΉsKvBLqӏUĂ̂Œӂ邱ƁB
 */
//--------------------------------------------------------------
void MapReplace::MakeReplaceOffset( gamesystem::GameData* p_gdata )
{
  int i;
  EventWork* ev = p_gdata->GetEventWork();

#if 0  
  GAME_COMM_SYS_PTR commsys = GAMESYSTEM_GetGameCommSysPtr( gamesystem );
  
  offsets->version_pos = Intrude_GetRomVersion( commsys ) == VERSION_BLACK? 0 : 1;
#endif //@todo
  for ( i = 0; i < MAPREPLACE_EVENT_TYPE_NUM; i++)
  {
    const REPLACE_EVENT_DATA * evData = &replaceEventTable[ i ];
    u16 * work = ev->GetEventWorkAdrs( evData->wk_id );
    if ( *work == evData->wk_value )
    {
      m_Offsets.flag_pos[i] = 1;
    } else {
      m_Offsets.flag_pos[i] = 0; 
    }
  }
}

//--------------------------------------------------------------
/**
 * @brief  f[^擾
 * @return u32  ێĂʃ}bvuf[^̌
 */
//--------------------------------------------------------------
u32 MapReplace::GetDataMax( void )
{
  return m_DataMax;
}

//--------------------------------------------------------------
/**
 * @brief }bvuʃf[^̓ǂݍ
 * @param idx   ǂݍރf[^̃CfbNX
 * @return  u32 ǂݍ񂾃f[^Ή}gbNXID
 */
//--------------------------------------------------------------
u32 MapReplace::Load( u32 idx )
{
#if 1  
  return 0; //@todo
#else
  GFL_ASSERT( idx < m_DataMax );
#if 0
  GFL_ARC_LoadDataOfsByHandle( m_Handle, FILE_ID,
      MAPREPLACE_DATASIZE * idx, MAPREPLACE_DATASIZE, &m_RepData );
#endif
  m_Arc->LoadDataPiece( /*arcID*/0, 0,  MAPREPLACE_DATASIZE, &m_RepData ); //@todo

  GFL_ASSERT( m_RepData.layer_id < MAPREPLACE_LAYER_MAX );
  GFL_ASSERT( m_RepData.type <  MAPREPLACE_TYPE_MAX );

  return m_RepData.matrix_id;
#endif  
}

//--------------------------------------------------------------
/**
 * @brief }bvu
 * @param  before @Of[^IDi[obt@
 * @param  after@@f[^IDi[obt@
 */
//--------------------------------------------------------------
MapReplace::REPLACE_REQUEST MapReplace::GetReplaceValue( u32 *before, u32 *after )
{
  const REPLACE_DATA * rep_data = &m_RepData;
  const REPLACE_OFFSET * offsets = &m_Offsets;
  u32 pos;
  u32 before_val, after_val;
  before_val = rep_data->keys[ REPID_BASE_KEY ];
  after_val = before_val;
  switch ( rep_data->type )
  {
  case MAPREPLACE_TYPE_VERSION:
    after_val = rep_data->keys[ offsets->version_pos ];
    break;

  default:
    pos = GetReplaceTablePos( (MAPREPLACE_TYPE)rep_data->type );
    if ( pos >= 0 ) {
      after_val = rep_data->keys[ offsets->flag_pos[ pos ] ];
      break;
    }
    GFL_ASSERT(0);
    break;
  }
  *before = before_val;
  *after = after_val;

  if ( before_val == after_val ) return REPLACE_REQ_NON;

  if (rep_data->layer_id == MAPREPLACE_LAYER_MATRIX) {
    return REPLACE_REQ_MATRIX;
  } else if (rep_data->layer_id == MAPREPLACE_LAYER_MAPBLOCK) {
    return REPLACE_REQ_BLOCK;
  }
  GFL_ASSERT(0);
  return REPLACE_REQ_NON;
}

//--------------------------------------------------------------
/**
 * @brief
 * @param rep_type
 */
//--------------------------------------------------------------
int MapReplace::GetReplaceTablePos( MAPREPLACE_TYPE rep_type )
{
  int i;
  for (i = 0; i < GFL_NELEMS(replaceEventTable); i++ )
  {
    if ( replaceEventTable[i].rep_data_type == rep_type )
    {
      return i;
    }
  }
  return -1;
}

#if 0
//--------------------------------------------------------------
/**
 * @brief }bvuFtȌꏊ擾
 * @param gamedata  Q[f[^ւ̃|C^
 * @param id        tOwID
 * @return  u16 * tOʒuւ̃|C^
 *
 * ߂lNULL̂ƂAsIDw肵Ă
 */
//--------------------------------------------------------------
static const REPLACE_EVENT_DATA * getMatchedReplaceData( GAMEDATA * gamedata, u32 id )
{
  int i;
  for ( i = 0; i < NELEMS(replaceEventTable); i++ )
  {
    const REPLACE_EVENT_DATA * rep_data = &replaceEventTable[ i ];
    if ( rep_data->rep_data_id == id )
    {
      return rep_data;
    }
  }
  GF_ASSERT_MSG( 0, "ȃ}bvuIDi%d)ł", id );
  return NULL;
}

//--------------------------------------------------------------
/**
 * @brief }bvuFtO̔f
 * @param gamedata  Q[f[^ւ̃|C^
 * @param id        tOwID
 * @param flag      BOOL
 */
//--------------------------------------------------------------
void MAPREPLACE_ChangeFlag( GAMEDATA * gamedata, u32 id, BOOL flag )
{
  const REPLACE_EVENT_DATA * matched_data;

  matched_data = getMatchedReplaceData( gamedata, id );
  if ( matched_data != NULL )
  {
    EVENTWORK * ev = GAMEDATA_GetEventWork( gamedata );
    u16 * work = EVENTWORK_GetEventWorkAdrs( ev, matched_data->wk_id );
    if (flag) {
      *work = matched_data->wk_value;
    } else {
      *work = 0;
    }
    OS_Printf("REPLACE EVENT(%d) SET: %04x\n", id, matched_data->wk_value );
  }
}

//--------------------------------------------------------------
/**
 * @brief }bvuFtO̎擾
 * @param  gamedata  Q[f[^ւ̃|C^
 * @param  id        tOwID
 * @return BOOL
 */
//--------------------------------------------------------------
BOOL MAPREPLACE_GetFlag( GAMEDATA * gamedata, u32 id )
{
  const REPLACE_EVENT_DATA * matched_data;

  matched_data = getMatchedReplaceData( gamedata, id );
  if ( matched_data != NULL )
  {
    EVENTWORK * ev = GAMEDATA_GetEventWork( gamedata );
    u16 * work = EVENTWORK_GetEventWorkAdrs( ev, matched_data->wk_id );
    if ( matched_data->wk_value == *work ) {
      return TRUE;
    } else {
      return FALSE;
    }
  }
  return FALSE;
}
#endif

} // namespace field


