//============================================================================================
/**
 * @file		app_tool_ButtonSelectLower.cpp
 * @brief		ėpʃ{^I
 * @author	Hiroyuki Nakamura
 * @date		12.06.03
 *
 * namespace	app::tool::
 */
//============================================================================================
#include "app/tool/app_tool_ButtonSelectLower.h"
#include "button_lower_res.h"
#include "button_lower_res_pane.h"

#include "common_res/msg_window_res.h"


namespace app {
namespace tool {

static const u32 BUTTON_MAX = 4;

static const gfl::grp::g2d::LytWkSetUp DefaultSetup = {
	gfl::math::VEC3(0,-290,0),  // pos
	gfl::math::VEC2(1,1),       // scale
	gfl::math::VEC3(0,0,0),     // rotate
	1,                          // priority
};


//--------------------------------------------------------------------------------------------
/**
 * @brief		RXgN^
 *
 * @param		param		p[^
 */
//--------------------------------------------------------------------------------------------
ButtonSelectLower::ButtonSelectLower( const InitParam * param ) :
	initParam( *param ),
	pUncomp( NULL ),
	pWinUncomp( NULL ),
	resBuff( NULL ),
	winResBuff( NULL ),
	pLytWk( NULL ),
	lytEnable( false ),
	lytResID( RES_ID_NONE ),
	seq( 0 ),
	menuMax( 0 ),
	menuNum( 0 ),
	pButtonManager( NULL ),
	pMenuCursor( NULL )
{
	pButton = initParam.devManager->GetButton( gfl::ui::CTR_DeviceManager::BUTTON_STANDARD );
	pKey    = initParam.devManager->GetCrossKey( gfl::ui::CTR_DeviceManager::CROSSKEY_STANDARD );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		fXgN^
 */
//--------------------------------------------------------------------------------------------
ButtonSelectLower::~ButtonSelectLower()
{
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		Abvf[g
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void ButtonSelectLower::Update(void)
{
	if( pLytWk != NULL ){
		pLytWk->Update();
	}
	if( pMenuCursor != NULL ){
		pMenuCursor->Update();
	}
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		쐬
 *
 * @param		none
 *
 * @retval	"true = "
 * @retval	"false = 쐬"
 */
//--------------------------------------------------------------------------------------------
bool ButtonSelectLower::Create(void)
{
	switch( seq ){
	case 0:
		InitLayoutUncomp();
		InitMenuCursorUncomp();
		if( initParam.winResID == RES_ID_NONE ){
			InitWindowUncomp();
		}else{
			winResID = initParam.winResID;
		}
		seq++;
		break;

	case 1:
		if( CheckLayoutUncomp() == false &&
				CheckMenuCursorUncomp() == false &&
				CheckWindowUncomp() == false ){
			LoadLayoutResource();
			if( initParam.winResID == RES_ID_NONE ){
				LoadWindowResource();
			}
			RegistWindowResource( winResID );
			CreateLayoutWork();
			CreateMenu( initParam.menuMax );
			for( int i=0; i<initParam.menuMax; i++ ){
				AddMenu( &initParam.menuData[i] );
			}
			CreateMenuCursor();
			SetDrawEnable( initParam.layoutEnable );
			if( initParam.windowType != WIN_TYPE_NONE ){
				SetWindowEnable( initParam.windowType, true );
			}
			seq++;
		}
		break;

	case 2:
		if( initParam.layoutEnable == true ){
			if( pLytWk->IsAnimeEnd( menuMax-1 ) == true ){
				PutMenuCursor();
				seq++;
			}
		}else{
			seq++;
			return true;
		}
		break;

	case 3:
		return true;
	}

	return false;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void ButtonSelectLower::Delete(void)
{
	DeleteMenu();
	DeleteMenuCursor();
	DeleteLayoutWork();

	ReleaseWindowResource();
	ReleaseLayoutResource();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CRg[
 *
 * @param		none
 *
 * @retval	"UPDATE_NONE        = Ȃ"
 * @retval	"UPDATE_CANCEL      = LZ"
 * @retval	"UPDATE_CURSOR_UP   = J[\Ɉړ"
 * @retval	"UPDATE_CURSOR_DOWN = J[\Ɉړ"
 * @retval	"UPDATE_HOLD        = IAj"
 * @retval	"I͎w肳ꂽIDԂ"
 */
//--------------------------------------------------------------------------------------------
u32 ButtonSelectLower::MainControl(void)
{
	if( pButtonManager != NULL ){
		switch( pButtonManager->Update() ){
		case ButtonManager::UPDATE_STATE_IDLE:			// ĂȂ
			break;

		case ButtonManager::UPDATE_STATE_HOLDING:		// {^Ă
			return UPDATE_NONE;

		case ButtonManager::UPDATE_STATE_SELECTED:	// {^Iꂽ
			return pButtonManager->GetSelectedButtonId();
		}

		if( pKey->IsRepeat( gfl::ui::DIR_UP ) ){
			if( menuPos != 0 ){
				menuPos--;
			}else{
				menuPos = menuMax - 1;
			}
			PutMenuCursor();
			return UPDATE_CURSOR_UP;
		}

		if( pKey->IsRepeat( gfl::ui::DIR_DOWN ) ){
			if( menuPos != (menuMax-1) ){
				menuPos++;
			}else{
				menuPos = 0;
			}
			PutMenuCursor();
			return UPDATE_CURSOR_DOWN;
		}

		// A: 
		if( pButton->IsTrigger( gfl::ui::BUTTON_A ) == true ){
			return initParam.menuData[menuPos].id;
		}

		// B: LZ
		if( pButton->IsTrigger( gfl::ui::BUTTON_B ) == true ){
			return UPDATE_CANCEL;
		}
	}

	return UPDATE_NONE;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		`
 *
 * @param		gra			OtBbNVXe
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void ButtonSelectLower::Draw( gfl::grp::GraphicsSystem * gra )
{
	if( pLytWk != NULL && lytEnable == true ){
		gfl::grp::RenderTarget * frame = gra->GetCurrentFrameBuffer( gfl::grp::DISPLAY_LOWER );
		pLytWk->Draw( gra, gfl::grp::DISPLAY_LOWER, frame );
		if( pMenuCursor != NULL ){
			pMenuCursor->Draw( gra, gfl::grp::DISPLAY_LOWER );
		}
	}
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		Xbh𓀏
 *
 * @param		priority	XbhvCIeB@ftHg=gfl::base::Thread::DefaultPriority
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void ButtonSelectLower::InitLayoutUncomp( int priority )
{
	pUncomp = GFL_NEW_LOW( initParam.heap ) gfl::cx::StreamingUncomp();
	pUncomp->InitThreadUncomp(
		ARCID_COMMON_BUTTON_SELECT_LOWER, 0, initParam.heap, initParam.devHeap, &resBuff, priority );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Xbh𓀏̏I`FbN
 *
 * @param		none
 *
 * @retval	"true = 𓀒"
 * @retval	"false = ȊO"
 */
//--------------------------------------------------------------------------------------------
bool ButtonSelectLower::CheckLayoutUncomp(void)
{
	if( pUncomp != NULL ){
		if( pUncomp->ReadThreadUncomp() == true ){
			return true;
		}
		GFL_DELETE pUncomp;
		pUncomp = NULL;
	}
	return false;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CAEg\[Xǂݍ
 *
 * @param		trans		eNX`]tO true = ]@ftHg = true
 *
 * @return	\[XID
 */
//--------------------------------------------------------------------------------------------
gfl::grp::g2d::LytResID ButtonSelectLower::LoadLayoutResource( bool trans )
{
	gfl::fs::ArcFile * af = GFL_NEW_LOW( initParam.heap ) gfl::fs::ArcFile( initParam.heap, ARCID_COMMON_BUTTON_SELECT_LOWER, gfl::fs::ArcFile::OPEN );
	lytResID = initParam.lytSys->LoadLytResComp( initParam.devAllocator, af, 0, true, LYTRES_MSG_WINDOW_RES_END );
	GFL_DELETE af;

	if( trans == true ){
		initParam.lytSys->TransferAllTexture( lytResID, gfl::grp::MEMORY_AREA_FCRAM );
	}

	return lytResID;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CAEg\[Xǂݍ
 *
 * @param		trans		eNX`]tO true = ]@ftHg = true
 *
 * @return	\[XID
 *
 * @li	InitLayoutUncomp()gpꍇ͂
 */
//--------------------------------------------------------------------------------------------
gfl::grp::g2d::LytResID ButtonSelectLower::LoadLayoutResourceUncomp( bool trans )
{
	lytResID = initParam.lytSys->LoadLytRes( initParam.devAllocator, resBuff, true, LYTRES_MSG_WINDOW_RES_END );
	if( trans == true ){
		initParam.lytSys->TransferAllTexture( lytResID, gfl::grp::MEMORY_AREA_FCRAM );
	}
	return lytResID;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CAEg\[X폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void ButtonSelectLower::ReleaseLayoutResource(void)
{
	if( lytResID != RES_ID_NONE ){
		initParam.lytSys->ReleaseLytRes( lytResID );
	}
	if( resBuff != NULL ){
		GFL_DELETE resBuff;
	}
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		CAEg[N쐬
 *
 * @param		id		\[XID
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void ButtonSelectLower::CreateLayoutWork( gfl::grp::g2d::LytResID id )
{
	static const gfl::grp::g2d::LytArcIndex tbl[] = {
		LYTRES_BUTTON_LOWER_RES_BUTTON_SELECT_LOWER_SELECT_1_BCLAN,
		LYTRES_BUTTON_LOWER_RES_BUTTON_SELECT_LOWER_SELECT_2_BCLAN,
		LYTRES_BUTTON_LOWER_RES_BUTTON_SELECT_LOWER_SELECT_3_BCLAN,
		LYTRES_BUTTON_LOWER_RES_BUTTON_SELECT_LOWER_SELECT_4_BCLAN,
		/* j[Aj͌ŒBǉ͉ɁB */
	};

	if( initParam.setup == NULL ){
		pLytWk = initParam.lytSys->CreateLytWk(
							id, LYTRES_BUTTON_LOWER_RES_BUTTON_SELECT_LOWER_BCLYT, tbl, GFL_NELEMS(tbl), GFL_NELEMS(tbl), &DefaultSetup, false );
	}else{
		pLytWk = initParam.lytSys->CreateLytWk(
							id, LYTRES_BUTTON_LOWER_RES_BUTTON_SELECT_LOWER_BCLYT, tbl, GFL_NELEMS(tbl), GFL_NELEMS(tbl), initParam.setup, false );
	}
	pLytWk->SetAutoDrawFlag( initParam.autoDrawFlag );
	SetPaneVisible( PANENAME_BUTTON_SELECT_LOWER_PANE_BASE_BG, initParam.baseEnable );
	SetDrawEnable( false );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CAEg[N쐬
 *
 * @param		none
 *
 * @return	none
 *
 * @li	LoadLayoutResource()gpꍇ͂
 */
//--------------------------------------------------------------------------------------------
void ButtonSelectLower::CreateLayoutWork(void)
{
	CreateLayoutWork( lytResID );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CAEg[N폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void ButtonSelectLower::DeleteLayoutWork(void)
{
	if( pLytWk != NULL ){
		initParam.lytSys->RemoveLytWk( pLytWk );
	}
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CAEg[N擾
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
gfl::grp::g2d::LytWk * ButtonSelectLower::GetLayoutWork(void)
{
	return pLytWk;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		CAEg\؂ւ
 *
 * @param		flg		true = \, false = \
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void ButtonSelectLower::SetDrawEnable( bool flg )
{
	lytEnable = flg;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		yC̕\؂ւ
 *
 * @param		index		yC̃CfbNX
 * @param		flg			true = \, false = \
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void ButtonSelectLower::SetPaneVisible( gfl::grp::g2d::LytPaneIndex index, bool flg )
{
  gfl::grp::g2d::LytPane * pane = pLytWk->GetPane( index );
	pane->SetVisible( flg );
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		EBhE\[X̃Xbh𓀏
 *
 * @param		priority	XbhvCIeB@ftHg=gfl::base::Thread::DefaultPriority
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void ButtonSelectLower::InitWindowUncomp( int priority )
{
	pWinUncomp = GFL_NEW_LOW( initParam.heap ) gfl::cx::StreamingUncomp();
	pWinUncomp->InitThreadUncomp(
		ARCID_COMMON_MSGWINDOW, 0, initParam.heap, initParam.devHeap, &winResBuff, priority );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		EBhE\[X̃Xbh𓀏̏I`FbN
 *
 * @param		none
 *
 * @retval	"true = 𓀒"
 * @retval	"false = ȊO"
 */
//--------------------------------------------------------------------------------------------
bool ButtonSelectLower::CheckWindowUncomp(void)
{
	if( pWinUncomp != NULL ){
		if( pWinUncomp->ReadThreadUncomp() == true ){
			return true;
		}
		GFL_DELETE pWinUncomp;
		pWinUncomp = NULL;
	}
	return false;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		EBhE\[X̓ǂݍ
 *
 * @param		trans		eNX`]tO true = ]@ftHg = true
 *
 * @return	\[XID
 */
//--------------------------------------------------------------------------------------------
gfl::grp::g2d::LytResID ButtonSelectLower::LoadWindowResource( bool trans )
{
	winResID = initParam.lytSys->LoadLytRes( initParam.devAllocator, winResBuff, true );
	if( trans == true ){
		initParam.lytSys->TransferAllTexture( winResID, gfl::grp::MEMORY_AREA_FCRAM );
	}
	return winResID;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		EBhE\[X
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void ButtonSelectLower::ReleaseWindowResource(void)
{
	if( initParam.winResID != RES_ID_NONE ){
		initParam.lytSys->ReleaseLytRes( winResID );
	}
	if( winResBuff != NULL ){
		GFL_DELETE winResBuff;
	}
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		EBhẼ\[Xǉ
 *
 * @param		src		EBhẼ\[XID
 * @param		dst		ǉ̃\[XID@ftHg = RES_ID_NONE
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void ButtonSelectLower::RegistWindowResource( gfl::grp::g2d::LytResID src, gfl::grp::g2d::LytResID dst )
{
	if( dst == RES_ID_NONE ){
		dst = lytResID;
	}
	initParam.lytSys->RegistTextureRes( src, dst );
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		j[쐬
 *
 * @param		max		ڍő吔
 * @param		pos		ʒu@ftHg = 0
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void ButtonSelectLower::CreateMenu( u32 max, u32 pos )
{
	u32	anm = max-1;

	if( pLytWk->IsBindAnime( anm ) == false ) {
		pLytWk->BindAnime( anm );
	}
	pLytWk->SetAutoAnime( anm, true );
	pLytWk->SetAnimeFrame( anm, 0 );

	menuMax = max;
	menuPos = pos;

	pButtonManager = GFL_NEW( initParam.heap ) ButtonManager( initParam.heap, initParam.devManager, BUTTON_MAX );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		j[폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void ButtonSelectLower::DeleteMenu(void)
{
	GFL_DELETE pButtonManager;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		j[ǉ
 *
 * @param		dat		j[f[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void ButtonSelectLower::AddMenu( const MenuData * dat )
{
	static const gfl::grp::g2d::LytPaneIndex text_tbl[] = {
		PANENAME_BUTTON_SELECT_LOWER_PANE_BUTTON1_TEXT,
		PANENAME_BUTTON_SELECT_LOWER_PANE_BUTTON2_TEXT,
		PANENAME_BUTTON_SELECT_LOWER_PANE_BUTTON3_TEXT,
		PANENAME_BUTTON_SELECT_LOWER_PANE_BUTTON4_TEXT,
	};
	static const gfl::grp::g2d::LytPaneIndex bound_tbl[] = {
		PANENAME_BUTTON_SELECT_LOWER_PANE_BUTTON1_BOUND,
		PANENAME_BUTTON_SELECT_LOWER_PANE_BUTTON2_BOUND,
		PANENAME_BUTTON_SELECT_LOWER_PANE_BUTTON3_BOUND,
		PANENAME_BUTTON_SELECT_LOWER_PANE_BUTTON4_BOUND,
	};

	GFL_ASSERT( menuNum < menuMax );

	gfl::grp::g2d::LytTextBox * text = pLytWk->GetTextBoxPane( text_tbl[menuNum] );
	print::SetStringForLytTextBox( text, dat->str );

	pButtonManager->AddButton(
										initParam.heap,				// Ǘ[NmۂɎgpq[v
										dat->id,							// {^̎ʎq( IꂽۂUpdate()ŕԂĂl )
										pLytWk,								// {^郌CAEg[N
										bound_tbl[menuNum],		// {^\yC( 蔻Ɏgp )
										ButtonManager::ANIMATION_NULL,	// {^^b`ꂽۂɍĐAj[V( svȂANIMATION_NULL )
										ButtonManager::ANIMATION_NULL,	// {^ꂽۂɍĐAj[V( svȂANIMATION_NULL )
										ButtonManager::ANIMATION_NULL,	// {^IꂽۂɍĐAj[V( svȂANIMATION_NULL )
										NULL );					// {^IꂽۂɒʒmR[obNNX( svȂNULL )

	menuNum++;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		bZ[WEBhE\ݒ
 *
 * @param		type		EBhE^Cv
 * @param		flg			true = \, false = \
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void ButtonSelectLower::SetWindowEnable( u32 type, bool flg )
{
	SetPaneVisible( PANENAME_BUTTON_SELECT_LOWER_PANE_WINDOW_1, flg );
	if( flg == true ){
		if( type == WIN_TYPE_NORMAL ){
			SetPaneVisible( PANENAME_BUTTON_SELECT_LOWER_PANE_WIN_1_1_TEXT, true );
		}else{
			SetPaneVisible( PANENAME_BUTTON_SELECT_LOWER_PANE_WIN_2_1_TEXT, true );
			SetPaneVisible( PANENAME_BUTTON_SELECT_LOWER_PANE_WIN_2_2_TEXT, true );
		}
	}
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		bZ[W̃eLXg{bNXyC擾
 *
 * @param		id	擾ID
 *
 * @return	eLXg{bNXyC
 */
//--------------------------------------------------------------------------------------------
gfl::grp::g2d::LytPaneIndex ButtonSelectLower::GetTextPane( u32 type )
{
	static const gfl::grp::g2d::LytPaneIndex tbl[] = {
		PANENAME_BUTTON_SELECT_LOWER_PANE_WIN_1_1_TEXT,
		PANENAME_BUTTON_SELECT_LOWER_PANE_WIN_2_1_TEXT,
		PANENAME_BUTTON_SELECT_LOWER_PANE_WIN_2_2_TEXT,
	};
	return tbl[type];
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		j[J[\
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void ButtonSelectLower::InitMenuCursorUncomp(void)
{
	pMenuCursor = GFL_NEW( initParam.heap ) MenuCursor( initParam.lytSys );
	pMenuCursor->InitLayoutUncomp( initParam.heap, initParam.devHeap );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		j[J[\𓀏҂
 *
 * @param		none
 *
 * @retval	"true = "
 * @retval	"false = ȊO"
 */
//--------------------------------------------------------------------------------------------
bool ButtonSelectLower::CheckMenuCursorUncomp(void)
{
	return pMenuCursor->CheckLayoutUncomp();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		j[J[\쐬
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void ButtonSelectLower::CreateMenuCursor(void)
{
	pMenuCursor->LoadLayoutResource( initParam.devAllocator );
	if( initParam.setup == NULL ){
		pMenuCursor->CreateLayoutWork( &DefaultSetup, initParam.autoDrawFlag );
	}else{
		pMenuCursor->CreateLayoutWork( initParam.setup, initParam.autoDrawFlag );
	}
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		j[J[\폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void ButtonSelectLower::DeleteMenuCursor(void)
{
	pMenuCursor->DeleteLayoutWork();
	pMenuCursor->ReleaseLayoutResource();
	GFL_DELETE pMenuCursor;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		j[J[\zu
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void ButtonSelectLower::PutMenuCursor(void)
{
	static const gfl::grp::g2d::LytPaneIndex tbl[] = {
		PANENAME_BUTTON_SELECT_LOWER_PANE_CURSOL_1_POS,
		PANENAME_BUTTON_SELECT_LOWER_PANE_CURSOL_2_POS,
		PANENAME_BUTTON_SELECT_LOWER_PANE_CURSOL_3_POS,
		PANENAME_BUTTON_SELECT_LOWER_PANE_CURSOL_4_POS,
	};
	pMenuCursor->Put( pLytWk, tbl[menuPos] );
}


}	// tool
}	// app
