//============================================================================================
/**
 * @file		app_tool_ButtonSelectLower.h
 * @brief		ėpʃ{^I
 * @author	Hiroyuki Nakamura
 * @date		12.06.03
 *
 * namespace	app::tool::
 */
//============================================================================================
#if !defined( __APP_TOOL_BUTTONSELECTLOWER_H__ )
#define __APP_TOOL_BUTTONSELECTLOWER_H__

#include <gflib.h>
#include "app/tool/app_tool_ButtonManager.h"
#include "app/tool/app_tool_MenuCursor.h"


namespace app {
namespace tool {

class ButtonSelectLower {
public:
	// j[f[^
	struct MenuData {
		gfl::str::StrBuf * str;		// ڕ
		u32	id;										// IɕԂl
	};

	// p[^
	struct InitParam {
		gfl::grp::g2d::LytSys * lytSys;								// CAEgVXe
		const gfl::ui::DeviceManager * devManager;		// UIfoCX}l[W

		gfl::heap::HeapBase * heap;							// q[v
		gfl::heap::HeapBase * devHeap;					// foCXq[v
		gfl::heap::NwAllocator * allocator;			// q[vAP[^
		gfl::heap::NwAllocator * devAllocator;	// foCXq[vAP[^

		gfl::grp::g2d::LytResID	winResID;		// EBhẼ\[XID@RES_ID_NONE=ǂݍ

		const MenuData * menuData;	// j[f[^
		u32	menuMax;								// j[

		const gfl::grp::g2d::LytWkSetUp * setup;	// CAEg[ÑZbgAbvf[^
		bool layoutEnable;			// CAEg\@true = \
		bool baseEnable;				// ėpwi\@true = \
		bool autoDrawFlag;			// I[g`tO
		u32	windowType;					// EBhE\@WIN_TYPE_**@WIN_TYPE_NONE = \
	};

	static const u32 RES_ID_NONE = 0xffffffff;		// \[XIDȂ

	static const u32 UPDATE_NONE        = 0xffffffff;		// Abvf[g̖߂lFȂ
	static const u32 UPDATE_CANCEL      = 0xfffffffe;		// Abvf[g̖߂lFLZ
	static const u32 UPDATE_CURSOR_UP   = 0xfffffffd;		// Abvf[g̖߂lFJ[\Ɉړ
	static const u32 UPDATE_CURSOR_DOWN = 0xfffffffc;		// Abvf[g̖߂lFJ[\Ɉړ
	static const u32 UPDATE_HOLD        = 0xfffffffb;		// Abvf[g̖߂lFIAj

	// EBhE^Cv
	enum {
		WIN_TYPE_NORMAL = 0,		// ꊇ\pEBhE
		WIN_TYPE_PRINT,					// 胁bZ[WpEBhE

		WIN_TYPE_NONE,
	};

	// bZ[WeLXgyC擾ID
	enum {
		GET_TEXT_PANE_ID_NORMAL = 0,		// ꊇ\peLXg{bNXyC
		GET_TEXT_PANE_ID_PRINT1,				// 胁bZ[WpeLXg{bNXyCP
		GET_TEXT_PANE_ID_PRINT2,				// 胁bZ[WpeLXg{bNXyCQ

	};


	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		RXgN^
	 *
	 * @param		param		p[^
	 */
	//--------------------------------------------------------------------------------------------
	ButtonSelectLower( const InitParam * param );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		fXgN^
	 */
	//--------------------------------------------------------------------------------------------
	virtual ~ButtonSelectLower();

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		Abvf[g
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void Update(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		쐬
	 *
	 * @param		none
	 *
	 * @retval	"true = "
	 * @retval	"false = 쐬"
	 */
	//--------------------------------------------------------------------------------------------
	bool Create(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		폜
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void Delete(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		CRg[
	 *
	 * @param		none
	 *
	 * @retval	"UPDATE_NONE        = Ȃ"
	 * @retval	"UPDATE_CANCEL      = LZ"
	 * @retval	"UPDATE_CURSOR_UP   = J[\Ɉړ"
	 * @retval	"UPDATE_CURSOR_DOWN = J[\Ɉړ"
	 * @retval	"UPDATE_HOLD        = IAj"
	 * @retval	"I͎w肳ꂽIDԂ"
	 */
	//--------------------------------------------------------------------------------------------
	u32 MainControl(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		`
	 *
	 * @param		gra			OtBbNVXe
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void Draw( gfl::grp::GraphicsSystem * gra );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		CAEg[N擾
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	gfl::grp::g2d::LytWk * GetLayoutWork(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		bZ[WEBhE\ݒ
	 *
	 * @param		type		EBhE^Cv
	 * @param		flg			true = \, false = \
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void SetWindowEnable( u32 type, bool flg );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		bZ[W̃eLXg{bNXyC擾
	 *
	 * @param		id	擾ID
	 *
	 * @return	eLXg{bNXyC
	 */
	//--------------------------------------------------------------------------------------------
	gfl::grp::g2d::LytPaneIndex GetTextPane( u32 type );

private:
	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		Xbh𓀏
	 *
	 * @param		priority	XbhvCIeB@ftHg=gfl::base::Thread::DefaultPriority
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void InitLayoutUncomp( int priority=gfl::base::Thread::DefaultPriority );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		Xbh𓀏̏I`FbN
	 *
	 * @param		none
	 *
	 * @retval	"true = 𓀒"
	 * @retval	"false = ȊO"
	 */
	//--------------------------------------------------------------------------------------------
	bool CheckLayoutUncomp(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		CAEg\[Xǂݍ
	 *
	 * @param		trans		eNX`]tO true = ]@ftHg = true
	 *
	 * @return	\[XID
	 */
	//--------------------------------------------------------------------------------------------
	gfl::grp::g2d::LytResID LoadLayoutResource( bool trans = true );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		CAEg\[Xǂݍ
	 *
	 * @param		trans		eNX`]tO true = ]@ftHg = true
	 *
	 * @return	\[XID
	 *
	 * @li	InitLayoutUncomp()gpꍇ͂
	 */
	//--------------------------------------------------------------------------------------------
	gfl::grp::g2d::LytResID LoadLayoutResourceUncomp( bool trans = true );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		CAEg\[X폜
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void ReleaseLayoutResource(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		CAEg[N쐬
	 *
	 * @param		id		\[XID
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void CreateLayoutWork( gfl::grp::g2d::LytResID id );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		CAEg[N쐬
	 *
	 * @param		none
	 *
	 * @return	none
	 *
	 * @li	LoadLayoutResource()gpꍇ͂
	 */
	//--------------------------------------------------------------------------------------------
	void CreateLayoutWork(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		CAEg[N폜
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void DeleteLayoutWork(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		CAEg\؂ւ
	 *
	 * @param		flg		true = \, false = \
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void SetDrawEnable( bool flg );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		yC̕\؂ւ
	 *
	 * @param		index		yC̃CfbNX
	 * @param		flg			true = \, false = \
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void SetPaneVisible( gfl::grp::g2d::LytPaneIndex index, bool flg );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		EBhE\[X̃Xbh𓀏
	 *
	 * @param		priority	XbhvCIeB@ftHg=gfl::base::Thread::DefaultPriority
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void InitWindowUncomp( int priority=gfl::base::Thread::DefaultPriority );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		EBhE\[X̃Xbh𓀏̏I`FbN
	 *
	 * @param		none
	 *
	 * @retval	"true = 𓀒"
	 * @retval	"false = ȊO"
	 */
	//--------------------------------------------------------------------------------------------
	bool CheckWindowUncomp(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		EBhE\[X̓ǂݍ
	 *
	 * @param		trans		eNX`]tO true = ]@ftHg = true
	 *
	 * @return	\[XID
	 */
	//--------------------------------------------------------------------------------------------
	gfl::grp::g2d::LytResID LoadWindowResource( bool trans = true );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		EBhE\[X
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void ReleaseWindowResource(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		EBhẼ\[Xǉ
	 *
	 * @param		src		EBhẼ\[XID
	 * @param		dst		ǉ̃\[XID@ftHg = RES_ID_NONE
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void RegistWindowResource( gfl::grp::g2d::LytResID src, gfl::grp::g2d::LytResID dst = RES_ID_NONE );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		j[쐬
	 *
	 * @param		max		ڍő吔
	 * @param		pos		ʒu@ftHg = 0
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void CreateMenu( u32 max, u32 pos = 0 );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		j[폜
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void DeleteMenu(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		j[ǉ
	 *
	 * @param		dat		j[f[^
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void AddMenu( const MenuData * dat );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		j[J[\
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void InitMenuCursorUncomp(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		j[J[\𓀏҂
	 *
	 * @param		none
	 *
	 * @retval	"true = "
	 * @retval	"false = ȊO"
	 */
	//--------------------------------------------------------------------------------------------
	bool CheckMenuCursorUncomp(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		j[J[\쐬
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void CreateMenuCursor(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		j[J[\폜
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void DeleteMenuCursor(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		j[J[\zu
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void PutMenuCursor(void);


private:
	InitParam initParam;

	gfl::ui::VectorDevice * pKey;								// \L[
	gfl::ui::Button * pButton;									// {^

	gfl::cx::StreamingUncomp * pUncomp;			// Xg[~O𓀏
	gfl::cx::StreamingUncomp * pWinUncomp;
	void * resBuff;
	void * winResBuff;

	gfl::grp::g2d::LytWk * pLytWk;
	bool	lytEnable;
	gfl::grp::g2d::LytResID	lytResID;
	gfl::grp::g2d::LytResID	winResID;

	u8	seq;

	u8	menuMax;
	u8	menuNum;

	u8	menuPos;

	ButtonManager * pButtonManager;	// {^}l[W

	MenuCursor * pMenuCursor;
};


}		// tool
}		// app

#endif // __APP_TOOL_BUTTONSELECTLOWER_H__
