//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		app_captureregister_ZukanRegisterProc.h
 *	@brief
 *	@author	Toru=Nagihashi
 *	@date		2012.05.31
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#pragma once
#if !defined( __APP_CAPTUREREGISTER_ZUKANREGISTERPROC_H__)
#define __APP_CAPTUREREGISTER_ZUKANREGISTERPROC_H__

#include <gflib.h>
#include <pmlib.h>
#include <gamesystem/GameProc.h>
#include <app/util/app_util_heap.h>
#include "app/zukan/app_zukan_Graphics.h"
#include "app/zukan/app_zukan_DataManager.h"
  
GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(captureregister)
  
class ParentView;

class ZukanRegisterProc : public gamesystem::GameProc, public app::util::Heap
{
  GFL_FORBID_COPY_AND_ASSIGN(ZukanRegisterProc);
public:
  enum Mode
  {
    MODE_ZUKAN_REGISTER,  ///}ӓo^ʁi}ӓo^ĂĂ֓nőJځj
    MODE_BOX_TRANS, ///<{bNX֓]܂
  };
  enum Result
  {
    RESULT_NAME_NO,
    RESULT_NAME_YES,
  };

  struct PARAM
  {
    pml::pokepara::CoreParam *capture_pokemon;  ///<ߊl|P
    Mode    mode; ///<N[h
    Result  result; ///<[out] 
  };

  //-----------------------------------------------------------------------
  // RXgN^EfXgN^
  //-----------------------------------------------------------------------
  /**
   *	@brief  RXgN^
   *	@param  param 
   */
  ZukanRegisterProc( PARAM *param );
  /**
   *	@brief  fXgN^
   */
  virtual ~ZukanRegisterProc();


  //-----------------------------------------------------------------------
  // GameProcI[o[Cg
  //-----------------------------------------------------------------------
  /**
   *	@brief  PROC
   *	@param	Manager vZX}l[W[
   *	@return Result IR[h
   */
  virtual gfl::proc::Result InitFunc(gfl::proc::Manager * manager);
  /**
   *	@brief  PROCj
   *	@param	Manager vZX}l[W[
   *	@return Result IR[h
   */
  virtual gfl::proc::Result EndFunc(gfl::proc::Manager * manager);
  /**
   *	@brief  PROCC
   *	@param	Manager vZX}l[W[
   *	@return Result IR[h
   */
  virtual gfl::proc::Result UpdateFunc(gfl::proc::Manager * manager);
  /**
   *	@brief  PROC`
   *	@param	Manager vZX}l[W[
   *	@return Result IR[h
   */
  virtual void DrawFunc(gfl::proc::Manager * manager);

  //-----------------------------------------------------------------------
  // V[PX
  //-----------------------------------------------------------------------
private:
  bool Sequence_Main_RegisterZukan( void );
  bool Sequence_Main_NickName( void );
  bool Sequence_Main_TransBox( void );
  bool Sequence_Sub_FadeIn( void );
  bool Sequence_Sub_FadeOut(void );
  bool Sequence_Sub_RegisterZukan( void );
  bool Sequence_Sub_NickNameYesNo( void );
  bool Sequence_Sub_TransBox( void );
  
private:
  static const int SYSTEM_HEAP_SIZE   = 0x400000;
  static const int DEVICE_HEAP_SIZE   = 0x700000;

  typedef bool(ZukanRegisterProc::*MainSequence)( void );
  typedef bool(ZukanRegisterProc::*SubSequence)( void );
private:
  PARAM *m_param;
  app::zukan::Graphics    *m_graphics;
  app::zukan::DataManager *m_data_manager;
  ParentView  *m_view;
  savedata::ZukanData *m_zukan_save;
  gfl::ui::DeviceManager * m_device_manager;
  int m_counter;
  
  int m_seq;
  int m_sub_seq;
  
  MainSequence  m_main_function;
  SubSequence   m_sub_function;
private:
  void CallSequence( SubSequence seq );
  void NextSequence( MainSequence seq );
  bool UpdateSequence( void );
};

GFL_NAMESPACE_END(captureregister)
GFL_NAMESPACE_END(app)

#endif		// __APP_CAPTUREREGISTER_ZUKANREGISTERPROC_H__
