//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		app_captureregister_ZukanRegisterProc.cpp
 *	@brief
 *	@author	Toru=Nagihashi
 *	@date		2012.05.31
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "app_captureregister_ZukanRegisterProc.h"
#include "app/util/app_util_Common.h"
#include "app_captureregister_ParentView.h"
#include "poke_tool/poke_tool.h"
#include <message/msg_capture_register.h>

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(captureregister)

//-----------------------------------------------------------------------
// RXgN^EfXgN^
//-----------------------------------------------------------------------
/**
 *	@brief  RXgN^
 *	@param  param 
 */
ZukanRegisterProc::ZukanRegisterProc( PARAM *param ) :
  gamesystem::GameProc(),
  app::util::Heap(),
  m_counter( 0 ),
  m_seq( 0 ),
  m_sub_seq( 0 ),
  m_main_function( NULL ),
  m_sub_function( NULL )
{
  m_param = param;
  GFL_ASSERT( m_param->capture_pokemon != NULL );

  //q[v쐬
  this->Create( HEAPID_CAPTUREREGISTER_SYSTEM, SYSTEM_HEAP_SIZE, HEAPID_CAPTUREREGISTER_DEVICE, DEVICE_HEAP_SIZE );
}

/**
 *	@brief  fXgN^
 */
ZukanRegisterProc::~ZukanRegisterProc()
{

  //q[vj
  this->Delete();
}

//-----------------------------------------------------------------------
// GameProcI[o[Cg
//-----------------------------------------------------------------------
/**
 *	@brief  PROC
 *	@param	Manager vZX}l[W[
 *	@return Result IR[h
 */
gfl::proc::Result ZukanRegisterProc::InitFunc(gfl::proc::Manager * manager)
{
  GFL_UNUSED( manager );
  
  m_zukan_save  = mpGameProcManager->GetGameManager()->GetGameData()->GetZukanData();

  m_device_manager = mpGameProcManager->GetGameManager()->GetUiDeviceManager();

  //f[^}l[W[쐬
  m_data_manager  = GFL_NEW(this->GetSystemHeap()) app::zukan::DataManager(this,mpGameProcManager);

  //OtBbNX쐬
  gfl::grp::GraphicsSystem *graphics_system = mpGameProcManager->GetGameManager()->GetGraphicsSystem();
  gfl::fs::FileReadManager *file_read_manager = mpGameProcManager->GetGameManager()->GetFileReadManager();
  m_graphics = GFL_NEW(this->GetSystemHeap()) app::zukan::Graphics(this,graphics_system,file_read_manager );
  
  //eView
  ParentView::UpperViewType type;
  if( m_param->mode == ZukanRegisterProc::MODE_ZUKAN_REGISTER 
      && !m_zukan_save->GetPokeGetFlag( m_param->capture_pokemon->GetMonsNo() ) )
  {
    //}ӓo^
    type = ParentView::UPPER_VIEW_ZUKAN;
    
    //}ӓo^
    m_zukan_save->SetPokeGet( *m_param->capture_pokemon );

    this->NextSequence( &ZukanRegisterProc::Sequence_Main_RegisterZukan );
  }
  else
  {
    if( m_param->mode == ZukanRegisterProc::MODE_BOX_TRANS )
    {
      this->NextSequence( &ZukanRegisterProc::Sequence_Main_TransBox );
    }
    else
    {
      this->NextSequence( &ZukanRegisterProc::Sequence_Main_NickName );
    }
    type = ParentView::UPPER_VIEW_NORMAL;
  }
  poke_tool::SimpleParam  simple_param;
  poke_tool::SetSimpleParam( &simple_param, m_param->capture_pokemon );
  
  m_view  = GFL_NEW( this->GetSystemHeap() ) ParentView( this, m_device_manager, m_graphics,  m_data_manager, type, &simple_param );

  return gfl::proc::RES_FINISH; 
}

/**
 *	@brief  PROCj
 *	@param	Manager vZX}l[W[
 *	@return Result IR[h
 */
gfl::proc::Result ZukanRegisterProc::EndFunc(gfl::proc::Manager * manager)
{
  GFL_UNUSED( manager );
  //eView
  GFL_SAFE_DELETE( m_view );

  GFL_SAFE_DELETE( m_graphics );
  GFL_SAFE_DELETE( m_data_manager );

  return gfl::proc::RES_FINISH;
}

/**
 *	@brief  PROCC
 *	@param	Manager vZX}l[W[
 *	@return Result IR[h
 */
gfl::proc::Result ZukanRegisterProc::UpdateFunc(gfl::proc::Manager * manager)
{
  GFL_UNUSED( manager );
  m_graphics->Update();

  if( this->UpdateSequence() )
  {
    return gfl::proc::RES_FINISH;
  }
  else
  {
    return gfl::proc::RES_CONTINUE;
  }
}

/**
 *	@brief  PROC`
 *	@param	Manager vZX}l[W[
 *	@return Result IR[h
 */
void ZukanRegisterProc::DrawFunc(gfl::proc::Manager * manager)
{
  GFL_UNUSED( manager );
  m_view->DrawTree();
  m_view->Draw();
  m_graphics->Draw(); ///3DO
}

//-----------------------------------------------------------------------
// V[PX
//-----------------------------------------------------------------------
/**
 * @brief   }ӓo^
 *
 * @return trueŃV[PXI falseŃV[PX 
 */
bool ZukanRegisterProc::Sequence_Main_RegisterZukan( void )
{
  enum
  {
    SEQ_FADEIN,
    SEQ_ZUKAN,
    SEQ_NICKNAME,
    SEQ_FADEOUT,
    SEQ_END,
  };
  switch( m_seq )
  {
  case SEQ_FADEIN:
    this->CallSequence( &ZukanRegisterProc::Sequence_Sub_FadeIn );
    m_seq = SEQ_ZUKAN;
    break;
  case SEQ_ZUKAN:
    this->CallSequence( &ZukanRegisterProc::Sequence_Sub_RegisterZukan );
    m_seq = SEQ_NICKNAME;
    break;
  case SEQ_NICKNAME:
    this->CallSequence( &ZukanRegisterProc::Sequence_Sub_NickNameYesNo );
    m_seq = SEQ_FADEOUT;
    break;
  case SEQ_FADEOUT:
    this->CallSequence( &ZukanRegisterProc::Sequence_Sub_FadeOut );
    m_seq = SEQ_END;
    break;
  case SEQ_END:
    return true;
  }
  
  return false;
}
/**
 * @brief jbNl[邩
 *
 * @return trueŃV[PXI falseŃV[PX 
 */
bool ZukanRegisterProc::Sequence_Main_NickName( void )
{
  enum
  {
    SEQ_FADEIN,
    SEQ_MAIN,
    SEQ_FADEOUT,
    SEQ_END,
  };
  switch( m_seq )
  {
  case SEQ_FADEIN:
    this->CallSequence( &ZukanRegisterProc::Sequence_Sub_FadeIn );
    m_seq = SEQ_MAIN;
    break;
  case SEQ_MAIN:
    this->CallSequence( &ZukanRegisterProc::Sequence_Sub_NickNameYesNo );
    m_seq = SEQ_FADEOUT;
    break;
  case SEQ_FADEOUT:
    this->CallSequence( &ZukanRegisterProc::Sequence_Sub_FadeOut );
    m_seq = SEQ_END;
    break;
  case SEQ_END:
    return true;
  }
  
  return false;
}
/**
 * @brief {bNXɓ]
 *
 * @return trueŃV[PXI falseŃV[PX 
 */
bool ZukanRegisterProc::Sequence_Main_TransBox( void )
{
  enum
  {
    SEQ_FADEIN,
    SEQ_MAIN,
    SEQ_FADEOUT,
    SEQ_END,
  };
  switch( m_seq )
  {
  case SEQ_FADEIN:
    this->CallSequence( &ZukanRegisterProc::Sequence_Sub_FadeIn );
    m_seq = SEQ_MAIN;
    break;
  case SEQ_MAIN:
    this->CallSequence( &ZukanRegisterProc::Sequence_Sub_TransBox );
    m_seq = SEQ_FADEOUT;
    break;
  case SEQ_FADEOUT:
    this->CallSequence( &ZukanRegisterProc::Sequence_Sub_FadeOut );
    m_seq = SEQ_END;
    break;
  case SEQ_END:
    return true;
  }
  
  return false;
}
/**
 * @brief tF[hC
 *
 * @return trueŃV[PXI falseŃV[PX 
 */
bool ZukanRegisterProc::Sequence_Sub_FadeIn( void )
{
  enum
  {
    FADEIN_START,
    FADEIN_WAIT,
  };
  
  switch( m_sub_seq )
  {
  case FADEIN_START:
    {
      gfl::math::VEC4	col( 0.0f, 0.0f, 0.0f, 1.0f );
      gfl::grp::Fade_ForceOut( gfl::grp::Fade::DISP_DOUBLE, &col );
      gfl::grp::Fade_RequestIn( gfl::grp::Fade::DISP_DOUBLE, app::util::DEFAULT_FADE_SYNC );
    }
    ++m_sub_seq;
    /* fall */
  case FADEIN_WAIT:
    return gfl::grp::Fade_IsEnd();
  }
  
  return false;
}
/**
 * @brief tF[hAEg
 *
 * @return trueŃV[PXI falseŃV[PX 
 */
bool ZukanRegisterProc::Sequence_Sub_FadeOut(void )
{
  enum
  {
    FADEOUT_START,
    FADEOUT_WAIT,
  };

  switch( m_sub_seq )
  {
  case FADEOUT_START:
    gfl::grp::Fade_RequestOut( gfl::grp::Fade::DISP_DOUBLE, gfl::grp::Fade::OUTTYPE_BLACK, app::util::DEFAULT_FADE_SYNC );
    ++m_sub_seq;
    /* fall */
  case FADEOUT_WAIT:
    return gfl::grp::Fade_IsEnd();
  }
  
  return false;
}
/**
 * @brief 
 *
 * @return trueŃV[PXI falseŃV[PX 
 */
bool ZukanRegisterProc::Sequence_Sub_RegisterZukan( void )
{
  enum
  {
    SEQ_ZUKAN_REGISTER,
    SEQ_START_CHANGE_VIEW,
    SEQ_WAIT_CHANGE_VIEW,
    SEQ_END,
  };
  switch( m_sub_seq )
  {
  case SEQ_ZUKAN_REGISTER:
    {
      gfl::ui::Button *button = m_device_manager->GetButton( 0 );
      gfl::ui::TouchPanel *touch_panel = m_device_manager->GetTouchPanel( 0 );
      if( button->IsTrigger( gfl::ui::BUTTON_A )
          || button->IsTrigger( gfl::ui::BUTTON_B )
          || touch_panel->IsTouchTrigger() )
      {
        m_sub_seq = SEQ_START_CHANGE_VIEW;
      }
    }
    break;
  case SEQ_START_CHANGE_VIEW:
    m_view->StartChangeView();
    m_sub_seq = SEQ_WAIT_CHANGE_VIEW;    
    break;
  case SEQ_WAIT_CHANGE_VIEW:
    if( m_view->WaitChangeView() )
    {
      m_sub_seq = SEQ_END;
    }
    break;
  case SEQ_END:
    return true;
  }
  
  return false;
}
/**
 * @brief 
 *
 * @return trueŃV[PXI falseŃV[PX 
 */
bool ZukanRegisterProc::Sequence_Sub_NickNameYesNo( void )
{
  enum
  {
    SEQ_START_MESSAGE,
    SEQ_WAIT_MESSAGE,
    SEQ_START_YESNO,
    SEQ_WAIT_YESNO,
    SEQ_END,
  };
  switch( m_sub_seq )
  {
  case SEQ_START_MESSAGE:
    {
      m_view->GetWordSet()->RegisterPokeMonsName( 0, m_param->capture_pokemon );
    }
    m_view->StartMessage( msg_capreg_01 );
    m_sub_seq = SEQ_WAIT_MESSAGE;
    break;
  case SEQ_WAIT_MESSAGE:
    if( m_view->WaitMessage() )
    {
      m_sub_seq = SEQ_START_YESNO;
    }
    break;
  case SEQ_START_YESNO:
    m_view->StartYesNoMenu();
    m_sub_seq = SEQ_WAIT_YESNO;
    break;
  case SEQ_WAIT_YESNO:
    {
      int result = m_view->WaitYesNoMenu();
      GFL_PRINT( "yes no res %d\n", result );
      if( result != app::tool::YesNoMenu::UPDATE_NONE )
      {
        if( result == app::tool::YesNoMenu::UPDATE_YES )
        {
          m_param->result = RESULT_NAME_YES;
        }
        else
        {
          m_param->result = RESULT_NAME_NO;
        }
        m_sub_seq = SEQ_END;
      }
    }
    break;
  case SEQ_END:
    return true;
  }
  return false;
}
/**
 * @brief 
 *
 * @return trueŃV[PXI falseŃV[PX 
 */
bool ZukanRegisterProc::Sequence_Sub_TransBox( void )
{
  enum
  {
    SEQ_START_MESSAGE,
    SEQ_WAIT_MESSAGE,
    SEQ_END,
  };
  switch( m_sub_seq )
  {
  case SEQ_START_MESSAGE:
    {
      //{bNX֓]
      savedata::BOX* box = mpGameProcManager->GetGameManager()->GetGameData()->GetBox();
      savedata::BoxPokemon * box_poke = mpGameProcManager->GetGameManager()->GetGameData()->GetBoxPokemon();
      u32 tray =  box_poke->PutPokemonEmptyTrayAll( m_param->capture_pokemon, box->GetCurrentTray(), this->GetSystemHeap() );
      gfl::str::StrBuf *trayname = GFL_NEW(this->GetSystemHeap()) gfl::str::StrBuf( box->GetTrayName( tray ), this->GetSystemHeap() );

      m_view->GetWordSet()->RegisterPokeNickName( 0, m_param->capture_pokemon );
      m_view->GetWordSet()->RegisterWord( 1, *trayname, WordSet::GRAMMER_NONE, WordSet::FORM_SINGLE, xy::GetLang() );
      GFL_SAFE_DELETE( trayname );
      m_view->StartMessage( msg_capreg_02 );
    }
    m_sub_seq = SEQ_WAIT_MESSAGE;
    break;
  case SEQ_WAIT_MESSAGE:
    if( m_view->WaitMessage() )
    {
      m_sub_seq = SEQ_END;
    }
    break;
  case SEQ_END:
    return true;
  }
  return false;
}


void ZukanRegisterProc::CallSequence( SubSequence seq )
{
  m_sub_function  = seq;
  m_sub_seq = 0;
}
void ZukanRegisterProc::NextSequence( MainSequence seq )
{
  m_main_function = seq;
  m_seq  = 0;
}
bool ZukanRegisterProc::UpdateSequence( void )
{
  if( m_sub_function == NULL || (this->*m_sub_function)() )
  {
    m_sub_function  = NULL;
    if( (this->*m_main_function)() )
    {
      return true;
    }
  }
  return false;
}

GFL_NAMESPACE_END(captureregister)
GFL_NAMESPACE_END(app)
