//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		app_captureregister_UpperView.cpp
 *	@brief  
 *	@author	Toru=Nagihashi
 *	@date		2012.06.03
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include <arc/arc_def.h>
#include <arc/capture_register_gra.gaix>
#include <arc/message.gaix>
#include "upper.h"
#include "upper_pane.h"
#include "app_captureregister_UpperView.h"

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(captureregister)

UpperView::UpperView( app::util::Heap * heap, gfl::grp::GraphicsSystem * graphic_system, gfl::grp::g2d::LytSys* layout_system, gfl::ui::DeviceManager* device_manager ) : 
  app::ui::UIView( heap ),
  m_device_manager( device_manager )
{
  m_graphicSystem = graphic_system;

  this->CreateLayout( heap, layout_system );
  this->CreateWindow( heap );
}
UpperView::~UpperView()
{
  this->DeleteWindow();
  this->DeleteLayout();
}

void UpperView::Draw()
{
  m_g2dUtil->Draw2D( m_graphicSystem, 0);
}

void UpperView::DrawMaskRect( float mask_alpha )
{
  this->DrawUpperMaskRect( m_graphicSystem, gfl::grp::DISPLAY_UPPER, mask_alpha );
}

void UpperView::CreateLayout( app::util::Heap * heap,gfl::grp::g2d::LytSys* layout_system )
{
  static const app::util::G2DUtil::LYT_RES_DATA LYTRES_TABLE[] =
  {
    {
      ARCID_CAPTUREREGISTER_GRA, GARC_capture_register_gra_upper_LYTDAT_LZ, 0
    }
  };
  static const app::util::G2DUtil::LYTWK_DATA LYTWK_DATA_TABLE[]  =
  {
    {
      0,
      LYTRES_UPPER_CAPTURE_UPPER_BCLYT,
      NULL,
      0,
      0,
      false,
      app::util::G2DUtil::SETUP_UPPER,
      true,
    }
  };

  this->Create2D( heap, layout_system, GFL_NELEMS(LYTWK_DATA_TABLE), LYTRES_TABLE, GFL_NELEMS(LYTRES_TABLE), LYTWK_DATA_TABLE, GFL_NELEMS(LYTWK_DATA_TABLE), GARC_message_capture_register_DAT );
}
void UpperView::DeleteLayout( void )
{
  this->Delete2D();
}

void UpperView::CreateWindow( app::util::Heap * heap )
{
  static const gfl::grp::g2d::LytPaneIndex tbl[] = 
  {
    PANENAME_CAPTURE_UPPER_PANE_TEXT_00_00,
    PANENAME_CAPTURE_UPPER_PANE_TEXT_00_01,
  };
  m_g2dUtil->CreateMessageWindow( m_device_manager, 0, tbl, 0, heap );
}
void UpperView::DeleteWindow( void )
{
  m_g2dUtil->DeleteMessageWindow();
}
GFL_NAMESPACE_END(captureregister)
GFL_NAMESPACE_END(app)
