//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		app_captureregister_Proc.cpp
 *	@brief  og̕ߊl|Po^
 *	@author	Toru=Nagihashi
 *	@date		2012.05.31
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "app/capture_register/app_captureregister_Proc.h"
#include "app_captureregister_ZukanRegisterProc.h"
#include <dll/DllProc.h>

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(captureregister)

//-----------------------------------------------------------------------
// RXgN^EfXgN^
//-----------------------------------------------------------------------
/**
 *	@brief  RXgN^
 *	@param  param 
 */
Proc::Proc( PARAM *param ) :
  gamesystem::GameProc(),
  m_seq( SEQ_START )
{
  m_param = param;

  gfl::heap::HeapBase *parent_heap = gfl::heap::Manager::GetHeapByHeapId(HEAPID_APP);
  m_heap  = GFL_CREATE_HEAP( parent_heap, HEAPID_CAPTUREREGISTER_PERMANENT, SYSTEM_HEAP_SIZE, gfl::heap::HEAP_TYPE_EXP, false );
}

/**
 *	@brief  fXgN^
 */
Proc::~Proc()
{
  gfl::heap::Manager::DeleteHeap( m_heap );
}

//-----------------------------------------------------------------------
// GameProcI[o[Cg
//-----------------------------------------------------------------------
/**
 *	@brief  PROC
 *	@param	Manager vZX}l[W[
 *	@return Result IR[h
 */
gfl::proc::Result Proc::InitFunc(gfl::proc::Manager * manager)
{
  GFL_UNUSED( manager );


  return gfl::proc::RES_FINISH; 
}

/**
 *	@brief  PROCj
 *	@param	Manager vZX}l[W[
 *	@return Result IR[h
 */
gfl::proc::Result Proc::EndFunc(gfl::proc::Manager * manager)
{
  GFL_UNUSED( manager );
  return gfl::proc::RES_FINISH;
}

/**
 *	@brief  PROCC
 *	@param	Manager vZX}l[W[
 *	@return Result IR[h
 */
gfl::proc::Result Proc::UpdateFunc(gfl::proc::Manager * manager)
{
  GFL_UNUSED( manager );
  
  switch( m_seq )
  { 
  case SEQ_CALL_REGISTER:
    {
      ZukanRegisterProc::PARAM *param = static_cast<ZukanRegisterProc::PARAM *>( this->AllocParam( sizeof(ZukanRegisterProc::PARAM) ) );
      param->capture_pokemon  = m_param->capture_pokemon;
      param->mode = ZukanRegisterProc::MODE_ZUKAN_REGISTER;
      //DLLɂ̂ŁAROgȂ
      KUJIRA_PROC_CALL<gamesystem::GameProcManager, ZukanRegisterProc, ZukanRegisterProc::PARAM>( mpGameProcManager, param );
      
      m_seq = SEQ_RET_REGISTER;
    }
    break;
  case SEQ_RET_REGISTER:
    {
      ZukanRegisterProc::PARAM *param = static_cast<ZukanRegisterProc::PARAM *>( m_sub_param );
      if( param->result == ZukanRegisterProc::RESULT_NAME_YES )
      { 
        m_seq = SEQ_CALL_STRINPUT;
      }
      else
      {
        m_seq = SEQ_POKEMON_SET;
      }
      this->FreeParam();
    }
    break;
  case SEQ_CALL_STRINPUT:
    {
      app::strinput::APP_PARAM *param = static_cast<app::strinput::APP_PARAM *>( this->AllocParam( sizeof(app::strinput::APP_PARAM) ) );
      param->type   = app::strinput::TYPE_POKEMON_NAME;
      param->param  = m_param->capture_pokemon->GetMonsNo();
      param->strBuf = GFL_NEW(m_heap) gfl::str::StrBuf( pml::MONS_NAME_BUFFER_SIZE, m_heap );
      param->changeFlag = false;
      dll::CallStrInputProc( mpGameProcManager, param );
      m_seq = SEQ_RET_STRINPUT;
    }
    break;
  case SEQ_RET_STRINPUT:
    {
      app::strinput::APP_PARAM *param = static_cast<app::strinput::APP_PARAM *>( m_sub_param );
      //O
      m_param->capture_pokemon->SetNickName( param->strBuf );
      GFL_SAFE_DELETE( param->strBuf );
      this->FreeParam();
    }
    m_seq = SEQ_POKEMON_SET;
    break;
    
  case SEQ_POKEMON_SET:
    {
      pml::PokeParty  *party = mpGameProcManager->GetGameManager()->GetGameData()->GetPlayerParty();
      if( party->IsFull() )
      {
        //BOXɓꍇ̓bZ[Wo
        //BOXւ͎̃vZX̒ł
        m_seq = SEQ_CALL_BOX_TRANS;
      }
      else
      {
        //莝ɓȂΎւȂ
        //莝ɂ
        pml::pokepara::PokemonParam * poke_param = GFL_NEW( m_heap ) pml::pokepara::PokemonParam( m_heap, *m_param->capture_pokemon );
        party->AddMember(*poke_param);
        GFL_SAFE_DELETE( poke_param );
        m_seq = SEQ_END;
      }
    }
    break;
    
  case SEQ_CALL_BOX_TRANS:
    {
      ZukanRegisterProc::PARAM *param = static_cast<ZukanRegisterProc::PARAM *>( this->AllocParam( sizeof(ZukanRegisterProc::PARAM) ) );
      param->capture_pokemon  = m_param->capture_pokemon;
      param->mode = ZukanRegisterProc::MODE_BOX_TRANS;
      KUJIRA_PROC_CALL<gamesystem::GameProcManager, ZukanRegisterProc, ZukanRegisterProc::PARAM>( mpGameProcManager, param );
      
      m_seq = SEQ_RET_BOX_TRANS;
    }
    break;
  case SEQ_RET_BOX_TRANS:
    this->FreeParam();
    m_seq = SEQ_END;
    break;
  case SEQ_END:
    return gfl::proc::RES_FINISH;
  }

  return gfl::proc::RES_CONTINUE;
}

/**
 *	@brief  PROC`
 *	@param	Manager vZX}l[W[
 *	@return Result IR[h
 */
void Proc::DrawFunc(gfl::proc::Manager * manager)
{
  GFL_UNUSED( manager );
}

//-----------------------------------------------------------------------
// private
//-----------------------------------------------------------------------
/**
 * @brief Tup[^p[N
 *
 * @param size TCY
 *
 * @return Tup[^p[N
 */
void * Proc::AllocParam( size_t size )
{
  void *param = GflHeapAllocMemory( m_heap, size );
  m_sub_param = param;
  return param;
}
/**
 * @brief Tup[^p[N
 */
void Proc::FreeParam( void )
{
  GflHeapFreeMemory( m_sub_param );
  m_sub_param = NULL;
}


GFL_NAMESPACE_END(captureregister)
GFL_NAMESPACE_END(app)
