//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		app_captureregister_ParentView.cpp
 *	@brief  eView
 *	@author	Toru=Nagihashi
 *	@date		2012.06.01
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "app_captureregister_ParentView.h"
#include "app_captureregister_UpperView.h"
#include "app_captureregister_ZukanUpperView.h"

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(captureregister)

const gfl::math::VEC3 ParentView::POKE_MODE_NORMAL_POSISION( 0.f, -40.f, -401.0f );

//-----------------------------------------------------------------------
// RXgN^EfXgN^
//-----------------------------------------------------------------------
/**
 * @brief RXgN^
 *
 * @param heap  q[v
 * @param graphics  OtBbNX
 * @param data_manager  f[^}l[W[
 * @param type  ʃ^Cv
 * @param \|P
 */
ParentView::ParentView( app::util::Heap * heap, gfl::ui::DeviceManager* device_manager, app::zukan::Graphics *graphics, app::zukan::DataManager *data_manager, ParentView::UpperViewType type, const poke_tool::SimpleParam *param ):
  app::ui::UIView( heap ),
  m_heap( heap ),
  m_device_manager(device_manager),
  m_poke_model_trans(),
  m_graphics( graphics )
{
  
  m_graphicSystem = graphics->GetGraphicsSystem();

  //ʂ̓[hɂēǂݑւ
  this->CreateUpperView( type, param, data_manager );
  
  //ʍ쐬
  m_lower_view  = GFL_NEW(m_heap->GetSystemHeap()) LowerView( heap, m_graphicSystem, graphics->GetLayoutSystem(), device_manager );
  this->AddSubView( m_lower_view );
  
  //|Pf
  m_graphics->ChangePokeModel( param );
  if( type == UPPER_VIEW_NORMAL )
  {
    m_graphics->GetPokeModel()->SetPosition( &POKE_MODE_NORMAL_POSISION );
  }
}
/**
 * @brief fXgN^
 */
ParentView::~ParentView()
{
  m_lower_view->RemoveFromSuperView();
  GFL_SAFE_DELETE( m_lower_view );
  
  m_upper_view->RemoveFromSuperView();
  GFL_SAFE_DELETE( m_upper_view );
}
//-----------------------------------------------------------------------
// VXe
//-----------------------------------------------------------------------
/**
 * @brief `
 */
void ParentView::Draw( void )
{
  if( m_is_draw_mask )
  {
    m_upper_interface->DrawMaskRect( m_mask_alpha );
  }
}
//-----------------------------------------------------------------------
// 
//-----------------------------------------------------------------------
/**
 * @brief ʃr[؂ւ
 */
void ParentView::StartChangeView( void )
{
  m_seq     = 0;
  m_counter = 0;
  m_is_draw_mask  = true;
  m_mask_alpha  = 0.0f;
  
  m_poke_model_trans.Restart( app::zukan::Graphics::POKE_MODEL_POSITION,
                              POKE_MODE_NORMAL_POSISION,
                              UPPER_FADE_FRAME_MAX, 
                              m_heap->GetSystemHeap() );
}
/**
 * @brief ʃr[؂ւҋ@
 *
 * @return true؂ւI false؂ւ
 */
bool ParentView::WaitChangeView( void )
{
  enum
  {
    SEQ_FADEOUT_START,
    SEQ_FADEOUT_WAIT,
    SEQ_FADEIN_START,
    SEQ_FADEIN_WAIT,
  };
  
  switch( m_seq )
  {
  case SEQ_FADEOUT_START:
    {
      m_mask_alpha  = 1.0f * m_counter / UPPER_FADE_FRAME_MAX;
      
      gfl::math::VEC3 now = m_poke_model_trans.Update();
      m_graphics->GetPokeModel()->SetPosition( &now );
      
      if( m_counter++ >= UPPER_FADE_FRAME_MAX && m_poke_model_trans.IsEnd() )
      {
        m_mask_alpha  = 1.0f;
        m_counter     = UPPER_FADE_FRAME_MAX;
        m_seq = SEQ_FADEOUT_WAIT;
      }
    }
    break;
  case SEQ_FADEOUT_WAIT:
    
    m_upper_view->RemoveFromSuperView();
    GFL_SAFE_DELETE( m_upper_view );
    this->CreateUpperView( UPPER_VIEW_NORMAL, NULL, NULL );
    m_seq = SEQ_FADEIN_START;
    break;
  case SEQ_FADEIN_START:
    m_mask_alpha  = 1.0f * m_counter / UPPER_FADE_FRAME_MAX;
    
    if( m_counter-- < 0 )
    {
      m_mask_alpha  = 0.0f;
      
      m_is_draw_mask  = false;
      m_seq = SEQ_FADEIN_WAIT;
    }
    break;
  case SEQ_FADEIN_WAIT:
    return true;
  }
  return false;
}
/**
 * @brief Po^擾
 *
 * @retval  Po^
 */
WordSet *ParentView::GetWordSet( void ) const
{
  return m_upper_view->GetG2DUtil()->GetWordSet();
}
/**
 * @brief bZ[WJn
 *
 * @param str_id ԍ
 */
void ParentView::StartMessage( u32 str_id )
{
  this->SetMessage( m_upper_view, str_id );
}
/**
 * @brief bZ[Wҋ@
 *
 * @return truebZ[WI falsebZ[W
 */
bool ParentView::WaitMessage( void )
{
  gfl::str::StrWin::Result result = m_upper_view->GetG2DUtil()->PrintMessage();
  return result == gfl::str::StrWin::RES_DONE;
}

/**
 * @brief ͂AIJn
 */
void ParentView::StartYesNoMenu( void )
{
  m_lower_view->StartYesNoMenu();
}
/**
 * @brief ͂AI
 *
 * @return ʃR[h
 */
int ParentView::WaitYesNoMenu( void )
{
  return m_lower_view->WaitYesNoMenu();
}

//-----------------------------------------------------------------------
// Private
//-----------------------------------------------------------------------
/**
 * @brief ʃr[쐬
 *
 * @param type  쐬r[
 */
void ParentView::CreateUpperView( UpperViewType type, const poke_tool::SimpleParam *param, app::zukan::DataManager *data_manager )
{
  //ʂ̓[hɂēǂݑւ
  if( type == UPPER_VIEW_ZUKAN )
  {
    ZukanUpperView  *view = GFL_NEW(m_heap->GetSystemHeap() ) ZukanUpperView( m_heap, m_graphics, data_manager );
    view->WriteHeaderForCaptureRegister();
    view->WritePokemonDetail( param );
    m_upper_view  = view;
    m_upper_interface = view;
  }
  else 
  {
    UpperView *view = GFL_NEW(m_heap->GetSystemHeap()) UpperView( m_heap, m_graphicSystem, m_graphics->GetLayoutSystem(), m_device_manager );
    m_upper_view  = view;
    m_upper_interface = view;
  }
  this->AddSubView( m_upper_view );
}

/**
 * @brief r[ɃbZ[W\
 * 
 * @param view    \r[
 * @param str_id  ID
 * 
 * @note  w̃r[̓bZ[WEBhEĂȂ΂Ȃ
 */
void ParentView::SetMessage( app::ui::UIView  *view, u32 str_id )
{
  gfl::str::StrBuf *strbuf = view->GetG2DUtil()->GetTmepStrBuf( 1 );
  view->GetG2DUtil()->GetStringExpand( strbuf, str_id );
  view->GetG2DUtil()->SetMessage( strbuf );
}
GFL_NAMESPACE_END(captureregister)
GFL_NAMESPACE_END(app)
