//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		app_captureregister_LowerView.cpp
 *	@brief
 *	@author	Toru=Nagihashi
 *	@date		2012.06.03
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include <arc/arc_def.h>
#include <arc/capture_register_gra.gaix>
#include "lower.h"
#include <arc/message.gaix>
#include "app_captureregister_LowerView.h"

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(captureregister)

LowerView::LowerView( app::util::Heap * heap, gfl::grp::GraphicsSystem * graphic_system, gfl::grp::g2d::LytSys* layout_system, gfl::ui::DeviceManager* device_manager ) : 
  app::ui::UIView( heap ),
  m_heap( heap ),
  m_device_manager( device_manager ),
  m_yesno_menu( NULL )
{
  m_graphicSystem = graphic_system;
  this->CreateLayout( heap, layout_system );
}
LowerView::~LowerView()
{
  this->DeleteLayout();
}

void LowerView::Draw()
{
  m_g2dUtil->Draw2D( m_graphicSystem, 0);
  
  if( m_yesno_menu )
  {
    m_yesno_menu->Draw();
  }
}



//---------------------------------------------------------------------
// ͂Aj[̑
//---------------------------------------------------------------------
/**
 *  @brief ͂Aj[Jn
 */
void LowerView::StartYesNoMenu( void )
{
  GFL_ASSERT(m_yesno_menu==NULL);
  m_yesno_menu  = GFL_NEW( m_heap->GetSystemHeap() ) app::tool::YesNoMenu( m_heap->GetSystemHeap(), m_heap->GetDeviceHeap(), m_device_manager, m_graphicSystem, m_g2dUtil->GetLayoutSystem(), gfl::grp::DISPLAY_LOWER, app::tool::YesNoMenu::DEFAULT_PX, -60 );
}

/**
 *  @brief ͂A҂
 *  @retval app::tool::YesNoMenu::UPDATE_YES  ͂I
 *  @retval app::tool::YesNoMenu::UPDATE_NO   I
 *  @retval app::tool::YesNoMenu::UPDATE_NONE 
 */
int LowerView::WaitYesNoMenu( void )
{
  int ret = m_yesno_menu->Update();

  if( ret != app::tool::YesNoMenu::UPDATE_NONE )
  {
    GFL_SAFE_DELETE( m_yesno_menu );
  }
  return ret;
}

void LowerView::CreateLayout( app::util::Heap * heap,gfl::grp::g2d::LytSys* layout_system )
{
  static const app::util::G2DUtil::LYT_RES_DATA LYTRES_TABLE[] =
  {
    {
      ARCID_CAPTUREREGISTER_GRA, GARC_capture_register_gra_lower_LYTDAT_LZ, 0
    }
  };
  static const app::util::G2DUtil::LYTWK_DATA LYTWK_DATA_TABLE[]  =
  {
    {
      0,
      LYTRES_LOWER_CAPTURE_LOWER_BCLYT,
      NULL,
      0,
      0,
      false,
      app::util::G2DUtil::SETUP_LOWER,
      true,
    }
  };

  this->Create2D( heap, layout_system, GFL_NELEMS(LYTWK_DATA_TABLE), LYTRES_TABLE, GFL_NELEMS(LYTRES_TABLE), LYTWK_DATA_TABLE, GFL_NELEMS(LYTWK_DATA_TABLE), GARC_message_capture_register_DAT );
}
void LowerView::DeleteLayout( void )
{
  this->Delete2D();
}

GFL_NAMESPACE_END(captureregister)
GFL_NAMESPACE_END(app)
