//============================================================================
/**
 *
 *	@file		trainer_func.inc
 *	@brief  g[i[n֐
 *	@author hosaka genya
 *	@data		2011.11.15
 *
 */
//============================================================================
  
//@todo g[i[bZ[W
stock TrainerMsgSet( tr_id, msgid, objid )
{ 
  UNUSED( tr_id + msgid + objid );
}
//@todo 
stock TrainerTalkTypeGetStart( tr_id )
{ 
  return tr_id == 0;
}
//@todo g[i[bZ[W
stock TrainerTalkTypeGetAfter( tr_id )
{ 
  return tr_id == 0;
}
//@todo g[i[bZ[W
stock TrainerTalkTypeGetNG( tr_id )
{ 
  return tr_id == 0;
}
//@todo
stock EyeTrainerMoveTypeGet()
{ 
  return SCR_EYE_TR_TYPE_SINGLE;
}
//@todo 
stock TrainerItemGet( tr_id )
{ 
  return tr_id != 0;
}

// g[i[Fbog
stock TrainerTalkBattle()
{ 
  TalkMdlStart();
  
  //@todo ݂̃Aj`FbN
  //_CALL sub_trainer_talk_battle_hide_pulloff

  //g[i[ID擾
  new tr_id = TrainerIDGet( g_mode );
  
  //łɏĂg[i[`FbNāA퓬̉b
  if( TrainerFlagGet( tr_id ) )
  {
    new sptype = TrainerSPTypeGet( tr_id );
    
    switch( sptype )
    {
      case SCR_TR_SPTYPE_RECOVER:
        SubTrainerTalkAfterRecover( tr_id );
      case SCR_TR_SPTYPE_ITEM:
        SubTrainerTalkAfterItemAfter( tr_id );
      default:
        SubTrainerTalkAfterNormal( tr_id );
    }
  }
  else 
  {
    //g[i[^Cv擾(SCR_TR_BTL_RULE_`j
    new rule = TrainerBattleRuleGet( tr_id );
    //C킦|P莝ɂ邩A擾
    new member = PokePartyGetCount( POKE_COUNT_TYPE_BATTLE_ENABLE );
    
    if( rule == SCR_TR_BTL_RULE_DOUBLE && member < 2  )
    {
      //_uogŎ莝ȂꍇANGbZ[W
      SubTrainerTalk2vs2NG( tr_id );
    }
    else if( rule == SCR_TR_BTL_RULE_TRIPLE && member < 3 )
    {
      //gvogŎ莝ȂꍇANGbZ[W
      SubTrainerTalk3vs3NG( tr_id );
    }
    else if( rule == SCR_TR_BTL_RULE_ROTATION && member < 3 )
    {
      //[e[VogŎ莝ȂꍇANGbZ[W
      SubTrainerTalk3vs3NG( tr_id );
    }
    else 
    {
      // ȊȌꍇA퓬
      SubTrainerTalkBattle( tr_id );
    }
    
    //g[i[̏ꍇA퓬チbZ[W
    new sptype = TrainerSPTypeGet( tr_id );
    switch( sptype )
    {
      case SCR_TR_SPTYPE_RECOVER:
        SubTrainerTalkAfterRecover( tr_id );
      case SCR_TR_SPTYPE_ITEM:
        SubTrainerTalkAfterItemBefore( tr_id );
    }
  }
  
  SubTrainerBattleAfter( tr_id );
  
  TalkMdlEnd();
}

// g[i[Fog
stock TrainerMoveBattle()
{ 
  new movetype = EyeTrainerMoveTypeGet();
  
  switch( movetype )
  {
    case SCR_EYE_TR_TYPE_SINGLE:
      MoveTrainerTypeSingle();
    case SCR_EYE_TR_TYPE_DOUBLE:
      MoveTrainerTypeDouble();
    case SCR_EYE_TR_TYPE_TAG:
      MoveTrainerTypeTag();
  }
  
  new tr_id = GetBTLTrainerTrID( SCR_EYE_TR_0 );
  SubTrainerBattleAfter( tr_id );
}


stock MoveTrainerTypeSingle()
{ 
  new tr_id = GetBTLTrainerTrID( SCR_EYE_TR_0 );
  new obj_id = GetBTLTrainerObjID( SCR_EYE_TR_0 );
  
	// ȃZbg
  new bgm = GetBTLTrainerBgm( tr_id );
	BGMTrainerEyeBGM( bgm );
	
  // uIv
	new anm_ary[] = 
	{
		AC_ICON_EXCLAMATION, DIR_NOT, 1,
	};
	MdlAnime( obj_id, anm_ary ); 
	MdlAnimeWait( obj_id );

	PlayerTurnToObj( obj_id );
	new gx = PlayerGetFrontGridPosX();
	new gy = PlayerGetFrontGridPosY();
	new gz = PlayerGetFrontGridPosZ();
	MdlAcmdInit( obj_id );
	MdlAcmdMakeMove( AC_WALK_DEF, gx, gy, gz );
	MdlAcmdSetEnd();
	MdlAnimeWait();
  
  // ړIAb
  TrainerMsgSet( tr_id, TRMSG_FIGHT_START, obj_id );
  MsgClose();
  
  CallTrainerBattle( tr_id, 0, SC_BATTLE_FLG_NULL ); 
  
  if( CheckTrainerLose() )
  {
    TrainerLose();
  }
  else 
  {
    TrainerWin( tr_id );
  }
}

stock MoveTrainerTypeDouble()
{ 
  new tr_id = GetBTLTrainerTrID( SCR_EYE_TR_0 );
  new tr_id2 = GetBTLTrainerTrID( SCR_EYE_TR_1 );
  
	// ȃZbg
  new bgm = GetBTLTrainerBgm( tr_id );
	BGMTrainerEyeBGM( bgm );

  new obj_id = GetBTLTrainerObjID( SCR_EYE_TR_0 );
  new obj_id2 = GetBTLTrainerObjID( SCR_EYE_TR_1 );

  // ړ
  
  // uIv
	new anm_ary[] = 
	{
		AC_ICON_EXCLAMATION, DIR_NOT, 1,
	};
	MdlAnime( obj_id, anm_ary ); 
	MdlAnime( obj_id2, anm_ary ); 
	MdlAnimeWait();

	PlayerTurnToObj( obj_id );
	new gx = PlayerGetFrontGridPosX();
	new gy = PlayerGetFrontGridPosY();
	new gz = PlayerGetFrontGridPosZ();
	MdlAcmdInit( obj_id );
	MdlAcmdMakeMove( AC_WALK_DEF, gx, gy, gz );
	MdlAcmdSetEnd();
	MdlAcmdInit( obj_id2 );
	MdlAcmdMakeMove( AC_WALK_DEF, gx, gy, gz );
	MdlAcmdSetEnd();
  
	MdlAnimeWait();
  

  // ړIAb
  TrainerMsgSet( tr_id, TRMSG_FIGHT_START_1, obj_id );
  MsgClose();
  
  TrainerMsgSet( tr_id2, TRMSG_FIGHT_START_2, obj_id2 );
  MsgClose();
  
  // TRID_01 == TRID_02 ̂ƂA_uogɂȂ
  CallTrainerBattle( tr_id, tr_id2, SC_BATTLE_FLG_NULL ); 
  
  if( CheckTrainerLose() )
  {
    TrainerLose();
  }
  else 
  {
    TrainerWin( tr_id, tr_id2 );
  }
}

stock MoveTrainerTypeTag()
{ 
  //@todo Ή
#if 0
  DEFINE_LOCAL  LWK_TRID_01
  DEFINE_LOCAL  LWK_TRID_02
  DEFINE_LOCAL  LWK_TR_OBJID

  _EYE_TRAINER_ID_GET( SCR_EYE_TR_0, LWK_TRID_01 )
  _EYE_TRAINER_ID_GET( SCR_EYE_TR_1, LWK_TRID_02 )

  //ȃZbg
  _TRAINER_BGM_SET( LWK_TRID_01 )

  _EYE_TRAINER_MOVE_SET( SCR_EYE_TR_0 )        //g[i[ړĂяo
  _EYE_TRAINER_MOVE()                          //ړI҂

  //ړIAb
  _EYE_TRAINER_OBJ_ID_GET( SCR_EYE_TR_0, LWK_TR_OBJID )
  _TRAINER_MSG_SET( LWK_TRID_01, TRMSG_FIGHT_START_1, LWK_TR_OBJID )
  _BALLOONWIN_CLOSE()

  //ȃZbg
  _TRAINER_BGM_SET( LWK_TRID_02 )

  _EYE_TRAINER_MOVE_SET( SCR_EYE_TR_1 )        //g[i[ړĂяo
  _EYE_TRAINER_MOVE()                          //ړI҂

  //ړIAb
  _EYE_TRAINER_OBJ_ID_GET( SCR_EYE_TR_1, LWK_TR_OBJID )
  _TRAINER_MSG_SET( LWK_TRID_02, TRMSG_FIGHT_START_2, LWK_TR_OBJID )
  _BALLOONWIN_CLOSE()

  _TRAINER_BTL_SET( LWK_TRID_01, LWK_TRID_02 )
  _TRAINER_LOSE_CHECK( SCWK_ANSWER )
  IF $SCWK_ANSWER == SCR_BATTLE_RESULT_WIN THEN
    _TRAINER_WIN()
  ELSE
    _TRAINER_LOSE()
  ENDIF

  //g[i[tOZbg
  _TRAINER_FLAG_SET( LWK_TRID_01 )
  _TRAINER_FLAG_SET( LWK_TRID_02 )

  _RET

#endif

}

//====================================================================
// Tu[`
//====================================================================

stock SubTrainerTalkAfterRecover( tr_id )
{ 
  TrainerMsgSet( tr_id, TRMSG_FIGHT_AFTER_RECOVER_BE, EventWorkGet( SCWK_TARGET_OBJID ) );
  MsgClose();

  FadeRequestOut( OUTTYPE_BLACK );
  FadeWait();
  
  PokePartyRecoverAll();
  MEPlayWait( STRM_ME_KAIFUKU ); // @todo ܂ SEQ_ME_ASA 
  
  FadeRequestIn();
  FadeWait();
  
  TrainerMsgSet( tr_id, TRMSG_FIGHT_AFTER_RECOVER_AF, EventWorkGet( SCWK_TARGET_OBJID ) );
  LastKeyWait();
  MsgClose();
}

stock SubTrainerTalkAfterItemBefore( tr_id )
{ 
  TrainerMsgSet( tr_id, TRMSG_FIGHT_AFTER_GIFTITEM_BE, EventWorkGet( SCWK_TARGET_OBJID ) );
  MsgClose();
  
  new item_no = TrainerItemGet( tr_id );
  ItemEvent( item_no, 1, true );
  
  TrainerMsgSet( tr_id, TRMSG_FIGHT_AFTER_GIFTITEM_AF, EventWorkGet( SCWK_TARGET_OBJID ) );
  LastKeyWait();
  MsgClose();
}

stock SubTrainerTalkAfterItemAfter( tr_id )
{ 
  TrainerMsgSet( tr_id, TRMSG_FIGHT_AFTER_GIFTITEM_AF, EventWorkGet( SCWK_TARGET_OBJID ) );
  LastKeyWait();
  MsgClose();
}

stock SubTrainerTalkAfterNormal( tr_id )
{ 
  new msgid = TrainerTalkTypeGetAfter( tr_id );
  TrainerMsgSet( tr_id, msgid, EventWorkGet( SCWK_TARGET_OBJID ) );
  LastKeyWait();
  MsgClose();
}

stock SubTrainerTalk2vs2NG( tr_id )
{ 
  new msgid = TrainerTalkTypeGetNG( tr_id );
  TrainerMsgSet( tr_id, msgid, EventWorkGet( SCWK_TARGET_OBJID ) );
  LastKeyWait();
  MsgClose();
}

stock SubTrainerTalk3vs3NG( tr_id )
{ 
  new msgid = TrainerTalkTypeGetNG( tr_id );
  TrainerMsgSet( tr_id, msgid, EventWorkGet( SCWK_TARGET_OBJID ) );
  LastKeyWait();
  MsgClose();
}
      
stock SubTrainerTalkBattle( tr_id )
{ 
	// ȃZbg
  new bgm = GetBTLTrainerBgm( tr_id );
	BGMTrainerEyeBGM( bgm );
  
  new msgid = TrainerTalkTypeGetStart( tr_id );
  TrainerMsgSet( tr_id, msgid, EventWorkGet( SCWK_TARGET_OBJID ) );
  MsgClose();
  
  CallTrainerBattle( tr_id, 0, SC_BATTLE_FLG_NULL ); //@todo XJCog̎dĺH
	Suspend();  // ogÎ҂B
  
  if( CheckTrainerLose() )
  {
    TrainerLose();
  }
  else 
  {
    TrainerWin( tr_id );
  }
}

stock SubTrainerBattleAfter( tr_id )
{ 
  //g[i[̏ꍇA퓬チbZ[W
  new sptype = TrainerSPTypeGet( tr_id );
  switch( sptype )
  {
    case SCR_TR_SPTYPE_RECOVER:
      SubTrainerTalkAfterRecover( tr_id );
    case SCR_TR_SPTYPE_ITEM:
      SubTrainerTalkAfterItemBefore( tr_id );
  }
}


#if 0
//--------------------------------------------------------------------
//݂̃Aj
//--------------------------------------------------------------------
sub_trainer_talk_battle_hide_pulloff:
{
  //݂̃Aj`FbN
  _MOVE_CODE_GET( SCWK_ANSWER, SCWK_TARGET_OBJID ) //߂l擾[NAbΏOBJID
  
  SWITCH $SCWK_ANSWER
  CASE MV_HIDE_SNOW THEN
    _CALL sub_trainer_talk_battle_hide_pulloff_change
  CASE MV_HIDE_SAND THEN
    _CALL sub_trainer_talk_battle_hide_pulloff_change
  CASE MV_HIDE_GRND THEN
    _CALL sub_trainer_talk_battle_hide_pulloff_change
  CASE MV_HIDE_KUSA THEN
    _CALL sub_trainer_talk_battle_hide_pulloff_change
  ENDSWITCH //MOVE_CODE
}
_RET
#endif
