
//=============================================================================
/**
 * @file   CameraModeReset.h
 * @brief  JZbg[hNXwb_
 * @author rc N
 * @date   2012.06.01
 */
//=============================================================================

#ifndef __CAMERA_MODE_RESET_H__
#define __CAMERA_MODE_RESET_H__

#include "CameraElement.h"
#include "CameraInfo.h"
#include "CameraTarget.h"
#include "CameraDefaultAngle.h"
#include "CameraDistToLookAt.h"

namespace field
{
  //-----------------------------------------------------------------------------
  /**
   * @brief Zbg[h̐sNX
   */
  //-----------------------------------------------------------------------------
  class CCameraModeReset
  {
  public:
    CCameraModeReset() { return ; } ///< RXgN^
    ECameraBehindMode GetMode() const { return CAMERA_BEHIND_MODE_RESET; } ///< ΏۂƂȂ郂[h擾

    //-----------------------------------------------------------------------------
    /**
     * @brief Ot[
     *
     * @param pCamera        J
     * @param inTarget       ^[Qbg
     * @param inDefaultAngle ftHgpx
     * @param inDistToLookAt _E_ԋ
     * @param eMode          [h
     */
    //-----------------------------------------------------------------------------
    void PreUpdate(CCameraInfo* pCamera, const CCameraTarget& inTarget, const CCameraDefaultAngle& inDefaultAngle, const CCameraDistToLookAt& inDistToLookAt, const ECameraBehindMode eMode)
    {  if( eMode == GetMode() ) pCamera->Init(inTarget.GetCenterPosition(), inDefaultAngle.GetYaw(), inDefaultAngle.GetPitch(), inDistToLookAt.GetHopeDistToLookAt()); }
  };

} // namespace field

#endif // __CAMERA_MODE_RESET_H__

/*  EOF  */





