
//=============================================================================
/**
 * @file   CameraModeNormal.cpp
 * @brief  Jʏ탂[hNX
 * @author rc N
 * @date   2012.06.04
 */
//=============================================================================

#include "CameraModeNormal.h"

namespace field
{
  //-----------------------------------------------------------------------------
  // RXgN^
  //-----------------------------------------------------------------------------
  CCameraModeNormal::CCameraModeNormal()
  {
    m_inYaw.SetRadianInterpolateFlag(true);
    m_inYaw.SetEpsilon(NEARLY_EQUAL_EPSILON_RADIAN);
    m_inYaw.SetParam(7.0f, GFL_MATH_DEG_TO_RAD(180.0f));

    m_inPitch.SetRadianInterpolateFlag(true);
    m_inPitch.SetEpsilon(NEARLY_EQUAL_EPSILON_RADIAN);
  }

  //-----------------------------------------------------------------------------
  // t[
  //-----------------------------------------------------------------------------
  void CCameraModeNormal::Update(CCameraInfo* pCamera, const CCameraDefaultAngle& inDefaultAngle, const ECameraBehindMode eMode, const float fDiffTime)
  {
    if( eMode != GetMode() )
    {
      m_inYaw  .Reset(pCamera->m_fYaw);
      m_inPitch.Reset(pCamera->m_fPitch);
    }
    else
    {
      // m_inYaw.outUpdate(pCamera->m_fYaw);
      // m_inPitch.outUpdate(pCamera->m_fPitch);

      bool bIsUpdate = false;

      const float fHopeYaw = inDefaultAngle.GetYaw();
      if( m_inYaw.IsReachHopeValue(fHopeYaw) == false )
      {
        m_inYaw.Update(fHopeYaw, fDiffTime);
        bIsUpdate = true;
      }

      const float fHopePitch = inDefaultAngle.GetPitch();
      if( m_inPitch.IsReachHopeValue(fHopePitch) == false )
      {
        m_inPitch.Update(fHopePitch, fDiffTime);
        bIsUpdate = true;
      }

      if( bIsUpdate ) pCamera->UpdatePosiDirByYawPitch(m_inYaw.GetValue(), m_inPitch.GetValue());
    }
  }

} // namespace field

/*  EOF  */





