//============================================================================================
/**
 * @file		PssAcquaintanceSaveData.cpp
 * @brief		PSSCɓo^f[^Ǘ
 *
 * namespace	savedata::
 */
//============================================================================================
#include <netapp/pss/PssPersonalData.h>
#include <savedata/PssAcquaintanceSaveData.h>


namespace savedata {

namespace pss_acquaintance
{
  //------------------------------------------------------------------------------------------
  /**
  * @brief	Z[uf[^̈ւ̂Cɓo^(O[o֐)
  *
  * @param	o^ΏۂƂȂthL[
  *
  * @return  ǉꂽȂtrueA󂫂ȂEf[^łɑ݂ꍇfalseԋp
  */
  //------------------------------------------------------------------------------------------
  bool  AddPersonalToPssAcquaintanceSaveData( const gflnet::friends::FriendKey& friendKey )
  {
    gamesystem::GameManager*             gameManager      = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
    gamesystem::GameData*                gameData         = gameManager->GetGameData();
    savedata::PssPersonalSaveData*       acquaintanceData = gameData->GetPssAcquaintanceData();
    GFL_ASSERT( acquaintanceData );
    netapp::pss::PssPersonalDataManager* pssPersonalMgr = gameManager->GetPssPersonalDataManager();
    netapp::pss::PssPersonalData*        targetPerson   = pssPersonalMgr->GetPersonalData( friendKey );
    GFL_ASSERT( targetPerson );

    return acquaintanceData->AddPersonalData( targetPerson );
  }


  //------------------------------------------------------------------------------------------
  /**
  * @brief	Z[uf[^̈̂Cɓ폜(O[o֐)
  *
  * @param	폜ΏۂƂȂthL[
  *
  * @return  폜ꂽȂtrueA폜s̏ꍇfalseԋp
  */
  //------------------------------------------------------------------------------------------
  bool RemovePersonalFromPssAcquaintanceSaveData( const gflnet::friends::FriendKey& friendKey )
  {
    gamesystem::GameManager*        gameManager      = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
    gamesystem::GameData*           gameData         = gameManager->GetGameData();
    savedata::PssPersonalSaveData*  acquaintanceData = gameData->GetPssAcquaintanceData();
    GFL_ASSERT( acquaintanceData );

    return acquaintanceData->RemovePersonalData( friendKey );
  }


  //------------------------------------------------------------------------------------------
  /**
  * @brief	Z[uf[^̈̂CɓXV(O[o֐)
  *
  * @param	XVΏۂƂȂthL[
  *
  * @return  XVꂽȂtrueAXVɎsꍇfalseԋp
  */
  //------------------------------------------------------------------------------------------
  bool  UpdatePersonalToPssAcquaintanceSaveData( const gflnet::friends::FriendKey& friendKey )
  {
    gamesystem::GameManager*             gameManager      = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
    gamesystem::GameData*                gameData         = gameManager->GetGameData();
    savedata::PssPersonalSaveData*       acquaintanceData = gameData->GetPssAcquaintanceData();
    GFL_ASSERT( acquaintanceData );
    netapp::pss::PssPersonalDataManager* pssPersonalMgr = gameManager->GetPssPersonalDataManager();
    netapp::pss::PssPersonalData*        targetPerson   = pssPersonalMgr->GetPersonalData( friendKey );
    GFL_ASSERT( targetPerson );

    return acquaintanceData->UpdatePersonalData( targetPerson );
  }


  //------------------------------------------------------------------------------------------
  /**
  * @brief  Z[uf[^̈̂Cɓ񂪐ɒBĂ邩(O[o֐)
  *
  * @param  none
  *
  * @return  ɒBĂȂtrueA󂫂Ȃfalseԋp
  */
  //------------------------------------------------------------------------------------------
  bool IsFullPssAcquaintanceSaveData( void )
  {
    gamesystem::GameManager*        gameManager      = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
    gamesystem::GameData*           gameData         = gameManager->GetGameData();
    savedata::PssPersonalSaveData*  acquaintanceData = gameData->GetPssAcquaintanceData();
    GFL_ASSERT( acquaintanceData );

    return acquaintanceData->IsFull();
  }


  //------------------------------------------------------------------------------------------
  /**
  * @brief  wthL[̃[U[Z[uf[^̈̂Cɓɑ݂邩iO[o֐j
  *
  * @param  none
  *
  * @return  ɒBĂȂtrueA󂫂Ȃfalseԋp
  */
  //------------------------------------------------------------------------------------------
  bool IsExistPssAcquaintanceSaveData( const gflnet::friends::FriendKey& friendKey )
  {
    gamesystem::GameManager*        gameManager  = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
    gamesystem::GameData*           gameData     = gameManager->GetGameData();
    savedata::PssPersonalSaveData*  acquaintanceData = gameData->GetPssAcquaintanceData();

    return (acquaintanceData->GetPersonalData(friendKey) != NULL);
  }

} //pss_acquaintance









}		// savedata

