//============================================================================================
/**
 * @file		PssFriendSaveData.cpp
 * @brief		PSSCɓo^f[^Ǘ
 *
 * namespace	savedata::
 */
//============================================================================================
#include <netapp/pss/PssPersonalData.h>
#include <savedata/PssFriendSaveData.h>


namespace savedata {

namespace pss_friend
{
  //------------------------------------------------------------------------------------------
  /**
  * @brief	Z[uf[^̈ւ̂Ƃo^(O[o֐)
  *
  * @param	o^ΏۂƂȂthL[
  *
  * @return  ǉꂽȂtrueA󂫂ȂEf[^łɑ݂ꍇfalseԋp
  */
  //------------------------------------------------------------------------------------------
  bool  AddPersonalToPssFriendSaveData( const gflnet::friends::FriendKey& friendKey )
  {
    gamesystem::GameManager*             gameManager    = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
    gamesystem::GameData*                gameData       = gameManager->GetGameData();
    savedata::PssPersonalSaveData*       friendData     = gameData->GetPssFriendData();
    GFL_ASSERT( friendData );
    netapp::pss::PssPersonalDataManager* pssPersonalMgr = gameManager->GetPssPersonalDataManager();
    netapp::pss::PssPersonalData*        targetPerson   = pssPersonalMgr->GetPersonalData( friendKey );
    GFL_ASSERT( targetPerson );

    return friendData->AddPersonalData( targetPerson );
  }


  //------------------------------------------------------------------------------------------
  /**
  * @brief	Z[uf[^̈̂Ƃ폜(O[o֐)
  *
  * @param	폜ΏۂƂȂthL[
  *
  * @return  폜ꂽȂtrueA폜s̏ꍇfalseԋp
  */
  //------------------------------------------------------------------------------------------
  bool RemovePersonalFromPssFriendSaveData( const gflnet::friends::FriendKey& friendKey )
  {
    gamesystem::GameManager*        gameManager  = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
    gamesystem::GameData*           gameData     = gameManager->GetGameData();
    savedata::PssPersonalSaveData*  friendData = gameData->GetPssFriendData();
    GFL_ASSERT( friendData );

    return friendData->RemovePersonalData( friendKey );
  }


  //------------------------------------------------------------------------------------------
  /**
  * @brief	Z[uf[^̈̂ƂXV(O[o֐)
  *
  * @param	XVΏۂƂȂthL[
  *
  * @return  XVꂽȂtrueAXVɎsꍇfalseԋp
  */
  //------------------------------------------------------------------------------------------
  bool  UpdatePersonalToPssFriendSaveData( const gflnet::friends::FriendKey& friendKey )
  {
    gamesystem::GameManager*             gameManager    = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
    gamesystem::GameData*                gameData       = gameManager->GetGameData();
    savedata::PssPersonalSaveData*       friendData   = gameData->GetPssFriendData();
    GFL_ASSERT( friendData );
    netapp::pss::PssPersonalDataManager* pssPersonalMgr = gameManager->GetPssPersonalDataManager();
    netapp::pss::PssPersonalData*        targetPerson   = pssPersonalMgr->GetPersonalData( friendKey );
    GFL_ASSERT( targetPerson );

    return friendData->UpdatePersonalData( targetPerson );
  }


  //------------------------------------------------------------------------------------------
  /**
  * @brief  Z[uf[^̈̂Ƃ񂪐ɒBĂ邩(O[o֐)
  *
  * @param  none
  *
  * @return  ɒBĂȂtrueA󂫂Ȃfalseԋp
  */
  //------------------------------------------------------------------------------------------
  bool IsFullPssFriendSaveData( void )
  {
    gamesystem::GameManager*        gameManager  = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
    gamesystem::GameData*           gameData     = gameManager->GetGameData();
    savedata::PssPersonalSaveData*  friendData = gameData->GetPssFriendData();
    GFL_ASSERT( friendData );

    return friendData->IsFull();
  }


  //------------------------------------------------------------------------------------------
  /**
  * @brief  wthL[̃[U[Z[uf[^̈̂Ƃɑ݂邩iO[o֐j
  *
  * @param  none
  *
  * @return  ɒBĂȂtrueA󂫂Ȃfalseԋp
  */
  //------------------------------------------------------------------------------------------
  bool IsExistPssFriendSaveData( const gflnet::friends::FriendKey& friendKey )
  {
    gamesystem::GameManager*        gameManager  = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
    gamesystem::GameData*           gameData     = gameManager->GetGameData();
    savedata::PssPersonalSaveData*  friendData = gameData->GetPssFriendData();

    return (friendData->GetPersonalData(friendKey) != NULL);
  }

} //pss_friend









}		// savedata

