//============================================================================================
/**
 * @file		PssPersonalSaveData.h
 * @brief		PSSp[\if[^ۑ
 *
 * namespace	savedata::
 */
//============================================================================================
#include <netapp/pss/PssPersonalData.h>
#include <savedata/PssPersonalSaveData.h>


namespace savedata {

//--------------------------------------------------------------------------------------------
/**
 * @brief		RXgN^
 */
//--------------------------------------------------------------------------------------------
PssPersonalSaveData::PssPersonalSaveData( void )
{
  Reset();
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		fXgN^
 */
//--------------------------------------------------------------------------------------------
PssPersonalSaveData::~PssPersonalSaveData(void)
{
  Reset();
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   Sp[\if[^XgZbg
 */
//--------------------------------------------------------------------------------------------
void PssPersonalSaveData::Reset( void )
{
  for( u32 i = 0; i < m_body.m_registNum; i++ )
  {
    m_body.m_personalData[i].Reset();
  }
  m_body.m_registNum = 0;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   thL[ƂɁAp[\if[^擾
 *
 * @param   friendKey ΏۂƂȂthL[
 *
 * @return  op[\if[^ւ̃|C^Bf[^݂ȂꍇNULLԋp
 */
//--------------------------------------------------------------------------------------------
netapp::pss::PssPersonalData* PssPersonalSaveData::GetPersonalData( const gflnet::friends::FriendKey& friendKey )
{
  for( u32 i = 0; i < m_body.m_registNum; i++ )
  {
    if( m_body.m_personalData[i].IsSameFriendKey(friendKey) ){
      return &(m_body.m_personalData[i]);
    }
  }
  return NULL;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   thL[ƂɁAp[\if[^폜
 *
 * @param   friendKey 폜ΏۂƂȂthL[
 *
 * @return  폜sꂽȂtrueԋp
 */
//--------------------------------------------------------------------------------------------
bool PssPersonalSaveData::RemovePersonalData( const gflnet::friends::FriendKey& friendKey )
{
  u32 listNum = m_body.m_registNum;

  for( u32 i = 0; i < listNum; i++ )
  {
    if( m_body.m_personalData[i].IsSameFriendKey(friendKey) )
    {
      if( i < (listNum-1) )
      {
        // ӏl߂܂
        for( u32 k = i; k < listNum-1; k++ ){
          m_body.m_personalData[k].Copy( m_body.m_personalData[k+1] );
        }
      }
      // K폜
      m_body.m_personalData[listNum-1].Reset();
      m_body.m_registNum--;
      return true;
    }
  }
  return false;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   p[\if[^XV
 *
 * @param   personal   o^Ώۂ̃p[\if[^
 *
 * @return  XVꂽȂtrueAvthL[Ȃۂfalseԋp
 */
//--------------------------------------------------------------------------------------------
bool PssPersonalSaveData::UpdatePersonalData( netapp::pss::PssPersonalData* personal )
{
  netapp::pss::PssPersonalData *target = GetPersonalData( personal->GetFriendKey() );

  if( target != NULL )
  {
    target->Copy( *personal );
    return true;
  }
  return false;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   p[\if[^ǉ
 *
 * @param   personal   ǉΏۂ̃p[\if[^
 *
 * @return  ǉꂽȂtrueA󂫂ȂEf[^łɑ݂ꍇfalseԋp
 */
//--------------------------------------------------------------------------------------------
bool PssPersonalSaveData::AddPersonalData( netapp::pss::PssPersonalData* personal )
{
  if( IsFull() ){
    return false;  // 󂫂Ȃ
  }

  netapp::pss::PssPersonalData *target = GetPersonalData( personal->GetFriendKey() );
  if( target != NULL ){
    return false;   // ɑ݂
  }

  m_body.m_personalData[m_body.m_registNum].Copy( *personal );
  m_body.m_registNum++;

  return true;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   p[\if[^o^
 *
 * @param   none
 *
 * @return  1p[\if[^o^Ȃtrueԋp
 */
//--------------------------------------------------------------------------------------------
bool PssPersonalSaveData::IsEmpty( void ) const
{
  return (GetNum() == 0);
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   p[\if[^lɒBĂ邩
 *
 * @param   none
 *
 * @return  p[\if[^o^lɒBĂȂtrueԋp
 */
//--------------------------------------------------------------------------------------------
bool PssPersonalSaveData::IsFull( void ) const
{
  return (GetNum() == LIST_MAX);
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   Cɓo^Ăp[\if[^擾
 *
 * @param   none
 *
 * @return  o^p[\if[^
 */
//--------------------------------------------------------------------------------------------
u32 PssPersonalSaveData::GetNum( void ) const
{
  return m_body.m_registNum;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   p[\if[^Xg擾
 *          GetNum()Ŏ擾邱
 *
 * @param   none
 *
 * @return  p[\if[^Xgւ̃|C^
 */
//--------------------------------------------------------------------------------------------
netapp::pss::PssPersonalData* PssPersonalSaveData::GetPersonalDataList( void )
{
  return m_body.m_personalData;
}


//------------------------------------------------------------------------------------------
/**
* @brief		ǂݍ񂾃f[^Zbg֐
*
* @param		pData		擪̃|C^
*
* @return	none
*/
//------------------------------------------------------------------------------------------
// @overwride
void PssPersonalSaveData::SetData( void* pData )
{
  SaveBody *saveDat = (SaveBody*)pData;

  m_body.m_registNum = saveDat->m_registNum;
  for( u32 i = 0; i < m_body.m_registNum; i++ )
  {
    m_body.m_personalData[i].Copy( saveDat->m_personalData[i] );
  }
}


//------------------------------------------------------------------------------------------
/**
* @brief		f[^̐擪|C^𓾂֐
*
* @param		none
*
* @return	擪̃|C^
*/
//------------------------------------------------------------------------------------------
// @overwride
void* PssPersonalSaveData::GetData(void)
{
  return &m_body;
}


//------------------------------------------------------------------------------------------
/**
* @brief		f[^TCY
*
* @param		none
*
* @return	oCg
*/
//------------------------------------------------------------------------------------------
// @overwride
size_t PssPersonalSaveData::GetDataSize(void)
{
  return sizeof(SaveBody);
}




}		// savedata

