//============================================================================================
/**
 * @file		PssPersonalSaveData.h
 * @brief		PSSp[\if[^̕ۑ
 *
 * namespace	savedata::
 */
//============================================================================================
#ifndef __PSS_PERSONAL_SAVE_DATA_H__
#define __PSS_PERSONAL_SAVE_DATA_H__

#include <gflib.h>
#include <gflnet.h>

#include <netapp/pss/PssPersonalData.h>
#include <savedata/SaveDataInterface.h>

namespace savedata {


/***********************************************************************************************
 * @brief		PSSp[\if[^̕ۑ
 ***********************************************************************************************/
class PssPersonalSaveData : public SaveDataInterface
{
public:

  // PXgɓo^łő匏
  static const u32   LIST_MAX = 100;

public:
  //--------------------------------------------------------------------------------------------
  /**
   * @brief		RXgN^
   */
  //--------------------------------------------------------------------------------------------
  PssPersonalSaveData( void );

  //--------------------------------------------------------------------------------------------
  /**
   * @brief		fXgN^
   */
  //--------------------------------------------------------------------------------------------
  ~PssPersonalSaveData(void);

  //--------------------------------------------------------------------------------------------
  /**
   * @brief   thL[ƂɁAp[\if[^擾
   *
   * @param   friendKey ΏۂƂȂthL[
   *
   * @return  op[\if[^ւ̃|C^Bf[^݂ȂꍇNULLԋp
   */
  //--------------------------------------------------------------------------------------------
  netapp::pss::PssPersonalData* GetPersonalData( const gflnet::friends::FriendKey& friendKey );

  //--------------------------------------------------------------------------------------------
  /**
   * @brief   p[\if[^XVEǉ
   *
   * @param   personal   o^Ώۂ̃p[\if[^
   *
   * @return  XVꂽȂtrueAvthL[Ȃۂfalseԋp
   */
  //--------------------------------------------------------------------------------------------
  bool UpdatePersonalData( netapp::pss::PssPersonalData* personal );

  //--------------------------------------------------------------------------------------------
  /**
   * @brief   p[\if[^ǉ
   *
   * @param   personal   ǉΏۂ̃p[\if[^
   *
   * @return  ǉtrueA󂫂ȂEf[^łɑ݂ꍇfalseԋp
   */
  //--------------------------------------------------------------------------------------------
  bool AddPersonalData( netapp::pss::PssPersonalData* personal );

  //--------------------------------------------------------------------------------------------
  /**
   * @brief   p[\if[^Xg擾
   *
   * @param   none
   *
   * @return  p[\if[^Xgւ̃|C^
   */
  //--------------------------------------------------------------------------------------------
  netapp::pss::PssPersonalData*  GetPersonalDataList( void );

  //--------------------------------------------------------------------------------------------
  /**
   * @brief   thL[ƂɁAp[\if[^Xg폜
   *
   * @param   friendKey 폜ΏۂƂȂthL[
   *
   * @return  폜sꂽȂtrueԋp
   */
  //--------------------------------------------------------------------------------------------
  bool RemovePersonalData( const gflnet::friends::FriendKey& friendKey );

  //--------------------------------------------------------------------------------------------
  /**
   * @brief   ɍ킹UpdatePssPersonalDataListXV
   *
   * @param   none
   *
   * @return  none
   */
  //--------------------------------------------------------------------------------------------
  void UpdatePssPersonalDataList( void );

  //--------------------------------------------------------------------------------------------
  /**
   * @brief   p[\if[^o^
   *
   * @pram    none
   *
   * @return  1p[\if[^o^Ȃtrueԋp
   */
  //--------------------------------------------------------------------------------------------
  bool IsEmpty( void ) const;

  //--------------------------------------------------------------------------------------------
  /**
   * @brief   p[\if[^lɒBĂ邩
   *
   * @param   none
   *
   * @return  p[\if[^o^lɒBĂȂtrueԋp
   */
  //--------------------------------------------------------------------------------------------
  bool IsFull( void ) const;

  //--------------------------------------------------------------------------------------------
  /**
   * @brief   Cɓo^Ăp[\if[^擾
   *
   * @param   none
   *
   * @return  o^p[\if[^
   */
  //--------------------------------------------------------------------------------------------
  u32 GetNum( void ) const;

  //--------------------------------------------------------------------------------------------
  /**
   * @brief   Sp[\if[^XgZbg
   */
  //--------------------------------------------------------------------------------------------
  void Reset( void );

public:
	//------------------------------------------------------------------------------------------
	/**
	 * @brief		ǂݍ񂾃f[^Zbg֐
	 *
	 * @param		pData		擪̃|C^
	 *
	 * @return	none
	 */
	//------------------------------------------------------------------------------------------
	virtual void SetData( void* pData );

	//------------------------------------------------------------------------------------------
	/**
	 * @brief		f[^̐擪|C^𓾂֐
	 *
	 * @param		none
	 *
	 * @return	擪̃|C^
	 */
	//------------------------------------------------------------------------------------------
	virtual void * GetData(void);

	//------------------------------------------------------------------------------------------
	/**
	 * @brief		f[^TCY
	 *
	 * @param		none
	 *
	 * @return	oCg
	 */
	//------------------------------------------------------------------------------------------
	virtual size_t GetDataSize(void);

  //-----------------------------------------------------------------------------
  /**
   * @brief Z[uf[^̃NA
   * @param heap@NAɎgpe|q[v
   */
  //-----------------------------------------------------------------------------
  virtual void Clear( gfl::heap::HeapBase * heap ) { Reset(); };
  
private:
  typedef struct
  {
    netapp::pss::PssPersonalData  m_personalData[LIST_MAX]; // p[\if[^
    u32                           m_registNum;              // o^
  }SaveBody;

  SaveBody                        m_body;                   // Z[uf[^
};



}	// savedata




#endif // __PSS_PERSONAL_SAVE_DATA_H__

