#
# ruby clean_landdata.rb  landdata_path
#
#   landdatasvȃt@C폜B
#
#

require "#{ENV["PROJECT_ROOT"]}/resource/field/tools/field_datas.rb"

def checkFileName filename, matrixArray
  
  matrixArray.mapMatrixArray.each{|matrix|

    block_x_str = "99"
    block_z_str = "99"
    block_x     = 99
    block_z     = 99
    
    if matrix.checkFileHeader( filename ) then
      #t@CAubNio[擾
      if filename =~ /#{matrix.file_header}([0-9]+)_([0-9]+)/ then
        block_x_str = $1
        block_z_str = $2
        block_x     = block_x_str.to_i
        block_z     = block_z_str.to_i
      end

      #̃ubNio[̃f[^Kv`FbN
      if matrix.IsBlockIdxZoneEnable( block_x, block_z ) == true then
        return true
      end
    end
  }

  return false 
end


def checkFileList array, mapmatrix

  array.each{|file|
    is_use = true
    #t@C`FbN
    is_use = checkFileName( file, mapmatrix )
    if is_use == false then
      #폜
      puts( "delete #{file}" )
      File::unlink( file )
    end 
  }

  
end

begin

  if ARGV.size < 1 then
    puts( "ruby clean_landdata.rb  landdata_path" )
    exit 1
  end

  mapMatrix = MapMatrix.new

  cmdllist = Dir::glob( "#{ARGV[0]}/land_model/*.cmdl" )
  htlist = Dir::glob( "#{ARGV[0]}/land_res/*.ht" )
  binlist = Dir::glob( "#{ARGV[0]}/land_res/*.bin" )
  rdlist = Dir::glob( "#{ARGV[0]}/land_res/*.rd" )
  bmlist = Dir::glob( "#{ARGV[0]}/land_res/*.bmbin" )
  
  checkFileList( cmdllist, mapMatrix )
  checkFileList( htlist, mapMatrix )
  checkFileList( binlist, mapMatrix )
  checkFileList( rdlist, mapMatrix )
  checkFileList( bmlist, mapMatrix )

end
