
//=============================================================================
/**
 * @file   CameraInfo.cpp
 * @brief  JǗNX
 * @author rc N
 * @date   2012.06.01
 */
//=============================================================================

#include "CameraInfo.h"

namespace field
{
  //-----------------------------------------------------------------------------
  // RXgN^
  //-----------------------------------------------------------------------------
  CCameraInfo::CCameraInfo() :
  m_inPosi(gfl::math::VEC3_ZERO) ,
  m_inLookAtPosi(gfl::math::VEC3_UNIT_Z) ,
  m_inDir(gfl::math::VEC3_UNIT_Z) ,
  m_fYaw(0.0f) ,
  m_fPitch(0.0f) ,
  m_fDistToLookAt(1.0f) ,
  m_inMatrix(gfl::math::MTX33_IDENTITY)
  {
    return ;
  }

  //-----------------------------------------------------------------------------
  // 
  //-----------------------------------------------------------------------------
  void CCameraInfo::Init(const gfl::math::VEC3& inLookAtPosi, const float fYaw, const float fPitch, const float fDistToLookAt)
  {
    m_inLookAtPosi = inLookAtPosi;
    m_fYaw   = fYaw;
    m_fPitch = fPitch;
    m_fDistToLookAt = fDistToLookAt;

    CSpace::GetYawPitchBankRotMatrix(&m_inMatrix, gfl::math::VEC3(fYaw, fPitch, 0.0f));
    gfl::math::MTX33GetAxisZ(&m_inDir, m_inMatrix);
    m_inPosi = inLookAtPosi - m_inDir*fDistToLookAt;
  }

} // namespace field

/*  EOF  */





