
//=============================================================================
/**
 * @file   CameraDefaultAngle.cpp
 * @brief  JftHgpxNX
 * @author rc N
 * @date   2012.06.01
 */
//=============================================================================

#include "CameraDefaultAngle.h"

namespace field
{
  //-----------------------------------------------------------------------------
  // RXgN^
  //-----------------------------------------------------------------------------
  CCameraDefaultAngle::CCameraDefaultAngle() :
  m_fYaw(0.0f) ,
  m_fPitch(0.0f)
  {
    return ;
  }

  //-----------------------------------------------------------------------------
  // t[
  //-----------------------------------------------------------------------------
  void CCameraDefaultAngle::Update(const CCameraTarget& inTarget)
  {
    const float PITCH_OFST_DEFAULT = 5.0f;
    m_fYaw   = inTarget.GetYaw();
    m_fPitch = GFL_MATH_DEG_TO_RAD(PITCH_OFST_DEFAULT);
    // MaxMinClip(&m_inDefaultYP[PITCH],CAMERA_PITCH_RADIAN_MAX,CAMERA_PITCH_RADIAN_MIN);
  }

  //-----------------------------------------------------------------------------
  // fobO`
  //-----------------------------------------------------------------------------
  void CCameraDefaultAngle::DrawDebug(const CCameraTarget& inTarget)
  {
#if 0
    gfl::math::VEC3 inDir; CSpace::GetDirectionByYawPitch(&inDir, m_fYaw, m_fPitch);
    CDebugPrim::DrawArrow(inTarget.GetCenterPosition(), inDir, CONVERT_TO_METER(1.0f), VEC4_COLOR_SKY);
#endif
  }
 
} // namespace field

/*  EOF  */



#if 0

// XΊpsb`ItZbg擾
{
	float fPitchOfst = 0.0f;
	const tiVector inNormDir = PCPTR->getLatestGroundTouchPlane().mNormal;
	tiVector inNormDirXZ = inNormDir; inNormDirXZ.y = 0.0f;
	if(gameUtil::checkAndGetNormalizeVector(&inNormDirXZ,NULL,inNormDirXZ,TRUE) == TRUE)
	{
		tiVector inCamDirXZ = inCamera.m_inDir; inCamDirXZ.y = 0.0f;
		inCamDirXZ.normalize3();

		const float fCamRadi   = getACosLimitClip(inCamDirXZ.getScalarProduct3(inNormDirXZ));
		const float fMulCoe    = (getInterpolateRatioValue(fCamRadi,0.0f,TIL_PI) - 0.5f)*2.0f;
		const float fSlopeRadi = gameUtil::getSlopeRadian(inNormDir);
		fPitchOfst = fMulCoe*fSlopeRadi;
		//ghmGcDebugScreen::Print(2,20,"%.1f %.1f %.2f",TIL_TO_DEGREE(fPitchOfst),TIL_TO_DEGREE(fSlopeRadi),fMulCoe);
	}

	return fPitchOfst;
}

#endif





