#[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
#
# @file		mstxt_purser.rb
#	@brief  mstxtp[T[
#	@author	Masayuki Onoue
#	@date		2012.01.16
#
#]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

# ================================================================
# mstxt̓NX
# MSTXT::Document.new(t@C)Ńt@C͂܂
# 
# zƂĎ󂯎肽valuesgA
# nbVƂĎ󂯎肽txt_hashQƂĂB
#
# txt_hash̃L[̓xɂȂĂ܂B
#
# ܂eLXgf[^MSTXT::TextDatãf[^ɂȂĂ܂B
#
# ̑dl
# eLXg݂Ȃꍇ́A󕶎o͂Ă܂
#
# gp----------------------------------------------------------
# test = MSTXT::Document.new("mailbox.mstxt")
# test.values.each{|data|
#  puts data.label
#  puts "hira :"  + data.jpn
#  puts "kanji:"  + data.jpn_kanji
# }
#
# ================================================================

require 'nkf'
require "rexml/document" 
include REXML

class MSTXT
end

# ^Of[^NX
class MSTXT::TagData
  # ANZT[
  attr_accessor :index,:group,:tag_id,:param

  # f[^
  def initialize( index, group, id )
    # ^Oɂ͕K̃f[^݂ĂKv
    @index  = index
    @group  = group
    @tag_id = id
    @param  = Hash.new
  end

  # p[^o^
  def add_param( id, param )
    if @param.key?(id) then 
      raise "p[^㏑邱Ƃ͂ł܂"
    end
    # p[^o^
    @param[id] = param
  end
  
end

# eLXgf[^NX
class MSTXT::TextData
  # ANZT[
  attr_accessor :label, :jpn, :jpn_kanji ,:jpn_comment, :label_index
  
  public
  # f[^
  def initialize( idx )
    @label      = ""
    @jpn        = ""
    @jpn_kanji  = ""
    @jpn_tag_array    = nil
    @kanji_tag_array  = nil
    @jpn_comment      = ""
    @label_index = idx
  end

  # Ђ炪ȕ͂̃^O擾
  def jpn_tag
    # 擾̏ꍇ͉͂ĕԂ
    if @jpn_tag_array == nil then
      @jpn_tag_array = get_tag_array( @jpn )
    end
    return @jpn_tag_array
  end

  # ͂̃^O擾
  def kanji_tag
    # 擾̏ꍇ͉͂ĕԂ
    if @kanji_tag_array == nil then
      @kanji_tag_array = get_tag_array( @jpn_kanji )
    end
    return @kanji_tag_array
  end

  private
  # ^OāAz񉻂
  def get_tag_array( msg )
    tag_array = Array.new

    # K\:*?͍ŒZʒu
    scan_array = msg.scan(/\[.*?\]/)

    # ^OSĂp[X
    scan_array.each_with_index{|tag_str,index|

      # ^O𕪉($1=group,$2=id)
      if tag_str =~ /\[(\S+):(\S+).*\]/ then

        # ^Of[^𐶐
        tag = MSTXT::TagData.new(index,$1,$2)

        # p[^擾(group,id,Ō̃JbR폜A󔒋؂ɕϊ)
        param_list = tag_str.gsub(/\[\S+:\S+\s/,"").gsub(/\]/,"").split("\s")
        
        # p[^𖼑Oƒlɕ
        param_list.each{|param|
          # $1=id,$2=l
          if param =~ /(\S+)="(.*)"/ then
            tag.add_param($1,$2)
          end
        }
        tag_array << tag
      end
    }

    # ^OzԂ
    return tag_array
  end
end

# mstxtf[^{
class MSTXT::Document

  # ANZT[
  attr_reader :txt_hash

  # hLgǂݍ
  def initialize( filename )

    # f[^
    @txt_hash = Hash.new
    
    # t@Cǂݍ
    f = open(filename)
    file_str = f.read
    f.close
    
    # xml
    xmldoc = REXML::Document.new( file_str )
    mstxt_elem = xmldoc.elements["MessageStudioText"]

    # xml
    xmldoc = REXML::Document.new( file_str )
    mstxt_elem = xmldoc.elements["MessageStudioText"]

    # Sx擾
    index = 0
    XPath.each(mstxt_elem,"TextRow"){|text_label|
      
      # eLXgf[^
      txt_data = MSTXT::TextData.new( index )
      index += 1

      # x擾
      txt_data.label = text_label.attributes["Label"]
      XPath.each(text_label,"LanguageCell"){|language_cell|

        # ꔻf
        language = language_cell.attributes["Language"]

        # eLXg̑݊mF
        original_txt = XPath.first( language_cell, "Text" ).text
        if original_txt == nil then
          # message݂Ȃꍇ͋󔒂
          original_txt = ""
        end

        # eLXgf[^擾
        text = get_win31j( original_txt )

        # ꂲƂɕۑ
        case language
          when "JPN"
            txt_data.jpn = text 
          when "JPN_KANJI"
            txt_data.jpn_kanji = text 
        end

      }

      # RgZ
      XPath.each(text_label,"CommentCell"){|comment_cell|

        # ꔻf
        language = comment_cell.attributes["Language"]

        # eLXg̑݊mF
        original_txt = XPath.first( comment_cell, "Comment" ).text
        if original_txt == nil then
          # message݂Ȃꍇ͋󔒂
          original_txt = ""
        end

        # eLXgf[^擾
        text = get_win31j( original_txt )

        # ꂲƂɕۑ
        case language
          when "JPN"
            txt_data.jpn_comment = text 
        end
      }


      # f[^i[
      @txt_hash[txt_data.label] = txt_data
    }

  end
  
  # R[hϊ
  def get_win31j(s)
    if ( RUBY_VERSION < "1.9" )
      return NKF::nkf( '-Wsm0', s )
    else
      return s.encode("Windows-31J")
    end
  end

  # zƂăf[^󂯎
  def values
    return @txt_hash.values
  end
  
  # zƂăf[^󂯎(̕я)
  def values_index
    return @txt_hash.values.sort{ |a, b| a.label_index <=> b.label_index  }
  end

end

