#============================================================================
#
#
#   トレーナーメッセージコンバータ
#   
#   TRID・種類IDからラベルIDを取得するデータを生成
#
#   2012.05.30    hosaka genya
#============================================================================

require 'rubygems'
require 'xml/libxml'

require "#{ENV['PROJECT_ROOT']}/tools/mstxt_purser/mstxt_purser.rb"

require "#{ENV["PROJECT_ROOT"]}tools/headerdata.rb"

IN_FILE_MSTXT = ARGV[0]
IN_TRID = ARGV[1]
IN_KINDID = ARGV[2]
OUT_FILE_TBL_OFS = ARGV[3]
OUT_FILE_TBL = ARGV[4]

headerArray = HeaderDataArray.new()
headerArray.load( IN_TRID )
headerArray.load( IN_KINDID )

txt = MSTXT::Document.new( IN_FILE_MSTXT ) 

#txt.values_index.each_with_index{ |data, index|
#  p data.label
#}


# OFS書き出し
trid_label = ""
hash = Hash.new
hash[0] = 0 #先頭データ
txt.values_index.each_with_index{ |data, index|
  if data.label =~ /(.*)_(TRMSG_.*)/
    if $1 != trid_label
      trid_label = $1
      trid = headerArray.search( trid_label, trid_label )
      hash[ trid ] = index*4
    end
  end
}

output = ""
prekey = 0
hash.sort.each do | key, value |
  # 間を飛ばしていた場合は0を入れる
  i = 1
  while( prekey+i < key )
    output += [0].pack("S")
    i += 1
  end
  prekey = key
  output += [value].pack("S")
#  puts "#{key} : #{value}"
end


out = File.open( OUT_FILE_TBL_OFS, "wb" )
out.write output
out.close

# TBL書き出し
output = ""
trid_label = ""
trcnt = -1
txt.values_index.each_with_index{ |data, index|
  if data.label =~ /(.*)_(TRMSG_.*)/
    trid_label = $1
    kind_label = $2
#    puts "#{trid_label} : #{kind_label}"
    trno = headerArray.search( trid_label, trid_label )
    kind = headerArray.search( kind_label, kind_label )
    output += [ trno ].pack("S");
    output += [ kind ].pack("S");
  end
}

out = File.open( OUT_FILE_TBL, "wb" )
out.write output
out.close





