//======================================================================
/**
 * @file    evolution_util.cpp
 * @brief   |Pip⏕c[
 * @author  tamada
 * @date    2012.05.26
 */
//======================================================================
#include <gflib.h>
#include <pmlib.h>

#include "gamesystem/GameData.h"

#include "poke_tool/evolution_util.h"

#include "field/zone_id.h"
#include "field/EvTime.h"

namespace poke_tool {

//------------------------------------------------------------------------
/**
 */
//------------------------------------------------------------------------
void SetupEvolveSituation(
    pml::pokepara::EvolveSituation * situation,
    gamesystem::GameManager * p_gman )
{
  gamesystem::GameData * gamedata = p_gman->GetGameData();

  situation->is_magnetic_field = false; //@todo
  situation->is_ice_field = false;
  situation->is_moss_field = false;
  situation->is_morning_or_noon = false;
  situation->is_night = false;
  situation->is_device_turned_over = false;
  situation->is_rain = false;

  //ԑт̔
  gamesystem::TimeZone::Zone timezone = field::EvTime::GetTimeZone( gamedata );
  switch ( timezone )
  {
  case gamesystem::TimeZone::MORNING:
  case gamesystem::TimeZone::NOON:
  case gamesystem::TimeZone::EVENING:
    situation->is_morning_or_noon = true;
    break;
  default:
    situation->is_night = true;
    break;
  }
  //ꏊǂ̔
  switch ( gamedata->GetPlayerWork()->GetZoneID() )
  {
  case ZONE_ID_T01: //@todo ꏊŔł悤ɂ
    situation->is_magnetic_field = true;
    situation->is_ice_field = true;
    situation->is_moss_field = true;
    break;
  }
  //V̔
  switch ( p_gman->GetWeatherManager()->GetNowType() )
  {
  case xy_system::weather::TYPE_RAIN_LIGHT:
  case xy_system::weather::TYPE_RAIN:
  case xy_system::weather::TYPE_RAIN_HEAVY:
    situation->is_rain = true;
    break;
  default:
    break;
  }

  gfl::ui::DeviceManager* deviceManager = p_gman->GetUiDeviceManager();
  gfl::ui::Gyroscope* gyro = deviceManager->GetGyroscope( gfl::ui::CTR_DeviceManager::GYROSCOPE_STANDARD );
}

}; //namespace poke_tool

