
//=============================================================================
/**
 * @file   CameraTarget.h
 * @brief  J^[QbgǗNXwb_
 * @author rc N
 * @date   2012.05.31
 */
//=============================================================================

#ifndef __CAMERA_TARGET_H__
#define __CAMERA_TARGET_H__

namespace field
{
  class PlayerGrid;

  //-----------------------------------------------------------------------------
  /**
   * @brief J^[Qbg̏ǗNX
   */
  //-----------------------------------------------------------------------------
  class CCameraTarget
  {
  private:
    const PlayerGrid* m_pTarget;

    gfl::math::MTX34 m_inWorldMat;
    gfl::math::VEC3  m_inCenterPosi;
    gfl::math::VEC3  m_inDir;
    float m_fYaw, m_fPitch;

  public:
    CCameraTarget();
	void Update(const PlayerGrid* pTarget);
    void DrawDebug();
  };

} // namespace field

#endif // __CAMERA_TARGET_H__

/*  EOF  */





